<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="2.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:tns="http://www.dvbern.ch/taxme/GeTax/pp/barcode"
                xmlns="http://www.dvbern.ch/taxme/GeTax/pp/barcode"
>
    <xsl:output method="xml" indent="yes" version="1.0" encoding="UTF-8"/>
    <xsl:variable name="afc" select="document('afcDocument')/doc"/>

    <!-- The first 2 parameters are externally provied from the application -->
    <!-- the others are read from the AFC xml file -->
    <!-- idDecla and departdeces attributes are optiona, so they aren't added automatically -->
    <xsl:param name="P_DATEGENERATION"/>
    <xsl:param name="P_FISCAL_YEAR"/>
    <xsl:param name="P_NO_CTR"/>
    <xsl:param name="P_VERSION"/>
    <xsl:variable name="afc_firstname" select="$afc/fh[@id='PG1']/dr[@f='2'][@c='02']/@v"/>
    <xsl:variable name="afc_lastname" select="$afc/fh[@id='PG1']/dr[@f='2'][@c='01']/@v"/>
    <xsl:variable name="afc_addr" select="$afc/fh[@id='PG1']/dr[@f='1'][@c='04']/@v"/>
    <xsl:variable name="afc_city" select="$afc/fh[@id='PG1']/dr[@f='1'][@c='06']/@v"/>
    <xsl:variable name="afc_zip" select="$afc/fh[@id='PG1']/dr[@f='1'][@c='05']/@v"/>
    <xsl:variable name="afc_sno" select="$afc/fh[@id='PG1']/dr[@f='1'][@c='01']/@v"/>

    <xsl:template match="*">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="@*">
        <xsl:attribute name="{name()}">
            <xsl:value-of select="."/>
        </xsl:attribute>
    </xsl:template>

    <!-- ********** Fehlende FormHeader **********-->
    <xsl:template match="/">
        <xsl:if test="not($afc/fh[@id='PG1'])">
            <xsl:message terminate="yes">ERROR: rollback du P-R. Missing FomrHeader[PG1] !/></xsl:message>
        </xsl:if>
        <xsl:if test="not($afc/fh[@id='PG2'])">
            <xsl:message terminate="yes">ERROR: rollback du P-R. Missing FomrHeader[PG2] !/></xsl:message>
        </xsl:if>
        <xsl:if test="not($afc/fh[@id='D'])">
            <xsl:message terminate="yes">ERROR: rollback du P-R. Missing FomrHeader[D] !/></xsl:message>
        </xsl:if>
        <xsl:if test="not($afc/fh[@id='F'])">
            <xsl:message terminate="yes">ERROR: rollback du P-R. Missing FomrHeader[F] !/></xsl:message>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:template>

    <xsl:template match="/tns:doc">
        <doc>
            <!-- Erstelle MetaData wenn diese noch nicht existiert -->
            <xsl:if test="not(tns:ii)">
                <ii period="{$P_FISCAL_YEAR}" dategeneration="{$P_DATEGENERATION}" provider="DeL" version="{$P_VERSION}"/>
            </xsl:if>
            <!-- Erstelle Identification wenn diese noch nicht existiert -->
            <xsl:if test="not(tns:id)">
                <id firstname="{$afc_firstname}" lastname="{$afc_lastname}" addr="{$afc_addr}" city="{$afc_city}" zip="{$afc_zip}" sno="{$afc_sno}"/>
            </xsl:if>

            <xsl:apply-templates select="node()|@*"/>

            <!-- Fügt diverse  FormHeader <fh> hinzu wenn diese in der AFC Datei existiert aber nicht im Original -->
            <xsl:call-template name="addAFC_Formheader">
                <xsl:with-param name="formHeaderId" select="'A1'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFC_Formheader">
                <xsl:with-param name="formHeaderId" select="'C1'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFC_Formheader">
                <xsl:with-param name="formHeaderId" select="'C2'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFC_Formheader">
                <xsl:with-param name="formHeaderId" select="'D'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFC_Formheader">
                <xsl:with-param name="formHeaderId" select="'F'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFC_Formheader">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFC_Formheader">
                <xsl:with-param name="formHeaderId" select="'PG2'"/>
            </xsl:call-template>

        </doc>
    </xsl:template>

    <!-- ********** Page de garde 1 PG1 **********-->
    <xsl:template match="tns:fh[@id='PG1']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>

            <!-- Wenn der Node PG1 <dr f=1 c=001 nicht exisitert und der Param NO_CTR gestzt ist handelt es sich um das generisch Template wenn kein Original.xml existiert. Hier wird dann der notwendige Node gesetzt.-->
            <xsl:if test="not(tns:fh[@id='PG1']/tns:dr[@f='1'][@c='001']) and $P_NO_CTR">
               <dr f="1" c="001" v="{$P_NO_CTR}"/>
            </xsl:if>

            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'2'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'2'"/>
                <xsl:with-param name="param_c" select="'02'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'2'"/>
                <xsl:with-param name="param_c" select="'03'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'3'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'3'"/>
                <xsl:with-param name="param_c" select="'02'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'3'"/>
                <xsl:with-param name="param_c" select="'03'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'03'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'04'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'05'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'06'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'07'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'071'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'08'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG1'"/>
                <xsl:with-param name="param_f" select="'1'"/>
                <xsl:with-param name="param_c" select="'09'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='2'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='2'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='2'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='2'][@c='02']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='2'][@c='02']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='2'][@c='02']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='2'][@c='03']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='2'][@c='03']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='2'][@c='03']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='3'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='3'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='3'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='3'][@c='02']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='3'][@c='02']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='3'][@c='02']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='3'][@c='03']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='3'][@c='03']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='3'][@c='03']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:choose>
                <xsl:when test="$afc/fh[@id='PG1']/dr[@f='1'][@c='01']">
                    <xsl:attribute name="v">
                        <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='01']/@v"/>
                    </xsl:attribute>
                    <xsl:apply-templates/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message terminate="yes">ERROR: rollback du P-R. Missing DataRecord [f="1"] [c="01"] on FomrHeader[PG1] !/></xsl:message>
                </xsl:otherwise>
            </xsl:choose>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='03']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='03']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='03']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='04']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='04']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='04']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='05']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='05']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='05']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='06']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='06']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='06']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='07']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <!-- I only merge this value if it is not empty -->
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='07']/@v != ''">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='07']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='071']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='071']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='071']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='08']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='08']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='08']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG1']/tns:dr[@f='1'][@c='09']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG1']/dr[@f='1'][@c='09']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG1']/dr[@f='1'][@c='09']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <!-- ********** Page de garde 2 PG2 **********-->
    <xsl:template match="tns:fh[@id='PG2']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG2'"/>
                <xsl:with-param name="param_f" select="'98.20'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG2'"/>
                <xsl:with-param name="param_f" select="'98.40'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG2'"/>
                <xsl:with-param name="param_f" select="'98.43'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'PG2'"/>
                <xsl:with-param name="param_f" select="'98.80'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG2']/tns:dr[@f='98.20'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG2']/dr[@f='98.20'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG2']/dr[@f='98.20'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG2']/tns:dr[@f='98.40'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG2']/dr[@f='98.40'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG2']/dr[@f='98.40'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG2']/tns:dr[@f='98.43'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG2']/dr[@f='98.43'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG2']/dr[@f='98.43'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='PG2']/tns:dr[@f='98.80'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='PG2']/dr[@f='98.80'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='PG2']/dr[@f='98.80'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <!-- ********** Formulaire A1 **********-->
    <xsl:template match="tns:fh[@id='A1']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'A1'"/>
                <xsl:with-param name="param_f" select="'11.10'"/>
                <xsl:with-param name="param_c" select="'007'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='A1']/tns:dr[@f='11.10'][@c='007']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='A1']/dr[@f='11.10'][@c='007']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='A1']/dr[@f='11.10'][@c='007']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <!-- ********** Autres revenus et fortune C1 **********-->
    <xsl:template match="tns:fh[@id='C1']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C1'"/>
                <xsl:with-param name="param_f" select="'13.15'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C1'"/>
                <xsl:with-param name="param_f" select="'13.15'"/>
                <xsl:with-param name="param_c" select="'02'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C1']/tns:dr[@f='13.15'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C1']/dr[@f='13.15'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C1']/dr[@f='13.15'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C1']/tns:dr[@f='13.15'][@c='02']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C1']/dr[@f='13.15'][@c='02']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C1']/dr[@f='13.15'][@c='02']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <!-- ********** Autres revenus et fortune C2 **********-->
    <xsl:template match="tns:fh[@id='C2']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C2'"/>
                <xsl:with-param name="param_f" select="'16.10'"/>
                <xsl:with-param name="param_c" select="'001'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C2'"/>
                <xsl:with-param name="param_f" select="'16.30'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C2'"/>
                <xsl:with-param name="param_f" select="'16.30'"/>
                <xsl:with-param name="param_c" select="'02'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C2'"/>
                <xsl:with-param name="param_f" select="'16.30'"/>
                <xsl:with-param name="param_c" select="'03'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C2'"/>
                <xsl:with-param name="param_f" select="'16.35'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'C2'"/>
                <xsl:with-param name="param_f" select="'16.35'"/>
                <xsl:with-param name="param_c" select="'02'"/>
            </xsl:call-template>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C2']/tns:dr[@f='16.10'][@c='001']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C2']/dr[@f='16.10'][@c='001']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C2']/dr[@f='16.10'][@c='001']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C2']/tns:dr[@f='16.30'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C2']/dr[@f='16.30'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C2']/dr[@f='16.30'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C2']/tns:dr[@f='16.30'][@c='02']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C2']/dr[@f='16.30'][@c='02']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C2']/dr[@f='16.30'][@c='02']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C2']/tns:dr[@f='16.30'][@c='03']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C2']/dr[@f='16.30'][@c='03']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C2']/dr[@f='16.30'][@c='03']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C2']/tns:dr[@f='16.35'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C2']/dr[@f='16.35'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C2']/dr[@f='16.35'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='C2']/tns:dr[@f='16.35'][@c='02']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='C2']/dr[@f='16.35'][@c='02']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='C2']/dr[@f='16.35'][@c='02']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <!-- ********** D1 : Immeubles D **********-->
    <xsl:template match="tns:fh[@id='D']/tns:dr[@f='15.10'][@c='011']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='D']/dr[@f='15.10'][@c='011']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='D']/dr[@f='15.10'][@c='011']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='D']/tns:dr[@f='15.10'][@c='012']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='D']/dr[@f='15.10'][@c='012']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='D']/dr[@f='15.10'][@c='012']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='D']/tns:dr[@f='15.10'][@c='013']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='D']/dr[@f='15.10'][@c='013']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='D']/dr[@f='15.10'][@c='013']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='D']/tns:dr[@f='15.10'][@c='014']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='D']/dr[@f='15.10'][@c='014']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='D']/dr[@f='15.10'][@c='014']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='D']/tns:dr[@f='15.10'][@c='015']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='D']/dr[@f='15.10'][@c='015']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='D']/dr[@f='15.10'][@c='015']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="/tns:doc/tns:fh[@id='D']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>

            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="param_f" select="'15.10'"/>
                <xsl:with-param name="param_c" select="'011'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="param_f" select="'15.10'"/>
                <xsl:with-param name="param_c" select="'012'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="param_f" select="'15.10'"/>
                <xsl:with-param name="param_c" select="'013'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="param_f" select="'15.10'"/>
                <xsl:with-param name="param_c" select="'014'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="param_f" select="'15.10'"/>
                <xsl:with-param name="param_c" select="'015'"/>
            </xsl:call-template>

            <xsl:apply-templates select="/tns:doc/tns:fh[@id='D']/tns:dr"/>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="tableId" select="'1'"/>
            </xsl:call-template>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="tableId" select="'2'"/>
            </xsl:call-template>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="tableId" select="'3'"/>
            </xsl:call-template>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="tableId" select="'4'"/>
            </xsl:call-template>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'D'"/>
                <xsl:with-param name="tableId" select="'5'"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <!-- ********** F : Etat des titres **********-->
    <xsl:template match="tns:fh[@id='F']/tns:dr[@f='4'][@c='01']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='F']/dr[@f='4'][@c='01']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='F']/dr[@f='4'][@c='01']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='F']/tns:dr[@f='4'][@c='02']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='F']/dr[@f='4'][@c='02']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='F']/dr[@f='4'][@c='02']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="tns:fh[@id='F']/tns:dr[@f='4'][@c='03']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>
            <xsl:if test="$afc/fh[@id='F']/dr[@f='4'][@c='03']">
                <xsl:attribute name="v">
                    <xsl:value-of select="$afc/fh[@id='F']/dr[@f='4'][@c='03']/@v"/>
                </xsl:attribute>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>

    <xsl:template match="/tns:doc/tns:fh[@id='F']">
        <xsl:element name="{name()}">
            <xsl:apply-templates select="@*"/>

            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'F'"/>
                <xsl:with-param name="param_f" select="'4'"/>
                <xsl:with-param name="param_c" select="'01'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'F'"/>
                <xsl:with-param name="param_f" select="'4'"/>
                <xsl:with-param name="param_c" select="'02'"/>
            </xsl:call-template>
            <xsl:call-template name="addAFCDataRecord">
                <xsl:with-param name="formHeaderId" select="'F'"/>
                <xsl:with-param name="param_f" select="'4'"/>
                <xsl:with-param name="param_c" select="'03'"/>
            </xsl:call-template>

            <xsl:apply-templates select="/tns:doc/tns:fh[@id='F']/tns:dr"/>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'F'"/>
                <xsl:with-param name="tableId" select="'1'"/>
            </xsl:call-template>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'F'"/>
                <xsl:with-param name="tableId" select="'2'"/>
            </xsl:call-template>

            <xsl:call-template name="replace_block">
                <xsl:with-param name="formHeaderId" select="'F'"/>
                <xsl:with-param name="tableId" select="'3'"/>
            </xsl:call-template>
        </xsl:element>
    </xsl:template>

    <!-- ********** Hilfs Routinen **********-->

    <!-- wenn Block in der Korrektur-Datei vorhanden ist wird dieser genommen, ansonsten jener aus der Original-Datei -->
    <xsl:template name="replace_block">
        <xsl:param name="formHeaderId"/>
        <xsl:param name="tableId"/>
        <xsl:choose>
            <xsl:when test="$afc/fh[@id=$formHeaderId]/tb[@id=$tableId]">
                <xsl:apply-templates select="$afc/fh[@id=$formHeaderId]/tb[@id=$tableId]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:apply-templates select="/tns:doc/tns:fh[@id=$formHeaderId]/tns:tb[@id=$tableId]"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- wenn Datarecord in der Korrektur-Datei vorhanden ist wird dieser genommen, ansonsten jener aus der Original-Datei -->
    <xsl:template name="replace_datarecord">
        <xsl:param name="formHeaderId"/>
        <xsl:param name="param_f"/>
        <xsl:param name="param_c"/>
        <xsl:choose>
            <xsl:when test="$afc/fh[@id=$formHeaderId]/dr[@f=$param_f][@c=$param_c]">
                <xsl:apply-templates select="$afc/fh[@id=$formHeaderId]/dr[@f=$param_f][@c=$param_c]"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:copy-of select="/tns:doc/tns:fh[@id=$formHeaderId]/tns:dr[@f=$param_f][@c=$param_c]"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- setzt Datarecord wenn dieser nicht in der Original-, aber in der Korrektur-Datei vorhanden ist-->
    <xsl:template name="addAFCDataRecord">
        <xsl:param name="formHeaderId"/>
        <xsl:param name="param_f"/>
        <xsl:param name="param_c"/>
        <xsl:if test="not(tns:dr[@f=$param_f][@c=$param_c]) and $afc/fh[@id=$formHeaderId]/dr[@f=$param_f][@c=$param_c]">
            <xsl:apply-templates select="$afc/fh[@id=$formHeaderId]/dr[@f=$param_f][@c=$param_c]"/>
        </xsl:if>
    </xsl:template>

    <!-- erstellt einne ganzen Formheader (<fh> Node) wenn dieser nicht in der Original-, aber in der Korrektur-Datei vorhanden ist-->
    <xsl:template name="addAFC_Formheader">
        <xsl:param name="formHeaderId"/>
        <xsl:if test="not(tns:fh[@id=$formHeaderId]) and $afc/fh[@id=$formHeaderId]">
            <xsl:apply-templates select="$afc/fh[@id=$formHeaderId]"/>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
