/*
 * Decompiled with CFR 0.152.
 */
package nl.garvelink.iban;

import java.math.BigInteger;

public abstract class Modulo97 {
    private static final BigInteger NINETY_SEVEN = new BigInteger("97");

    public static int checksum(CharSequence input) {
        if (input == null || !Modulo97.atLeastFiveNonSpaceCharacters(input)) {
            throw new IllegalArgumentException("The input must be non-null and contain at least five non-space characters.");
        }
        char[] buffer = new char[input.length() * 2];
        int offset = Modulo97.transform(input, 4, input.length(), buffer, 0);
        offset = Modulo97.transform(input, 0, 4, buffer, offset);
        BigInteger sum = new BigInteger(new String(buffer, 0, offset));
        BigInteger remainder = sum.remainder(NINETY_SEVEN);
        return remainder.intValue();
    }

    public static int calculateCheckDigits(CharSequence input) {
        if (input == null || input.length() < 5 || input.charAt(2) != '0' || input.charAt(3) != '0') {
            throw new IllegalArgumentException("The input must be non-null, have a minimum length of five characters, and the characters at indices 2 and 3 must be '0'.");
        }
        return 98 - Modulo97.checksum(input);
    }

    public static int calculateCheckDigits(CharSequence countryCode, CharSequence bban) {
        if (countryCode == null) {
            throw new IllegalArgumentException("countryCode is required but is null.");
        }
        if (bban == null) {
            throw new IllegalArgumentException("bban is required but is null.");
        }
        if (countryCode.length() != 2) {
            throw new IllegalArgumentException(String.format("countryCode should be length 2 but is %d", countryCode.length()));
        }
        if (countryCode.charAt(0) == ' ' || countryCode.charAt(1) == ' ') {
            throw new IllegalArgumentException("countryCode contains space character (0x20).");
        }
        StringBuilder sb = new StringBuilder(countryCode).append("00").append(bban);
        return Modulo97.calculateCheckDigits(sb);
    }

    public static boolean verifyCheckDigits(CharSequence input) {
        return Modulo97.checksum(input) == 1;
    }

    private static int transform(CharSequence src, int srcPos, int srcLen, char[] dest, int destPos) {
        int offset = destPos;
        for (int i = srcPos; i < srcLen; ++i) {
            int tmp;
            char c = src.charAt(i);
            if (c >= '0' && c <= '9') {
                dest[offset++] = c;
                continue;
            }
            if (c >= 'A' && c <= 'Z') {
                tmp = 10 + (c - 65);
                dest[offset++] = (char)(48 + tmp / 10);
                dest[offset++] = (char)(48 + tmp % 10);
                continue;
            }
            if (c >= 'a' && c <= 'z') {
                tmp = 10 + (c - 97);
                dest[offset++] = (char)(48 + tmp / 10);
                dest[offset++] = (char)(48 + tmp % 10);
                continue;
            }
            if (c == ' ') continue;
            throw new IllegalArgumentException("Invalid character '" + c + "'.");
        }
        return offset;
    }

    private static boolean atLeastFiveNonSpaceCharacters(CharSequence input) {
        int lookingFor = 5;
        int max = input.length();
        for (int i = 0; lookingFor > 0 && i < max; ++i) {
            if (input.charAt(i) == ' ') continue;
            --lookingFor;
        }
        return lookingFor == 0;
    }

    private Modulo97() {
    }
}

