/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.ResultSetHelper;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;

public class ResultSetHelperService
implements ResultSetHelper {
    public static final int CLOBBUFFERSIZE = 2048;
    static final int NVARCHAR = -9;
    static final int NCHAR = -15;
    static final int LONGNVARCHAR = -16;
    static final int NCLOB = 2011;
    static final String DEFAULT_DATE_FORMAT = "dd-MMM-yyyy";
    static final String DEFAULT_TIMESTAMP_FORMAT = "dd-MMM-yyyy HH:mm:ss";

    @Override
    public String[] getColumnNames(ResultSet resultSet) throws SQLException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            arrayList.add(resultSetMetaData.getColumnName(i + 1));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    @Override
    public String[] getColumnValues(ResultSet resultSet) throws SQLException, IOException {
        return this.getColumnValues(resultSet, false, DEFAULT_DATE_FORMAT, DEFAULT_TIMESTAMP_FORMAT);
    }

    @Override
    public String[] getColumnValues(ResultSet resultSet, boolean bl) throws SQLException, IOException {
        return this.getColumnValues(resultSet, bl, DEFAULT_DATE_FORMAT, DEFAULT_TIMESTAMP_FORMAT);
    }

    @Override
    public String[] getColumnValues(ResultSet resultSet, boolean bl, String string, String string2) throws SQLException, IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        for (int i = 0; i < resultSetMetaData.getColumnCount(); ++i) {
            arrayList.add(this.getColumnValue(resultSet, resultSetMetaData.getColumnType(i + 1), i + 1, bl, string, string2));
        }
        String[] stringArray = new String[arrayList.size()];
        return arrayList.toArray(stringArray);
    }

    private String handleObject(Object object) {
        return object == null ? "" : String.valueOf(object);
    }

    private String handleBigDecimal(BigDecimal bigDecimal) {
        return bigDecimal == null ? "" : bigDecimal.toString();
    }

    private String handleLong(ResultSet resultSet, int n) throws SQLException {
        long l = resultSet.getLong(n);
        return resultSet.wasNull() ? "" : Long.toString(l);
    }

    private String handleInteger(ResultSet resultSet, int n) throws SQLException {
        int n2 = resultSet.getInt(n);
        return resultSet.wasNull() ? "" : Integer.toString(n2);
    }

    private String handleDate(ResultSet resultSet, int n, String string) throws SQLException {
        Date date = resultSet.getDate(n);
        String string2 = null;
        if (date != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
            string2 = simpleDateFormat.format(date);
        }
        return string2;
    }

    private String handleTime(Time time) {
        return time == null ? null : time.toString();
    }

    private String handleTimestamp(Timestamp timestamp, String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        return timestamp == null ? null : simpleDateFormat.format(timestamp);
    }

    private String getColumnValue(ResultSet resultSet, int n, int n2, boolean bl, String string, String string2) throws SQLException, IOException {
        String string3 = "";
        switch (n) {
            case -7: 
            case 2000: {
                string3 = this.handleObject(resultSet.getObject(n2));
                break;
            }
            case 16: {
                boolean bl2 = resultSet.getBoolean(n2);
                string3 = Boolean.valueOf(bl2).toString();
                break;
            }
            case 2005: 
            case 2011: {
                Clob clob = resultSet.getClob(n2);
                if (clob == null) break;
                string3 = ResultSetHelperService.read(clob);
                break;
            }
            case -5: {
                string3 = this.handleLong(resultSet, n2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                string3 = this.handleBigDecimal(resultSet.getBigDecimal(n2));
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                string3 = this.handleInteger(resultSet, n2);
                break;
            }
            case 91: {
                string3 = this.handleDate(resultSet, n2, string);
                break;
            }
            case 92: {
                string3 = this.handleTime(resultSet.getTime(n2));
                break;
            }
            case 93: {
                string3 = this.handleTimestamp(resultSet.getTimestamp(n2), string2);
                break;
            }
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: {
                String string4 = resultSet.getString(n2);
                if (bl && string4 != null) {
                    string3 = string4.trim();
                    break;
                }
                string3 = string4;
                break;
            }
            default: {
                string3 = "";
            }
        }
        if (string3 == null) {
            string3 = "";
        }
        return string3;
    }

    private static String read(Clob clob) throws SQLException, IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder((int)clob.length());
        Reader reader = clob.getCharacterStream();
        char[] cArray = new char[2048];
        while ((n = reader.read(cArray, 0, cArray.length)) != -1) {
            stringBuilder.append(cArray, 0, n);
        }
        return stringBuilder.toString();
    }
}

