/*
 * Decompiled with CFR 0.152.
 */
package au.com.bytecode.opencsv;

import au.com.bytecode.opencsv.CSVParser;
import au.com.bytecode.opencsv.CSVParserBuilder;
import au.com.bytecode.opencsv.CSVReader;
import java.io.Reader;

public class CSVReaderBuilder {
    final Reader reader;
    int skipLines = 0;
    CSVParserBuilder csvParserBuilder = new CSVParserBuilder();
    CSVParser csvParser = null;

    CSVReaderBuilder(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("Reader may not be null");
        }
        this.reader = reader;
    }

    CSVReaderBuilder withSkipLines(int n) {
        this.skipLines = n <= 0 ? 0 : n;
        return this;
    }

    CSVReaderBuilder withCSVParser(CSVParser cSVParser) {
        this.csvParser = cSVParser;
        return this;
    }

    CSVReader build() {
        CSVParser cSVParser = this.csvParser != null ? this.csvParser : new CSVParser();
        return new CSVReader(this.reader, this.skipLines, cSVParser);
    }
}

