/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.ge.pp.online.integration.xml.teledeclaration;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.Contract;
import org.joda.time.LocalDate;
import org.joda.time.ReadablePartial;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class UnmarshallHelper {
    private static final DateTimeFormatter DATE_FMT = DateTimeFormat.forPattern((String)"dd.MM.yyyy");

    private UnmarshallHelper() {
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable LocalDate parseDate(@Nullable String date) {
        if (date == null) {
            return null;
        }
        return DATE_FMT.parseLocalDate(date);
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String printDate(@Nullable LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return DATE_FMT.print((ReadablePartial)localDate);
    }

    @Contract(value="null -> false")
    public static boolean parseBoolean(@Nullable String bool) {
        if (bool == null) {
            return false;
        }
        if (bool.equals("1")) {
            return true;
        }
        if (bool.equals("0")) {
            return false;
        }
        throw new IllegalArgumentException("Unrecognized boolean format: " + bool);
    }

    @Contract(value="null -> null; !null -> !null")
    public static @Nullable String printBoolean(@Nullable Boolean bool) {
        if (bool == null) {
            return null;
        }
        return bool != false ? "1" : "0";
    }
}

