/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipHelper {
    private static final int BUFFER = 2048;

    private ZipHelper() {
    }

    public static byte[] gzip(byte[] anInputByteArray) {
        try {
            ByteArrayOutputStream aByteArrayOS = new ByteArrayOutputStream();
            GZIPOutputStream out = new GZIPOutputStream(aByteArrayOS);
            out.write(anInputByteArray);
            out.flush();
            out.close();
            aByteArrayOS.flush();
            aByteArrayOS.close();
            return aByteArrayOS.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("gzip failed", e);
        }
    }

    public static byte[] zip(byte[] anInputByteArray, String entryName) {
        try {
            ZipEntry aZipEntry = new ZipEntry(entryName);
            ByteArrayOutputStream aByteArrayOS = new ByteArrayOutputStream();
            ZipOutputStream aZIPOS = new ZipOutputStream(aByteArrayOS);
            aZIPOS.putNextEntry(aZipEntry);
            aZIPOS.write(anInputByteArray);
            aZIPOS.flush();
            aZIPOS.close();
            aByteArrayOS.flush();
            aByteArrayOS.close();
            return aByteArrayOS.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("zip failed", e);
        }
    }

    public static byte[] ungzip(byte[] zipped) {
        try {
            int count;
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            GZIPInputStream zis = new GZIPInputStream(new ByteArrayInputStream(zipped));
            byte[] data = new byte[2048];
            while ((count = zis.read(data, 0, 2048)) != -1) {
                dest.write(data, 0, count);
            }
            dest.flush();
            dest.close();
            return dest.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException("ungzip failed", e);
        }
    }

    public static byte[] unzip(byte[] zipped) {
        try {
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipped));
            ZipEntry entry = zis.getNextEntry();
            if (entry != null) {
                int count;
                byte[] data = new byte[2048];
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
                return dest.toByteArray();
            }
            zis.close();
        }
        catch (Exception e) {
            throw new RuntimeException("unzip failed", e);
        }
        return null;
    }

    public static byte[] unzip(byte[] zipped, String entryName) {
        try {
            ByteArrayOutputStream dest = new ByteArrayOutputStream();
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(zipped));
            ZipEntry entry = zis.getNextEntry();
            while (entry != null) {
                if (entry.getName().equals(entryName)) {
                    int count;
                    byte[] data = new byte[2048];
                    while ((count = zis.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                    dest.close();
                    return dest.toByteArray();
                }
                entry = zis.getNextEntry();
            }
            zis.close();
        }
        catch (Exception e) {
            throw new RuntimeException("unzip failed", e);
        }
        return null;
    }
}

