/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ZpvOrZeroConverter
extends AbstractConverter<Long> {
    private static final long serialVersionUID = 3257852099294148152L;

    public ZpvOrZeroConverter() {
        super(Long.class);
    }

    @Override
    public @Nullable Long getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s != null) {
            s = s.replaceAll("'", "").replaceAll("\u2019", "");
        }
        if (!this.isValid(s)) {
            throw new AbstractConverter.ConvertException("error.format.zpv");
        }
        try {
            return Long.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        if (this.isValid(o.toString())) {
            return o.toString();
        }
        return o.toString();
    }

    private boolean isPruefzifferValid(String sZahl) {
        int iZahl = Integer.valueOf(sZahl);
        int iPruefziffer = iZahl % 10;
        return iPruefziffer == this.berechnenPruefziffer(iZahl);
    }

    private int berechnenPruefziffer(int iZahl) {
        List<Integer> vZiffern = this.ziffernReverse(iZahl /= 10);
        int summe = 0;
        for (int i = 0; i < vZiffern.size(); ++i) {
            if (this.odd(i)) {
                summe += vZiffern.get(i).intValue();
                continue;
            }
            summe += this.querSumme(vZiffern.get(i) * 2);
        }
        return ((summe + 10) / 10 * 10 - summe) % 10;
    }

    public boolean isValid(String sZpv) {
        if (sZpv == null || sZpv.trim().equals("")) {
            return true;
        }
        try {
            if (Integer.parseInt(sZpv) != 0) {
                if (sZpv.length() != 8 && sZpv.length() != 9) {
                    return false;
                }
                return this.isPruefzifferValid(sZpv);
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private List<Integer> ziffernReverse(int iZahl) {
        ArrayList<Integer> vZiffern = new ArrayList<Integer>();
        while (iZahl != 0) {
            vZiffern.add(iZahl % 10);
            iZahl /= 10;
        }
        return vZiffern;
    }

    private boolean odd(int iZahl) {
        return iZahl % 2 != 0;
    }

    private int querSumme(int iZahl) {
        int iQuerSumme = iZahl % 10;
        if (iZahl < 10) {
            return iQuerSumme;
        }
        return iQuerSumme + this.querSumme(iZahl /= 10);
    }

    @Override
    public int getMaxLength() {
        return 10;
    }
}

