/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class YearConverter
extends AbstractConverter<Long> {
    private static final long serialVersionUID = 3763100777723475257L;
    private final Pattern pattern = Pattern.compile("(19|20){1,1}[0-9]{2,2}");

    public YearConverter() {
        super(Long.class);
    }

    @Override
    public @Nullable Long getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() != 4) {
            throw new AbstractConverter.ConvertException("error.format.year");
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.year");
        }
        Long result = Long.valueOf(s);
        if (result.intValue() < 1800) {
            throw new AbstractConverter.ConvertException("error.format.year.min", 1800);
        }
        return result;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return Long.toString(Math.round(((Number)o).doubleValue()));
        }
        return o.toString();
    }

    @Override
    public @NonNull String getUserInputRegExpPattern() {
        return "(19|20){0,1}[0-9]{0,2}";
    }
}

