/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.SelectConverter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RadioConverter
extends SelectConverter {
    private static final long serialVersionUID = 3257005475374315572L;
    private final boolean useShortText;

    public RadioConverter() {
        this(false);
    }

    public RadioConverter(boolean useShortText) {
        this.useShortText = useShortText;
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems,  @NonNull AbstractConverter.ConverterContext ctx) {
        try {
            String key = o.toString();
            OptionItemDTO option = optionItems.get(key, ctx.getLocalizationHelper().getCurrentLocale());
            if (option != null) {
                String text = (this.useShortText ? option.getShortText() : option.getText()).toString();
                if (option.isResourceKey()) {
                    return ctx.getLocalizationHelper().translate(text, new Object[0]);
                }
                return text;
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }
}

