/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.FloatConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PrintZeroConverter<T extends Number>
extends AbstractConverter<T> {
    private static final long serialVersionUID = 1L;
    private final @NonNull NumberConverter<T> nestedConverter;
    private final boolean printZero;

    private static <TargetType extends Number> NumberConverter<TargetType> validateNested(NumberConverter<TargetType> nestedConverter) {
        if (nestedConverter == null) {
            throw new NullPointerException("Nested converter cannot be null.");
        }
        return nestedConverter;
    }

    public PrintZeroConverter(@NonNull NumberConverter<T> nestedConverter, boolean printZero) {
        super(PrintZeroConverter.validateNested(nestedConverter).getTargetType());
        this.nestedConverter = nestedConverter;
        this.printZero = printZero;
    }

    @Override
    public @Nullable T getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        return (T)((Number)this.nestedConverter.getObject(s, optionItems, ctx));
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        Number number;
        if (this.printZero) {
            StringBuffer result = new StringBuffer(this.nestedConverter.getRenderedValue(o, readonly, optionItems, ctx));
            if ("".equals(result.toString())) {
                FloatConverter floatConv;
                result = new StringBuffer("0");
                if (this.nestedConverter instanceof FloatConverter && !(floatConv = (FloatConverter)this.nestedConverter).isDynamicFP()) {
                    int numDec = floatConv.getNumDec();
                    result.append(".");
                    for (int i = 0; i < numDec; ++i) {
                        result.append("0");
                    }
                }
            }
            return result.toString();
        }
        if (o == null) {
            return "";
        }
        if (o instanceof Number && (number = (Number)o).doubleValue() == 0.0) {
            return "";
        }
        return this.nestedConverter.getRenderedValue(o, readonly, optionItems, ctx);
    }

    @Override
    public int getMaxLength() {
        return this.nestedConverter.getMaxLength();
    }

    public String toString() {
        return PrintZeroConverter.class.getSimpleName() + " delegating to " + String.valueOf(this.nestedConverter);
    }
}

