/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IntSimpleConverter
extends AbstractConverter<Long> {
    private static final long serialVersionUID = 3763100777723475257L;
    private final Pattern pattern = Pattern.compile("[0-9]*");
    protected int maxLength;

    public IntSimpleConverter(int maxLength) {
        super(Long.class);
        this.maxLength = maxLength;
    }

    @Override
    public @Nullable Long getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        if (s.length() > this.maxLength) {
            throw new AbstractConverter.ConvertException("error.format.int-simple");
        }
        Matcher m = this.pattern.matcher(s);
        if (!m.matches()) {
            throw new AbstractConverter.ConvertException("error.format.int-simple");
        }
        return Long.valueOf(s);
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return Long.toString(Math.round(((Number)o).doubleValue()));
        }
        return o.toString();
    }

    @Override
    public @NonNull String getUserInputRegExpPattern() {
        return "([0-9]*)";
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }
}

