/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GrundstueckNummerConverter
extends AbstractConverter<String> {
    private static final long serialVersionUID = 3618977871490462256L;
    private final Pattern validatePatternMitPruefziffer = Pattern.compile("([\\d]{4})[-]?([\\d]{2})[-]?([\\d]{6})[-]?([\\d]{3})[-]?([\\d]{3})[-]?([\\d]{1})");
    private final Pattern validatePatternOhnePruefziffer = Pattern.compile("([\\d]{4})[-]?([\\d]{2})[-]?([\\d]{6})[-]?([\\d]{3})[-]?([\\d]{3})");
    private final Pattern inputPattern = Pattern.compile("([\\d]{0,4})[-]?([\\d]{0,2})[-]?([\\d]{0,6})[-]?([\\d]{0,3})[-]?([\\d]{0,3})[-]?([\\d]{0,1})");

    public GrundstueckNummerConverter() {
        super(String.class);
    }

    @Override
    public @Nullable String getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Matcher m = this.validatePatternMitPruefziffer.matcher(s);
        if (!m.matches()) {
            m = this.validatePatternOhnePruefziffer.matcher(s);
            if (!m.matches()) {
                throw new AbstractConverter.ConvertException("error.format.grundstuecknr");
            }
            return m.group(1) + "-" + m.group(2) + "-" + m.group(3) + "-" + m.group(4) + "-" + m.group(5);
        }
        return m.group(1) + "-" + m.group(2) + "-" + m.group(3) + "-" + m.group(4) + "-" + m.group(5) + "-" + m.group(6);
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        if (o == null) {
            return "";
        }
        Matcher m = this.validatePatternMitPruefziffer.matcher(o.toString());
        if (m.matches()) {
            return m.group(1) + "-" + m.group(2) + "-" + m.group(3) + "-" + m.group(4) + "-" + m.group(5) + "-" + m.group(6);
        }
        return o.toString();
    }

    @Override
    public @NonNull String getUserInputRegExpPattern() {
        return this.inputPattern.pattern();
    }
}

