/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.dto.convert.NumberConverter;
import java.text.DecimalFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class FloatConverter
extends NumberConverter<Double> {
    private static final long serialVersionUID = 1L;
    protected int numDec;
    private final DecimalFormat format;
    private final boolean dynamicFP;

    protected FloatConverter(int maxLength, int numDec, DecimalFormat format, boolean dynamicFP) {
        super(Double.class, maxLength);
        if (numDec + 1 >= maxLength) {
            throw new IllegalArgumentException(String.format("Insufficient maximum length (%d) to display %d decimals.", maxLength, numDec));
        }
        this.numDec = numDec;
        this.format = format;
        this.dynamicFP = dynamicFP;
    }

    @Override
    public @Nullable Double getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        try {
            s = s.replaceAll("'", "").replaceAll("\u2019", "");
            this.checkFloatingPointNumberLength(s, this.maxLength, this.numDec);
            return Double.valueOf(s);
        }
        catch (NumberFormatException nfe) {
            throw new AbstractConverter.ConvertException("error.format.float-" + this.numDec, this.maxLength - (this.numDec + 1));
        }
    }

    protected void checkFloatingPointNumberLength(String value, int totalLength, int lengthAfterPoint) {
        int pos = value.indexOf(46);
        if (pos < 0 && value.length() + 1 > totalLength - lengthAfterPoint) {
            throw new NumberFormatException("max length exceeded");
        }
        if (pos >= 0 && pos + 1 > totalLength - lengthAfterPoint) {
            throw new NumberFormatException("max length exceeded");
        }
        if (pos >= 0 && value.length() - pos > lengthAfterPoint + 1) {
            throw new NumberFormatException("max length exceeded");
        }
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        return FloatConverter.getRenderedValue(o, readonly, this.format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRenderedValue(@Nullable Object o, boolean readonly, DecimalFormat format) {
        if (o == null) {
            return "";
        }
        if (o instanceof Number) {
            double value = ((Number)o).doubleValue();
            if (value == 0.0 && readonly) {
                return "";
            }
            DecimalFormat decimalFormat = format;
            synchronized (decimalFormat) {
                return format.format(value);
            }
        }
        return o.toString();
    }

    public int getNumDec() {
        return this.numDec;
    }

    public boolean isDynamicFP() {
        return this.dynamicFP;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength + 1;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("maxLength", this.maxLength).append("numDec", this.numDec).append("dynamicFP", this.dynamicFP).build();
    }
}

