/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto.convert;

import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.util.StyleRegistry;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.FormatHelper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DateConverter
extends AbstractConverter<Date> {
    private static final long serialVersionUID = 3258417239630688823L;
    private final SimpleDateFormat sdfRender;
    protected static final int MIN_YEAR = 1800;

    public DateConverter() {
        this("dd.MM.yyyy");
    }

    public DateConverter(String renderFormat) {
        super(Date.class);
        this.sdfRender = new SimpleDateFormat(renderFormat, Locale.GERMAN);
        this.sdfRender.setTimeZone(ApplicationConfig.TIMEZONE);
    }

    @Override
    public @Nullable Date getObject(@Nullable String s, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) throws AbstractConverter.ConvertException {
        return this.parseString(s);
    }

    public @Nullable Date parseString(@Nullable String s) throws AbstractConverter.ConvertException {
        if (s == null || s.length() <= 0) {
            return null;
        }
        Calendar cal = null;
        try {
            cal = FormatHelper.getCalendar(s);
        }
        catch (Exception e) {
            throw new AbstractConverter.ConvertException("error.format.date", e);
        }
        if (cal == null) {
            throw new AbstractConverter.ConvertException("error.format.date");
        }
        if (cal.get(1) < 1800) {
            throw new AbstractConverter.ConvertException("error.date.min");
        }
        return cal.getTime();
    }

    @Override
    public @Nullable String getRenderedValue(@Nullable Object o, boolean readonly, @Nullable OptionItemsDTO optionItems, @NonNull AbstractConverter.ConverterContext ctx) {
        return this.getRenderedValue(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull String getRenderedValue(@Nullable Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof Date) {
            SimpleDateFormat simpleDateFormat = this.sdfRender;
            synchronized (simpleDateFormat) {
                return this.sdfRender.format((Date)o);
            }
        }
        return o.toString();
    }

    @Override
    public @NonNull String getUserInputRegExpPattern() {
        return "([0-9]{1,2})(\\.?)([0-9]{0,2})(\\.?)([0-9]{0,4})";
    }

    @Override
    public @NonNull String getStyleClass() {
        return StyleRegistry.ITEM_TYPE_INPUT_DATE.getValue();
    }

    @Override
    public int getMaxLength() {
        return 10;
    }
}

