/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class ResourceBundleManager {
    public @NonNull String translate(@NonNull String key, @NonNull Locale locale, Object ... replacementArguments) {
        String str = this.getString(key, locale);
        try {
            return new MessageFormat(str, locale).format(replacementArguments);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot format " + key + "=>'" + str + "' with arguments " + Arrays.toString(replacementArguments), e);
        }
    }

    public boolean containsKey(@NonNull String key, @NonNull Locale locale) {
        return this.getResourceBundle(locale).containsKey(key);
    }

    protected @NonNull String getString(@NonNull String key, @NonNull Locale locale) {
        try {
            return this.getResourceBundle(locale).getString(key);
        }
        catch (MissingResourceException ignored) {
            return "!" + key + "!";
        }
    }

    protected abstract @NonNull ResourceBundle getResourceBundle(@NonNull Locale var1);
}

