/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.engine.LogicModelItem;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.jetbrains.annotations.NotNull;

public class PersistenceReadDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String dataModelKeyTemplate;
    private final String persistenceKeyTemplate;
    private final LogicModelItem.ImportProfile importProfile;

    public PersistenceReadDTO(String dataModelKeyTemplate, String persistenceKeyTemplate, LogicModelItem.ImportProfile importProfile) {
        this.dataModelKeyTemplate = dataModelKeyTemplate;
        this.persistenceKeyTemplate = persistenceKeyTemplate;
        this.importProfile = importProfile;
    }

    public String getDataModelKeyTemplate() {
        return this.dataModelKeyTemplate;
    }

    public String getPersistenceKeyTemplate() {
        return this.persistenceKeyTemplate;
    }

    public String getPersistenceKeyTemplateWithoutLeadingZeros() {
        return this.trimLeadingZeros(this.persistenceKeyTemplate);
    }

    @NotNull
    private String trimLeadingZeros(String entry) {
        return entry.replaceAll("(^|(\\D))0+", "$1");
    }

    public LogicModelItem.ImportProfile getImportProfile() {
        return this.importProfile;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("dmkTemplate", (Object)this.dataModelKeyTemplate).append("pKeyTemplate", (Object)this.persistenceKeyTemplate).append("importProfile", (Object)this.importProfile).build();
    }
}

