/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import java.io.Serializable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MessageItemDTO
implements Serializable {
    private static final long serialVersionUID = 3258410638316549169L;
    public static final int TYPE_OK = 1;
    public static final int TYPE_ERROR = 4;
    public static final int TYPE_WARNING = 2;
    private final @NonNull String key;
    private final @Nullable Object value;
    private final int type;
    private final @Nullable LocalDateTime autohideAfter;

    public MessageItemDTO(@NonNull String key, @Nullable Object value, int type) {
        assert (key != null);
        this.key = key;
        this.value = value;
        this.type = type;
        this.autohideAfter = null;
    }

    public MessageItemDTO(@NonNull String key, @Nullable Object value, int type, @Nullable LocalDateTime autohideAfter) {
        assert (key != null);
        this.key = key;
        this.value = value;
        this.type = type;
        this.autohideAfter = autohideAfter;
    }

    public @NonNull String getKey() {
        return this.key;
    }

    public @Nullable Object getValue() {
        return this.value;
    }

    public int getType() {
        return this.type;
    }

    public @Nullable LocalDateTime getAutohideAfter() {
        return this.autohideAfter;
    }

    public @NonNull Optional<LocalDateTime> autohideAfter() {
        return Optional.ofNullable(this.autohideAfter);
    }

    public boolean isExpired() {
        return this.isExpired(LocalDateTime.now());
    }

    boolean isExpired(@NonNull LocalDateTime reference) {
        return this.autohideAfter().map(reference::isAfter).orElse(false);
    }

    public @NonNull Optional<Duration> autohideDelay() {
        return this.autohideDelay(LocalDateTime.now());
    }

    public @NonNull Optional<Duration> autohideDelay(@NonNull LocalDateTime reference) {
        return this.autohideAfter().map(time -> Duration.between(reference, time)).map(delay -> delay.isNegative() ? Duration.ZERO : delay);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        MessageItemDTO rhs = (MessageItemDTO)obj;
        return new EqualsBuilder().append((Object)this.key, (Object)rhs.key).append(this.value, rhs.value).append(this.type, rhs.type).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.key).append(this.value).append(this.type).toHashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("type", this.type).append("key", (Object)this.key).append("value", this.value).build();
    }
}

