/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import java.io.Serializable;

public class FontDTO
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int STYLE_NORMAL = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    private final String name;
    private final float size;
    private final int style;
    private final ColorDTO color;
    private final float charSpace;
    private final String toStringCache;
    private final float leading;

    public FontDTO(String name, float size, int style, ColorDTO color, float charSpace) {
        this(name, size, style, color, charSpace, size);
    }

    public FontDTO(String name, float size, int style, ColorDTO color, float charSpace, float leading) {
        this.name = name;
        this.size = size;
        this.style = style;
        this.color = color;
        this.charSpace = charSpace;
        this.leading = leading;
        this.toStringCache = name + "-" + size + "-" + style + "-" + String.valueOf(color) + "-" + charSpace;
    }

    public String getName() {
        return this.name;
    }

    public float getSize() {
        return this.size;
    }

    public int getStyle() {
        return this.style;
    }

    public ColorDTO getColor() {
        return this.color;
    }

    public float getCharSpace() {
        return this.charSpace;
    }

    public String getStyletext() {
        if (this.style == 1) {
            return "bold";
        }
        if (this.style == 2) {
            return "italic";
        }
        if (this.style == 4) {
            return "underlined";
        }
        return "";
    }

    public String toString() {
        return this.toStringCache;
    }

    public float getLeading() {
        return this.leading;
    }
}

