/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.transfer.dto;

import ch.dvbern.tax.common.engine.expertdisplay.Barcode2DDataDTO;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.transfer.dto.ColorDTO;
import ch.dvbern.tax.common.transfer.dto.DisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ExpertDisplayInfoDTO
implements DisplayInfoDTO {
    private static final long serialVersionUID = 1L;
    public static final int ALIGNMENT_LEFT = 0;
    public static final int ALIGNMENT_CENTER = 1;
    public static final int ALIGNMENT_RIGHT = 2;
    public static final int TYPE_TEXT = 0;
    public static final int TYPE_RADIO = 1;
    public static final int TYPE_COMBO = 2;
    public static final int TYPE_BOOLEAN = 3;
    public static final int TYPE_TEXTAREA = 4;
    public static final int OUTPUT_NO_PAGE = 0;
    public static final int OUTPUT_FIRST_PAGE = 1;
    public static final int OUTPUT_LAST_PAGE = 2;
    public static final int OUTPUT_EXTRA_PAGES = 4;
    public static final int OUTPUT_ALL_PAGES = 8;
    public static final int MODE_INPUT = 1;
    public static final int MODE_PRINT = 2;
    private final String name;
    private final PageSettingsDTO pagesettings;
    private final PageSettingsDTO extraPagesSettings;
    private final List<ItemDTO> items;
    private final ImageDTO guiBackground;
    private final ImageDTO printBackground;
    private final ImageDTO extraPagesBackground;
    private final List<NavigationDTO> navigationItems;
    private Collection<MessageItemDTO> deleteWarnings = null;
    private Collection<MessageItemDTO> messages = null;
    private final String uniqueItemIdentifier;
    private final String accessKey;
    private final float valuePrintPaddingX;
    private final float valuePrintPaddingY;
    private final boolean reverseWatermarkOverText;

    public ExpertDisplayInfoDTO(String name, PageSettingsDTO pagesettings, PageSettingsDTO extraPagesSettings, List<ItemDTO> items, ImageDTO guiBackground, ImageDTO printBackground, List<NavigationDTO> navigationItems, ImageDTO extraPagesBackground, String uniqueItemIdentifier, String accessKey, int valuePrintPaddingX, int valuePrintPaddingY, boolean reverseWatermarkOverText) {
        this.name = name;
        this.pagesettings = pagesettings;
        this.extraPagesSettings = extraPagesSettings;
        this.items = items;
        this.guiBackground = guiBackground;
        this.printBackground = printBackground;
        this.navigationItems = navigationItems;
        this.extraPagesBackground = extraPagesBackground;
        this.uniqueItemIdentifier = uniqueItemIdentifier;
        this.accessKey = accessKey;
        this.valuePrintPaddingX = valuePrintPaddingX;
        this.valuePrintPaddingY = valuePrintPaddingY;
        this.reverseWatermarkOverText = reverseWatermarkOverText;
    }

    public String getName() {
        return this.name;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public PageSettingsDTO getPageSize() {
        return this.pagesettings;
    }

    public PageSettingsDTO getExtraPagesSize() {
        return this.extraPagesSettings;
    }

    public List<ItemDTO> getItems() {
        return this.items;
    }

    public ImageDTO getGuiBackground() {
        return this.guiBackground;
    }

    public ImageDTO getPrintBackground() {
        return this.printBackground;
    }

    public ImageDTO getExtraPagesBackground() {
        return this.extraPagesBackground;
    }

    public List<NavigationDTO> getNavigationItems() {
        return this.navigationItems;
    }

    public Collection<MessageItemDTO> getMessages() {
        if (this.messages == null) {
            this.refreshMessages();
        }
        return this.messages;
    }

    public String getUniqueItemIdentifier() {
        return this.uniqueItemIdentifier;
    }

    public boolean isReverseWatermarkOverText() {
        return this.reverseWatermarkOverText;
    }

    public void refreshMessages() {
        this.refreshMessages(Collections.emptySet());
    }

    public void refreshMessages(Set<String> dmksToIgnore) {
        this.messages = new LinkedHashSet<MessageItemDTO>();
        if (this.items != null) {
            for (ItemDTO formChild : this.items) {
                if (formChild instanceof ValueItemDTO) {
                    ValueItemDTO valueDTO = (ValueItemDTO)formChild;
                    if (valueDTO.getModelItem() == null || valueDTO.getModelItem().getMessages() == null || dmksToIgnore.contains(valueDTO.getDataModelKey())) continue;
                    this.messages.addAll(valueDTO.getModelItem().getMessages());
                    continue;
                }
                if (formChild instanceof ButtonDTO) {
                    ButtonDTO buttonDto = (ButtonDTO)formChild;
                    if (buttonDto.getMessages() == null) continue;
                    this.messages.addAll(buttonDto.getMessages());
                    continue;
                }
                if (!(formChild instanceof TableDTO)) continue;
                TableDTO tableDTO = (TableDTO)formChild;
                List<TableDTO.RowDTO> rows = tableDTO.getInputRows();
                for (TableDTO.RowDTO rowDTO : rows) {
                    List<?> values = rowDTO.getValues();
                    Iterator<?> iterator = values.iterator();
                    while (iterator.hasNext()) {
                        TableDTO.ValueCellDTO valueCellDTO;
                        if (((TableDTO)formChild).isEnhanced()) {
                            ValueItemDTO valueDTO;
                            Object formElement = iterator.next();
                            if (!(formElement instanceof ValueItemDTO) || (valueDTO = (ValueItemDTO)formElement).getModelItem() == null || valueDTO.getModelItem().getMessages() == null || dmksToIgnore.contains(valueDTO.getDataModelKey())) continue;
                            this.messages.addAll(valueDTO.getModelItem().getMessages());
                            continue;
                        }
                        TableDTO.CellDTO cellDTO = (TableDTO.CellDTO)iterator.next();
                        if (!(cellDTO instanceof TableDTO.ValueCellDTO) || (valueCellDTO = (TableDTO.ValueCellDTO)cellDTO).getModelItem() == null || valueCellDTO.getModelItem().getMessages() == null || dmksToIgnore.contains(valueCellDTO.getDataModelKey())) continue;
                        this.messages.addAll(valueCellDTO.getModelItem().getMessages());
                    }
                }
            }
        }
        Iterator<MessageItemDTO> it = this.messages.iterator();
        while (it.hasNext()) {
            MessageItemDTO msg = it.next();
            if (msg.getKey() != null && msg.getKey().trim().length() >= 1) continue;
            it.remove();
        }
    }

    public boolean isHasMessages() {
        return !this.getMessages().isEmpty();
    }

    public void setDeleteWarnings(Collection<MessageItemDTO> deleteWarnings) {
        this.deleteWarnings = deleteWarnings;
    }

    public Collection<MessageItemDTO> getDeleteWarnings() {
        return this.deleteWarnings;
    }

    public int getState() {
        int result = 1;
        if (this.navigationItems != null) {
            for (NavigationDTO nDTO : this.navigationItems) {
                int state = nDTO.getState();
                if (state == 2 && ModelItemDTO.isMoreImportantState(state, result)) {
                    result = state;
                }
                if (state == 3 && ModelItemDTO.isMoreImportantState(state, result)) {
                    result = state;
                }
                if (state != 4 || !ModelItemDTO.isMoreImportantState(state, result)) continue;
                result = state;
            }
        }
        return result;
    }

    public float getValuePrintPaddingX() {
        return this.valuePrintPaddingX;
    }

    public float getValuePrintPaddingY() {
        return this.valuePrintPaddingY;
    }

    public static String getLabelText(String key, List<LabelDTO.LabelAddOnDTO> labelAddOns, @NonNull AbstractConverter.ConverterContext ctx) {
        if (key == null) {
            return "";
        }
        try {
            if (labelAddOns != null) {
                Object[] values = new Object[labelAddOns.size()];
                for (int i = 0; i < values.length; ++i) {
                    LabelDTO.LabelAddOnDTO addOn = labelAddOns.get(i);
                    AbstractConverter<?> conv = addOn.getRendererAndInputValidator();
                    values[i] = conv.getRenderedValue(addOn.getValue(), false, addOn.getOptionItems(), ctx);
                }
                return ctx.getLocalizationHelper().translate(key, values);
            }
            return ctx.getLocalizationHelper().translate(key, new Object[0]);
        }
        catch (LocalizationHelper.LocalizationHelperException lhe) {
            return lhe.toString();
        }
    }

    public static class NavigationDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int state;
        private final String formName;
        private final String accessKey;
        private final String iconName;
        private final List<NavigationDTO> subItems;
        private final boolean selected;
        private NavigationDTO parent = null;
        private final String tableEntryDMK;
        private final boolean extraForm;
        private final int printState;
        private final String descriptionKey;
        private final List<LabelDTO.LabelAddOnDTO> desciptionAddOns;
        private final boolean deleteable;
        private final boolean editable;
        private final NavigationDTO newEntryItem;
        private final DisplayItemUniqueID uniqueItemIdentifier;
        private boolean printGesamtausdruck;
        private boolean printEinzeldruck;

        public NavigationDTO(int state, String formName, String accessKey, String iconName, List<NavigationDTO> subItems, boolean selected, String tableEntryDMK, boolean extraForm, int printState, String descriptionKey, List<LabelDTO.LabelAddOnDTO> descriptionAddOns, boolean deleteable, boolean editable, NavigationDTO newEntryItem, DisplayItemUniqueID uniqueItemIdentifier, boolean printGesamtausdruck, boolean printEinzeldruck) {
            this.state = state;
            this.formName = formName;
            this.iconName = iconName;
            this.subItems = subItems;
            this.selected = selected;
            this.accessKey = accessKey;
            this.tableEntryDMK = tableEntryDMK;
            this.extraForm = extraForm;
            this.printState = printState;
            this.descriptionKey = descriptionKey;
            this.desciptionAddOns = descriptionAddOns;
            this.deleteable = deleteable;
            this.editable = editable;
            this.newEntryItem = newEntryItem;
            this.uniqueItemIdentifier = uniqueItemIdentifier;
            this.printGesamtausdruck = printGesamtausdruck;
            this.printEinzeldruck = printEinzeldruck;
            if (subItems != null) {
                Iterator<NavigationDTO> iterator = subItems.iterator();
                while (iterator.hasNext()) {
                    NavigationDTO element2;
                    NavigationDTO element = element2 = iterator.next();
                    element.parent = this;
                }
            }
        }

        public String getFormName() {
            return this.formName;
        }

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getIconName() {
            return this.iconName;
        }

        public int getState() {
            return this.state;
        }

        public int getPrintState() {
            return this.printState;
        }

        public List<NavigationDTO> getSubItems() {
            return this.subItems;
        }

        public int getSubItemsCount() {
            if (this.subItems == null) {
                return 0;
            }
            return this.subItems.size();
        }

        public boolean isSelected() {
            return this.selected;
        }

        public NavigationDTO getParent() {
            return this.parent;
        }

        public String getTableEntryDMK() {
            return this.tableEntryDMK;
        }

        public boolean isExtraForm() {
            return this.extraForm;
        }

        public String getDescriptionKey() {
            return this.descriptionKey;
        }

        public List<LabelDTO.LabelAddOnDTO> getDesciptionAddOns() {
            return this.desciptionAddOns;
        }

        public boolean isDeleteable() {
            return this.deleteable;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public NavigationDTO getNewEntryItem() {
            return this.newEntryItem;
        }

        public DisplayItemUniqueID getUniqueItemIdentifier() {
            return this.uniqueItemIdentifier;
        }

        public boolean isPrintGesamtausdruck() {
            return this.printGesamtausdruck;
        }

        public void setPrintGesamtausdruck(boolean printGesamtausdruck) {
            this.printGesamtausdruck = printGesamtausdruck;
        }

        public boolean isPrintEinzeldruck() {
            return this.printEinzeldruck;
        }

        public void setPrintEinzeldruck(boolean printEinzeldruck) {
            this.printEinzeldruck = printEinzeldruck;
        }
    }

    public static class LinkItemDTO
    extends ItemDTO {
        private static final long serialVersionUID = 3258126951381481014L;
        private final String text;
        private final String formularKey;
        private final ColorDTO color;
        private final ColorDTO colorMouseOver;
        private final FontDTO font;

        public LinkItemDTO(int x, int y, int width, int height, String text, String formularKey, ColorDTO color, ColorDTO colorMouseOver, ColorDTO bgColor, FontDTO font, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, 0, uniqueItemIdentifier);
            this.text = text;
            this.formularKey = formularKey;
            this.color = color;
            this.colorMouseOver = colorMouseOver;
            this.font = font;
        }

        public String getFormularKey() {
            return this.formularKey;
        }

        public String getText(@NonNull AbstractConverter.ConverterContext ctx) {
            try {
                return ctx.getLocalizationHelper().translate(this.text, new Object[0]);
            }
            catch (LocalizationHelper.LocalizationHelperException e) {
                return e.toString();
            }
        }

        public ColorDTO getColor() {
            return this.color;
        }

        public ColorDTO getColorMouseOver() {
            return this.colorMouseOver;
        }

        public FontDTO getFont() {
            return this.font;
        }

        @Override
        public String getItemType() {
            return "LINK";
        }
    }

    public static class ValuePositionDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String value;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private Point2D.Float originalPosition = null;
        private Point2D.Float originalSize = null;

        public ValuePositionDTO(String value, int x, int y, int width, int height) {
            this.value = value;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public String getValue() {
            return this.value;
        }

        public int getX() {
            return this.x;
        }

        public int getX(float zoom) {
            return Math.round((float)this.x * zoom);
        }

        public int getY() {
            return this.y;
        }

        public int getY(float zoom) {
            return Math.round((float)this.y * zoom);
        }

        public int getWidth() {
            return this.width;
        }

        public int getWidth(float zoom) {
            return Math.round((float)this.width * zoom);
        }

        public int getHeight() {
            return this.height;
        }

        public int getHeight(float zoom) {
            return Math.round((float)this.height * zoom);
        }

        public Point2D.Float getOriginalPosition() {
            return this.originalPosition;
        }

        public Point2D.Float getOriginalSize() {
            return this.originalSize;
        }

        public void setOriginalSettings(String originalX, String originalY, String originalWidth, String originalHeight) {
            try {
                this.originalPosition = new Point2D.Float(Float.parseFloat(originalX), Float.parseFloat(originalY));
                this.originalSize = new Point2D.Float(Float.parseFloat(originalWidth), Float.parseFloat(originalHeight));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static class PatternDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final float size;
        private final float distance;
        private final ColorDTO color;

        public PatternDTO(float size, float distance, ColorDTO color) {
            this.size = size;
            this.distance = distance;
            this.color = color;
        }

        public float getSize() {
            return this.size;
        }

        public float getDistance() {
            return this.distance;
        }

        public ColorDTO getColor() {
            return this.color;
        }
    }

    public static class TableGridDTO
    extends TableDTO {
        public TableGridDTO(int x, int y, int width, int height, int headerHeight, int formRows, int extraPagesFormRows, FontDTO titleFont, PatternDTO titlePattern, ColorDTO bgColor, List<TableDTO.ColumnDTO> columns, List<TableDTO.RowDTO> rows, int state, boolean readonly, boolean enhanced, int printMode, float rowHeight, float colSpace, String title, ColorDTO borderColor, float extraPagesRowPadding, String dataModelKey, DisplayItemUniqueID uniqueItemIdentifier, boolean headerVisible, boolean editable, int startRow, int endRow, int onlyMultiplesOf, float extraPagesPrintOffsetX, float extraPagesPrintOffsetY) {
            super(x, y, width, height, headerHeight, formRows, extraPagesFormRows, titleFont, titlePattern, bgColor, columns, rows, state, readonly, enhanced, printMode, rowHeight, colSpace, title, borderColor, extraPagesRowPadding, dataModelKey, uniqueItemIdentifier, headerVisible, editable, startRow, endRow, onlyMultiplesOf, extraPagesPrintOffsetX, extraPagesPrintOffsetY);
        }
    }

    public static class TableDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int headerHeight;
        private final int formRows;
        private final int extraPagesFormRows;
        private final FontDTO titleFont;
        private final PatternDTO titlePattern;
        private List<ColumnDTO> printColumns = null;
        private List<ColumnDTO> inputColumns = null;
        private List<ColumnDTO> allColumns = null;
        private final List<RowDTO> printRows;
        private final List<RowDTO> inputRows;
        private final List<RowDTO> allRows;
        private final int state;
        private final boolean readonly;
        private boolean enhanced;
        private final float rowHeight;
        private final float colSpace;
        private final float extraPagesRowPadding;
        private final String title;
        private final String dataModelKey;
        private final String logicModelKey;
        private final ColorDTO borderColor;
        private final boolean editable;
        private final boolean headerVisible;
        private final int startRow;
        private final int endRow;
        private final int onlyMultiplesOf;
        private final float extraPagesPrintOffsetX;
        private final float extraPagesPrintOffsetY;

        public TableDTO(int x, int y, int width, int height, int headerHeight, int formRows, int extraPagesFormRows, FontDTO titleFont, PatternDTO titlePattern, ColorDTO bgColor, List<ColumnDTO> columns, List<RowDTO> rows, int state, boolean readonly, boolean enhanced, int printMode, float rowHeight, float colSpace, String title, ColorDTO borderColor, float extraPagesRowPadding, String dataModelKey, DisplayItemUniqueID uniqueItemIdentifier, boolean headerVisible, boolean editable, int startRow, int endRow, int onlyMultiplesOf, float extraPagesPrintOffsetX, float extraPagesPrintOffsetY) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.extraPagesPrintOffsetX = extraPagesPrintOffsetX;
            this.extraPagesPrintOffsetY = extraPagesPrintOffsetY;
            this.headerHeight = headerHeight;
            this.formRows = formRows;
            this.extraPagesFormRows = extraPagesFormRows;
            this.state = state;
            this.readonly = readonly;
            this.rowHeight = rowHeight;
            this.enhanced = enhanced;
            this.title = title;
            this.titleFont = titleFont;
            this.titlePattern = titlePattern;
            this.colSpace = colSpace;
            this.borderColor = borderColor;
            this.extraPagesRowPadding = extraPagesRowPadding;
            this.dataModelKey = dataModelKey;
            this.logicModelKey = dataModelKey == null ? null : EngineUtil.removeTableIndices(dataModelKey);
            this.headerVisible = headerVisible;
            this.editable = editable;
            this.startRow = startRow;
            this.endRow = endRow;
            if (!enhanced) {
                this.allColumns = columns;
                this.inputColumns = new ArrayList<ColumnDTO>();
                this.printColumns = new ArrayList<ColumnDTO>();
                for (ColumnDTO columnDTO : columns) {
                    if (columnDTO.isInputColumn()) {
                        this.inputColumns.add(columnDTO);
                    }
                    if (!columnDTO.isPrintColumn()) continue;
                    this.printColumns.add(columnDTO);
                }
            }
            this.allRows = rows;
            this.inputRows = new ArrayList<RowDTO>();
            this.printRows = new ArrayList<RowDTO>();
            for (RowDTO rowDTO : rows) {
                if (rowDTO.isInputRow()) {
                    this.inputRows.add(rowDTO);
                }
                if (!rowDTO.isPrintRow()) continue;
                this.printRows.add(rowDTO);
            }
            this.onlyMultiplesOf = onlyMultiplesOf;
        }

        public String getDataModelKey() {
            return this.dataModelKey;
        }

        public String getLogicModelKey() {
            return this.logicModelKey;
        }

        public String getTitle() {
            return this.title;
        }

        public FontDTO getTitleFont() {
            return this.titleFont;
        }

        public PatternDTO getTitlePattern() {
            return this.titlePattern;
        }

        public int getHeaderHeight() {
            return this.headerHeight;
        }

        public int getFormRows() {
            return this.formRows;
        }

        public int getExtraPagesFormRows() {
            return this.extraPagesFormRows;
        }

        public List<ColumnDTO> getInputColumns() {
            return this.inputColumns;
        }

        public List<ColumnDTO> getPrintColumns() {
            return this.printColumns;
        }

        public List<ColumnDTO> getAllColumns() {
            return this.allColumns;
        }

        public List<RowDTO> getInputRows() {
            return this.inputRows;
        }

        public List<RowDTO> getAllRows() {
            return this.allRows;
        }

        public List<RowDTO> getPrintRows() {
            return this.printRows;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public int getState() {
            return this.state;
        }

        public float getRowHeight() {
            return this.rowHeight;
        }

        public float getColSpace() {
            return this.colSpace;
        }

        public boolean isEnhanced() {
            return this.enhanced;
        }

        public ColorDTO getBorderColor() {
            return this.borderColor;
        }

        public float getExtraPagesRowPadding() {
            return this.extraPagesRowPadding;
        }

        @Override
        public String getItemType() {
            return "TABLE";
        }

        public void setEnhanced(boolean enhanced) {
            this.enhanced = enhanced;
        }

        public boolean isHeaderVisible() {
            return this.headerVisible;
        }

        public boolean isEditable() {
            return this.editable;
        }

        public int getStartRow() {
            return this.startRow;
        }

        public int getEndRow() {
            return this.endRow;
        }

        public int getOnlyMultiplesOf() {
            return this.onlyMultiplesOf;
        }

        public float getExtraPagesPrintOffsetX() {
            return this.extraPagesPrintOffsetX;
        }

        public float getExtraPagesPrintOffsetY() {
            return this.extraPagesPrintOffsetY;
        }

        public static class ExtraPagesSumDTO
        extends TextItemDTO {
            private static final long serialVersionUID = 1L;

            public ExtraPagesSumDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
                super(x, y, width, height, font, bgColor, alignment, printMode, uniqueItemIdentifier);
            }

            @Override
            public String getItemType() {
                return "ExtraPagesSumPos";
            }
        }

        public static class ButtonCellDTO
        extends CellDTO {
            private static final long serialVersionUID = 1L;
            private final String commandDmk;
            private final String valueDmk;
            private final String key;
            private final String icon;
            private final String uri;
            private final ModelItemDTO commandItem;

            public ButtonCellDTO(String commandDmk, String valueDmk, String key, String icon, String uri, ModelItemDTO commandItem, int colspan, DisplayItemUniqueID uniqueItemIdentifier, FontDTO font, Render reRender) {
                super(colspan, uniqueItemIdentifier, font, reRender);
                this.commandDmk = commandDmk;
                this.valueDmk = valueDmk;
                this.key = key;
                this.icon = icon;
                this.uri = uri;
                this.commandItem = commandItem;
            }

            public String getCommandDmk() {
                return this.commandDmk;
            }

            public String getValueDmk() {
                return this.valueDmk;
            }

            public String getKey() {
                return this.key;
            }

            public String getIcon() {
                return this.icon;
            }

            public String getUri() {
                return this.uri;
            }

            public ModelItemDTO getCommandItem() {
                return this.commandItem;
            }
        }

        public static class LabelCellDTO
        extends CellDTO {
            private static final long serialVersionUID = 1L;
            private final String key;
            private final List<LabelDTO.LabelAddOnDTO> labelAddOns;

            public LabelCellDTO(String key, List<LabelDTO.LabelAddOnDTO> labelAddOns, int colspan, DisplayItemUniqueID uniqueItemIdentifier, FontDTO font) {
                super(colspan, uniqueItemIdentifier, font, null);
                this.key = key;
                this.labelAddOns = labelAddOns;
            }

            public String getKey() {
                return this.key;
            }

            public String getText(@NonNull AbstractConverter.ConverterContext ctx) {
                return ExpertDisplayInfoDTO.getLabelText(this.key, this.labelAddOns, ctx);
            }

            public List<LabelDTO.LabelAddOnDTO> getLabelAddOns() {
                return this.labelAddOns;
            }

            @Override
            public @NonNull String toString() {
                return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.key).build();
            }
        }

        public static class ValueCellDTO
        extends CellDTO {
            private static final long serialVersionUID = 1L;
            private final String dmk;
            private ModelItemDTO modelItem;
            private final OptionItemsDTO optionItems;

            public ValueCellDTO(String dmk, ModelItemDTO modelItem, OptionItemsDTO optionItems, int colspan, DisplayItemUniqueID uniqueItemIdentifier, FontDTO font, Render reRender) {
                super(colspan, uniqueItemIdentifier, font, reRender);
                this.dmk = dmk;
                this.modelItem = modelItem;
                this.optionItems = optionItems;
            }

            public String getDataModelKey() {
                return this.dmk;
            }

            public ModelItemDTO getModelItem() {
                return this.modelItem;
            }

            public void setModelItem(ModelItemDTO modelItem) {
                this.modelItem = modelItem;
            }

            public OptionItemsDTO getOptionItems() {
                return this.optionItems;
            }
        }

        public static abstract class CellDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private int colspan;
            private final DisplayItemUniqueID uniqueItemIdentifier;
            private final FontDTO font;
            private final Render reRender;

            protected CellDTO(int colspan, DisplayItemUniqueID uniqueItemIdentifier, FontDTO font, Render reRender) {
                this.colspan = colspan;
                this.uniqueItemIdentifier = uniqueItemIdentifier;
                this.font = font;
                this.reRender = reRender;
            }

            public int getColspan() {
                return this.colspan;
            }

            public void setColspan(int colspan) {
                this.colspan = colspan;
            }

            public DisplayItemUniqueID getUniqueItemIdentifier() {
                return this.uniqueItemIdentifier;
            }

            public FontDTO getFont() {
                return this.font;
            }

            public Render getReRender() {
                return this.reRender;
            }

            public String toString() {
                return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append((Object)this.uniqueItemIdentifier).append(this.colspan).append((Object)this.reRender).build();
            }
        }

        public static class RowDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final int state;
            private final List<?> values;
            private final String dataModelKey;
            private final boolean printRow;
            private final boolean inputRow;
            private final boolean emptyRow;
            private final DisplayItemUniqueID uniqueItemIdentifier;

            public RowDTO(int state, List<?> values, String dataModelKey, boolean printRow, boolean inputRow, DisplayItemUniqueID uniqueItemIdentifier, boolean emptyRow) {
                this.state = state;
                this.values = values;
                this.dataModelKey = dataModelKey;
                this.printRow = printRow;
                this.inputRow = inputRow;
                this.emptyRow = emptyRow;
                this.uniqueItemIdentifier = uniqueItemIdentifier;
            }

            public int getState() {
                return this.state;
            }

            public List<?> getValues() {
                return this.values;
            }

            public String getDataModelKey() {
                return this.dataModelKey;
            }

            public boolean isInputRow() {
                return this.inputRow;
            }

            public boolean isEmptyRow() {
                return this.emptyRow;
            }

            public boolean isPrintRow() {
                return this.printRow;
            }

            public DisplayItemUniqueID getUniqueItemIdentifier() {
                return this.uniqueItemIdentifier;
            }

            public String toString() {
                return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.dataModelKey).append(this.state).append(this.values != null ? Integer.valueOf(this.values.size()) : null).build();
            }
        }

        public static class ColumnDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final String title;
            private final int type;
            private final int width;
            private final int alignment;
            private final boolean readonly;
            private final FontDTO font;
            private final FontDTO cellFont;
            private final ColorDTO background;
            private final AbstractConverter<?> rendererAndInputValidator;
            private final Map<String, ValuePositionDTO> valuePositions;
            private final boolean extraPagesSum;
            private final String extraPagesSumKey;
            private final int printMode;
            private final boolean inputColumn;
            private final ExtraPagesSumDTO extraPagesSumPos;
            private final boolean submitOnChange;
            private final boolean autoWidthOnFocus;
            private final DisplayItemUniqueID uniqueItemIdentifier;
            private final String shortHelpKey;

            public ColumnDTO(String title, int type, int width, int alignment, boolean readonly, FontDTO font, ColorDTO background, AbstractConverter<?> rendererAndInputValidator, Map<String, ValuePositionDTO> valuePositions, boolean extraPagesSum, String extraPagesSumKey, int printMode, boolean inputColumn, ExtraPagesSumDTO extraPagesSumPos, boolean submitOnChange, boolean autoWidthOnFocus, DisplayItemUniqueID uniqueItemIdentifier, String shortHelpKey, FontDTO cellFont) {
                this.title = title;
                this.type = type;
                this.width = width;
                this.alignment = alignment;
                this.readonly = readonly;
                this.font = font;
                this.background = background;
                this.rendererAndInputValidator = rendererAndInputValidator;
                this.valuePositions = valuePositions;
                this.inputColumn = inputColumn;
                this.printMode = printMode;
                this.extraPagesSum = extraPagesSum;
                this.extraPagesSumKey = extraPagesSumKey;
                this.extraPagesSumPos = extraPagesSumPos;
                this.submitOnChange = submitOnChange;
                this.autoWidthOnFocus = autoWidthOnFocus;
                this.uniqueItemIdentifier = uniqueItemIdentifier;
                this.shortHelpKey = shortHelpKey;
                this.cellFont = cellFont;
            }

            public int getAlignment() {
                return this.alignment;
            }

            public ColorDTO getBackground() {
                return this.background;
            }

            public FontDTO getFont() {
                return this.font;
            }

            public boolean isReadonly() {
                return this.readonly;
            }

            public AbstractConverter<?> getRendererAndInputValidator() {
                return this.rendererAndInputValidator;
            }

            public String getTitle() {
                return this.title;
            }

            public int getType() {
                return this.type;
            }

            public String getShortHelpKey() {
                return this.shortHelpKey;
            }

            public int getWidth() {
                return this.width;
            }

            public int getWidth(float zoom) {
                return Math.round((float)this.width * zoom);
            }

            public Map<String, ValuePositionDTO> getValuePositions() {
                return this.valuePositions;
            }

            public boolean isInputColumn() {
                return this.inputColumn;
            }

            public boolean isPrintColumn() {
                return this.printMode != 0;
            }

            public int getPrintMode() {
                return this.printMode;
            }

            public boolean isExtraPagesSum() {
                return this.extraPagesSum;
            }

            public String getExtraPagesSumKey() {
                return this.extraPagesSumKey;
            }

            public ExtraPagesSumDTO getExtraPagesSumPos() {
                return this.extraPagesSumPos;
            }

            public boolean isSubmitOnChange() {
                return this.submitOnChange;
            }

            public boolean isAutoWidthOnFocus() {
                return this.autoWidthOnFocus;
            }

            public DisplayItemUniqueID getUniqueItemIdentifier() {
                return this.uniqueItemIdentifier;
            }

            public String getAlignmentString() {
                if (this.alignment == 2) {
                    return "right";
                }
                if (this.alignment == 1) {
                    return "center";
                }
                return "left";
            }

            public FontDTO getDefaultCellFont() {
                return this.cellFont;
            }
        }
    }

    public static class ValueItemDTO
    extends TextItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int type;
        private final String dataModelKey;
        private ModelItemDTO modelItem;
        private final OptionItemsDTO optionItems;
        private final boolean readonly;
        private final boolean autoWidthOnFocus;
        private final AbstractConverter<?> rendererAndInputValidator;
        private final Map<String, ValuePositionDTO> valuePositions;
        private final String shortHelpKey;
        private final Render reRender;

        @Override
        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).appendSuper(super.toString()).append((Object)this.dataModelKey).append((Object)this.modelItem).append(this.readonly).append(this.type).append((Object)this.reRender).append((Object)this.shortHelpKey).build();
        }

        public ValueItemDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, int type, String dataModelKey, ModelItemDTO modelItem, OptionItemsDTO optionItems, boolean readonly, AbstractConverter<?> rendererAndInputValidator, Map<String, ValuePositionDTO> valuePositions, int printMode, boolean submitOnChange, boolean autoWidthOnFocus, DisplayItemUniqueID uniqueItemIdentifier, String shortHelpKey, Render reRender) {
            super(x, y, width, height, font, bgColor, alignment, printMode, uniqueItemIdentifier);
            this.type = type;
            this.dataModelKey = dataModelKey;
            this.modelItem = modelItem;
            this.optionItems = optionItems;
            this.readonly = readonly;
            this.rendererAndInputValidator = rendererAndInputValidator;
            this.valuePositions = valuePositions;
            this.autoWidthOnFocus = autoWidthOnFocus;
            this.shortHelpKey = shortHelpKey;
            this.reRender = reRender;
        }

        public int getType() {
            return this.type;
        }

        public String getInputType() {
            if (this.type == 0) {
                return "TEXT";
            }
            if (this.type == 4) {
                return "TEXTAREA";
            }
            if (this.type == 1) {
                return "RADIO";
            }
            if (this.type == 2) {
                return "COMBO";
            }
            if (this.type == 3) {
                return "BOOLEAN";
            }
            return "UNKNOWN";
        }

        public String getDataModelKey() {
            return this.dataModelKey;
        }

        public ModelItemDTO getModelItem() {
            return this.modelItem;
        }

        public void setModelItem(ModelItemDTO modelItem) {
            this.modelItem = modelItem;
        }

        public OptionItemsDTO getOptionItems() {
            return this.optionItems;
        }

        public boolean isReadonly() {
            return this.readonly;
        }

        public AbstractConverter<?> getRendererAndInputValidator() {
            return this.rendererAndInputValidator;
        }

        public Map<String, ValuePositionDTO> getValuePositions() {
            return this.valuePositions;
        }

        @Override
        public String getItemType() {
            return "VALUE";
        }

        public boolean isAutoWidthOnFocus() {
            return this.autoWidthOnFocus;
        }

        public String getShortHelpKey() {
            return this.shortHelpKey;
        }

        public Render getReRender() {
            return this.reRender;
        }
    }

    public static class Barcode2DDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int x;
        private final int y;

        public Barcode2DDTO(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    public static class Barcode2DContainerDTO
    extends ItemDTO {
        private static final long serialVersionUID = 1L;
        public static final int MACRO_PDF417 = 1;
        public static final int DVB_SCAN = 2;
        private final int errorCorrection;
        private final int length;
        private final int columns;
        private final int rows;
        private final int rowHeight;
        private final int type;
        private final float aspectRatio;
        private final Barcode2DDataDTO data;
        private final String key;
        private final List<Barcode2DDTO> barcodes;

        public Barcode2DContainerDTO(int x, int y, int width, int height, ColorDTO bgColor, Barcode2DDataDTO data, String key, List<Barcode2DDTO> barcodes, int length, int errorCorrection, float aspectRatio, int rowHeight, int type, int columns, int rows, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, 1, uniqueItemIdentifier);
            if (data != null == (key != null)) {
                throw new IllegalArgumentException(String.format("Exactly one of barcode data or barcode key must be provided (data: %s / key: %s).", data, key));
            }
            this.data = data;
            this.key = key;
            this.barcodes = barcodes;
            this.length = length;
            this.errorCorrection = errorCorrection;
            this.aspectRatio = aspectRatio;
            this.rowHeight = rowHeight;
            this.type = type;
            this.rows = rows;
            this.columns = columns;
        }

        public Barcode2DDataDTO getData() {
            return this.data;
        }

        public String getKey() {
            return this.key;
        }

        public List<Barcode2DDTO> getBarcodes() {
            return this.barcodes;
        }

        public int getLength() {
            return this.length;
        }

        public int getErrorCorrection() {
            return this.errorCorrection;
        }

        public float getAspectRatio() {
            return this.aspectRatio;
        }

        public int getRowHeight() {
            return this.rowHeight;
        }

        public int getType() {
            return this.type;
        }

        public int getColumns() {
            return this.columns;
        }

        public int getRows() {
            return this.rows;
        }

        @Override
        public String getItemType() {
            return "BARCODE_2D";
        }
    }

    public static class Barcode1DDTO
    extends ItemDTO {
        private static final long serialVersionUID = 3616445696228931897L;
        public static final int CODE39 = 1;
        public static final int CODE128 = 2;
        private final ModelItemDTO modelItem;
        private final int type;
        private final int barHeight;
        private final int textSize;
        private final float minBarWidth;
        private final float relBarWidth;

        public Barcode1DDTO(int x, int y, int width, int height, ColorDTO bgColor, int barHeight, float minBarWidth, float relBarWidth, int textSize, ModelItemDTO modelItem, int type, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            if (modelItem == null) {
                throw new NullPointerException("Model item cannot be null");
            }
            this.modelItem = modelItem;
            this.type = type;
            this.barHeight = barHeight;
            this.minBarWidth = minBarWidth;
            this.textSize = textSize;
            this.relBarWidth = relBarWidth;
        }

        public ModelItemDTO getModelItem() {
            return this.modelItem;
        }

        public int getType() {
            return this.type;
        }

        public int getBarHeight() {
            return this.barHeight;
        }

        public int getTextSize() {
            return this.textSize;
        }

        public float getMinBarWidth() {
            return this.minBarWidth;
        }

        public float getRelBarWidth() {
            return this.relBarWidth;
        }

        @Override
        public String getItemType() {
            return "BARCODE";
        }
    }

    public static class ListDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final List<RowDTO> rows;
        private final FontDTO font;
        private final int rowHeight;
        private final int maxChars;

        public ListDTO(int x, int y, int width, int height, int rowHeight, FontDTO font, ColorDTO bgColor, List<RowDTO> rows, int printMode, DisplayItemUniqueID uniqueItemIdentifier, int maxChars) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.rows = rows;
            this.font = font;
            this.rowHeight = rowHeight;
            this.maxChars = maxChars;
        }

        public FontDTO getFont() {
            return this.font;
        }

        public List<RowDTO> getRows() {
            return this.rows;
        }

        public int getRowHeight() {
            return this.rowHeight;
        }

        @Override
        public String getItemType() {
            return "LIST";
        }

        public int getMaxChars() {
            return this.maxChars;
        }

        public static class LabelRowDTO
        extends RowDTO {
            private static final long serialVersionUID = 1L;
            private final String key;
            private final List<LabelDTO.LabelAddOnDTO> labelAddOns;
            private final String listItemChar;
            private final FontDTO font;

            public LabelRowDTO(String key, List<LabelDTO.LabelAddOnDTO> labelAddOns, String listItemChar, FontDTO font) {
                this.key = key;
                this.labelAddOns = labelAddOns;
                this.listItemChar = listItemChar;
                this.font = font;
            }

            public String getKey() {
                return this.key;
            }

            public List<LabelDTO.LabelAddOnDTO> getLabelAddOns() {
                return this.labelAddOns;
            }

            @Override
            public @Nullable String getListItemChar() {
                return this.listItemChar;
            }

            @Override
            public @Nullable FontDTO getFont() {
                return this.font;
            }

            public String getText(@NonNull AbstractConverter.ConverterContext ctx) {
                return ExpertDisplayInfoDTO.getLabelText(this.key, this.labelAddOns, ctx);
            }
        }

        public static class ValueRowDTO
        extends RowDTO {
            private static final long serialVersionUID = 1L;
            private final ModelItemDTO modelItem;
            private final AbstractConverter<?> converter;
            private final OptionItemsDTO optionItems;

            public ValueRowDTO(ModelItemDTO item, AbstractConverter<?> converter, OptionItemsDTO optionItems) {
                this.converter = converter;
                this.modelItem = item;
                this.optionItems = optionItems;
            }

            public AbstractConverter<?> getConverter() {
                return this.converter;
            }

            public ModelItemDTO getModelItem() {
                return this.modelItem;
            }

            public OptionItemsDTO getOptionItems() {
                return this.optionItems;
            }

            @Override
            public @Nullable String getListItemChar() {
                return null;
            }

            @Override
            public @Nullable FontDTO getFont() {
                return null;
            }
        }

        public static abstract class RowDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;

            public abstract @Nullable String getListItemChar();

            public abstract @Nullable FontDTO getFont();
        }
    }

    public static class WizardLinkDTO
    extends LabelDTO {
        private static final long serialVersionUID = 1L;
        private final String wizardDmk;
        private final int state;

        public WizardLinkDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, String key, List<LabelDTO.LabelAddOnDTO> labelAddOns, String wizardDmk, int state, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, font, bgColor, alignment, key, labelAddOns, 0, uniqueItemIdentifier);
            this.wizardDmk = wizardDmk;
            this.state = state;
        }

        public String getWizardDmk() {
            return this.wizardDmk;
        }

        public int getState() {
            return this.state;
        }

        @Override
        public String getItemType() {
            return "WIZARDLINK";
        }
    }

    public static class LabelDTO
    extends TextItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String key;
        private final List<LabelAddOnDTO> labelAddOns;
        private String toString = null;

        public LabelDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, String key, List<LabelAddOnDTO> labelAddOns, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, font, bgColor, alignment, printMode, uniqueItemIdentifier);
            this.key = key;
            this.labelAddOns = labelAddOns;
        }

        public String getKey() {
            return this.key;
        }

        public String getText(@NonNull AbstractConverter.ConverterContext ctx) {
            return ExpertDisplayInfoDTO.getLabelText(this.key, this.labelAddOns, ctx);
        }

        @Override
        public String getItemType() {
            return "LABEL";
        }

        public List<LabelAddOnDTO> getLabelAddOns() {
            return this.labelAddOns;
        }

        @Override
        public String toString() {
            if (this.toString == null) {
                StringBuilder sb = new StringBuilder();
                sb.append(this.key);
                if (this.labelAddOns != null && !this.labelAddOns.isEmpty()) {
                    sb.append(" {");
                    for (LabelAddOnDTO element : this.labelAddOns) {
                        sb.append(element.toString());
                        sb.append(',');
                    }
                    sb.append('}');
                }
                this.toString = sb.toString();
            }
            return this.toString;
        }

        public static class LabelAddOnDTO
        implements Serializable {
            private static final long serialVersionUID = 1L;
            private final Object value;
            private final AbstractConverter<?> rendererAndInputValidator;
            private final OptionItemsDTO optionItems;

            public LabelAddOnDTO(Object value, AbstractConverter<?> rendererAndInputValidator, OptionItemsDTO optionItems) {
                this.value = value;
                this.rendererAndInputValidator = rendererAndInputValidator;
                this.optionItems = optionItems;
            }

            public Object getValue() {
                return this.value;
            }

            public OptionItemsDTO getOptionItems() {
                return this.optionItems;
            }

            public AbstractConverter<?> getRendererAndInputValidator() {
                return this.rendererAndInputValidator;
            }

            public String toString() {
                if (this.value == null) {
                    return "";
                }
                return this.value.toString();
            }
        }
    }

    public static class RectangleDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final ColorDTO borderColor;
        private final float borderWidth;

        public RectangleDTO(int x, int y, int width, int height, ColorDTO bgColor, ColorDTO borderColor, float borderWidth, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.borderWidth = borderWidth;
            this.borderColor = borderColor;
        }

        public ColorDTO getBorderColor() {
            return this.borderColor;
        }

        public float getBorderWidth() {
            return this.borderWidth;
        }

        @Override
        public String getItemType() {
            return "RECTANGLE";
        }
    }

    public static abstract class TextItemDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final FontDTO font;
        private final int alignment;

        protected TextItemDTO(int x, int y, int width, int height, FontDTO font, ColorDTO bgColor, int alignment, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.font = font;
            this.alignment = alignment;
        }

        public FontDTO getFont() {
            return this.font;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public String getAlignmentString() {
            if (this.alignment == 2) {
                return "right";
            }
            if (this.alignment == 1) {
                return "center";
            }
            return "left";
        }
    }

    public static class ButtonDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String commandDmk;
        private final String valueDmk;
        private final String key;
        private final String icon;
        private final String uri;
        private final ModelItemDTO commandItem;
        private final int state;
        private final Collection<MessageItemDTO> messages;
        private final String target;
        private final Render reRender;

        public ButtonDTO(int x, int y, int width, int height, ColorDTO bgColor, String commandDmk, String valueDmk, String key, String icon, String uri, int state, ModelItemDTO commandItem, DisplayItemUniqueID uniqueItemIdentifier, Collection<MessageItemDTO> messages, String target, Render reRender) {
            super(x, y, width, height, bgColor, 0, uniqueItemIdentifier);
            this.commandDmk = commandDmk;
            this.valueDmk = valueDmk;
            this.key = key;
            this.icon = icon;
            this.uri = uri;
            this.state = state;
            this.commandItem = commandItem;
            this.messages = messages == null ? new ArrayList(0) : messages;
            this.target = target;
            this.reRender = reRender;
        }

        public String getCommandDmk() {
            return this.commandDmk;
        }

        public String getValueDmk() {
            return this.valueDmk;
        }

        public String getKey() {
            return this.key;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getUri() {
            return this.uri;
        }

        public int getState() {
            return this.state;
        }

        @Override
        public String getItemType() {
            return "BUTTON";
        }

        public ModelItemDTO getCommandItem() {
            return this.commandItem;
        }

        public Collection<MessageItemDTO> getMessages() {
            return this.messages;
        }

        public String getTarget() {
            return this.target;
        }

        public Render getReRender() {
            return this.reRender;
        }
    }

    public static class ImageDTO
    extends ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private String fileName;
        private final int page;

        public ImageDTO(int x, int y, int width, int height, ColorDTO bgColor, String fileName, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
            this(x, y, width, height, bgColor, fileName, 1, printMode, uniqueItemIdentifier);
            this.fileName = fileName;
        }

        public ImageDTO(int x, int y, int width, int height, ColorDTO bgColor, String fileName, int page, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
            super(x, y, width, height, bgColor, printMode, uniqueItemIdentifier);
            this.fileName = fileName;
            this.page = page;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getPage() {
            return this.page;
        }

        @Override
        public String getItemType() {
            return "IMAGE";
        }
    }

    public static abstract class ItemDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private final ColorDTO bgColor;
        private final int printMode;
        private final DisplayItemUniqueID uniqueItemIdentifier;
        private Point2D.Float originalPosition = null;
        private Point2D.Float originalSize = null;

        protected ItemDTO(int x, int y, int width, int height, ColorDTO bgColor, int printMode, DisplayItemUniqueID uniqueItemIdentifier) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.bgColor = bgColor;
            this.printMode = printMode;
            this.uniqueItemIdentifier = uniqueItemIdentifier;
        }

        public int getX() {
            return this.x;
        }

        public int getX(float zoom) {
            return Math.round((float)this.x * zoom);
        }

        public int getY() {
            return this.y;
        }

        public int getY(float zoom) {
            return Math.round((float)this.y * zoom);
        }

        public int getWidth() {
            return this.width;
        }

        public int getWidth(float zoom) {
            return Math.round((float)this.width * zoom);
        }

        public int getHeight() {
            return this.height;
        }

        public int getHeight(float zoom) {
            return Math.round((float)this.height * zoom);
        }

        public Point2D.Float getOriginalPosition() {
            return this.originalPosition;
        }

        public Point2D.Float getOriginalSize() {
            return this.originalSize;
        }

        public void setOriginalSettings(Point2D.Float originalPosition, Point2D.Float originalSize) {
            this.originalPosition = originalPosition;
            this.originalSize = originalSize;
        }

        public ColorDTO getBgColor() {
            return this.bgColor;
        }

        public int getPrintMode() {
            return this.printMode;
        }

        public DisplayItemUniqueID getUniqueItemIdentifier() {
            return this.uniqueItemIdentifier;
        }

        public abstract String getItemType();

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append((Object)this.uniqueItemIdentifier).append(this.x).append(this.y).build();
        }
    }

    public static class PageSettingsDTO
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final int width;
        private final int height;
        private final int marginTop;
        private final int marginBottom;
        private final int marginLeft;
        private final int marginRight;

        public PageSettingsDTO(int width, int height, int marginTop, int marginBottom, int marginLeft, int marginRight) {
            this.width = width;
            this.height = height;
            this.marginTop = marginTop;
            this.marginBottom = marginBottom;
            this.marginLeft = marginLeft;
            this.marginRight = marginRight;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        public int getMarginTop() {
            return this.marginTop;
        }

        public int getMarginBottom() {
            return this.marginBottom;
        }

        public int getMarginLeft() {
            return this.marginLeft;
        }

        public int getMarginRight() {
            return this.marginRight;
        }
    }
}

