/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.printing;

import ch.dvbern.tax.common.presentation.common.print.FormKey;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.pdfform.PdfForm;
import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PrintEntry {
    private final @NonNull String titleKey;
    private final boolean enabled;
    private final @Nullable List<PdfForm> pdfForms;
    private final @Nullable FormKey formKey;

    public PrintEntry(@NonNull String titleKey, boolean enabled, @Nullable List<PdfForm> pdfForms, @Nullable FormKey formKey) {
        this.titleKey = Objects.requireNonNull(titleKey);
        this.enabled = enabled;
        if (pdfForms != null && formKey != null || pdfForms == null && formKey == null) {
            throw new IllegalArgumentException("Exactly one of page or formKey must be != null");
        }
        this.pdfForms = pdfForms;
        this.formKey = formKey;
    }

    public @NonNull String getTitleKey() {
        return this.titleKey;
    }

    public boolean isFormularEnabled() {
        return this.enabled;
    }

    public @Nullable List<PdfForm> getPageList() {
        return this.pdfForms;
    }

    public @Nullable FormKey getFormKey() {
        return this.formKey;
    }
}

