/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.XMLCodePointFilter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StringUtil.class);
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String specialSaveChars = "=: \t\r\n\f#!";

    private StringUtil() {
    }

    public static String escapeAndFilterXml(CharSequence text) {
        if (text == null) {
            throw new NullPointerException("Input sequence cannot be null");
        }
        return StringEscapeUtils.ESCAPE_XML.with(new CharSequenceTranslator[]{new XMLCodePointFilter()}).translate(text);
    }

    public static String textToHtml(String sValue) {
        StringBuffer s = new StringBuffer(sValue);
        StringUtil.searchAndReplace(s, "\u00e4", "&auml;");
        StringUtil.searchAndReplace(s, "\u00f6", "&ouml;");
        StringUtil.searchAndReplace(s, "\u00fc", "&uuml;");
        StringUtil.searchAndReplace(s, "\u00c4", "&Auml;");
        StringUtil.searchAndReplace(s, "\u00d6", "&Ouml;");
        StringUtil.searchAndReplace(s, "\u00dc", "&Uuml;");
        StringUtil.searchAndReplace(s, "\u00e9", "&eacute;");
        StringUtil.searchAndReplace(s, "\u00e0", "&agrave;");
        StringUtil.searchAndReplace(s, "\u00e8", "&egrave;");
        StringUtil.searchAndReplace(s, "\u00f9", "&ugrave;");
        StringUtil.searchAndReplace(s, "\u00ea", "&ecirc;");
        StringUtil.searchAndReplace(s, "\u00f4", "&ocirc;");
        StringUtil.searchAndReplace(s, "\u00e2", "&acirc;");
        StringUtil.searchAndReplace(s, "\u00ee", "&icirc;");
        StringUtil.searchAndReplace(s, "\u00fb", "&ucirc;");
        StringUtil.searchAndReplace(s, "`", "'");
        StringUtil.searchAndReplace(s, "\u00b0", "&deg;");
        StringUtil.searchAndReplace(s, "\u00e7", "&ccedil;");
        return s.toString();
    }

    public static String htmlToText(String sValue) {
        StringBuffer s = new StringBuffer(sValue);
        StringUtil.searchAndReplace(s, "&auml;", "\u00e4");
        StringUtil.searchAndReplace(s, "&ouml;", "\u00f6");
        StringUtil.searchAndReplace(s, "&uuml;", "\u00fc");
        StringUtil.searchAndReplace(s, "&Auml;", "\u00c4");
        StringUtil.searchAndReplace(s, "&Ouml;", "\u00d6");
        StringUtil.searchAndReplace(s, "&Uuml;", "\u00dc");
        StringUtil.searchAndReplace(s, "&eacute;", "\u00e9");
        StringUtil.searchAndReplace(s, "&agrave;", "\u00e0");
        StringUtil.searchAndReplace(s, "&egrave;", "\u00e8");
        StringUtil.searchAndReplace(s, "&ugrave;", "\u00f9");
        StringUtil.searchAndReplace(s, "&ecirc;", "\u00ea");
        StringUtil.searchAndReplace(s, "&ocirc;", "\u00f4");
        StringUtil.searchAndReplace(s, "&acirc;", "\u00e2");
        StringUtil.searchAndReplace(s, "&icirc;", "\u00ee");
        StringUtil.searchAndReplace(s, "&ucirc;", "\u00fb");
        StringUtil.searchAndReplace(s, "'", "`");
        StringUtil.searchAndReplace(s, "&deg;", "\u00b0");
        StringUtil.searchAndReplace(s, "&ccedil;", "\u00e7");
        StringUtil.searchAndReplace(s, "&nbsp;", " ");
        StringUtil.searchAndReplace(s, "<br>", "\n");
        StringUtil.searchAndReplace(s, "<br/>", "\n");
        StringUtil.searchAndReplace(s, "<ul>", "");
        StringUtil.searchAndReplace(s, "</ul>", "");
        StringUtil.searchAndReplace(s, "<li>", "-\t");
        StringUtil.searchAndReplace(s, "</li>", "");
        return s.toString();
    }

    private static void searchAndReplace(StringBuffer aString, String aSearchString, String aReplaceString) {
        int idx = 0;
        while ((idx = aString.indexOf(aSearchString, idx)) >= 0) {
            int end = Math.min(idx + aSearchString.length(), aString.length());
            aString.replace(idx, end, aReplaceString);
            idx += aSearchString.length();
        }
    }

    public static String charToUNICode(String aString) {
        int len = aString.length();
        StringBuilder outBuffer = new StringBuilder(len * 2);
        int x = 0;
        block7: while (x < len) {
            char aChar = aString.charAt(x++);
            switch (aChar) {
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block7;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block7;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block7;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block7;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block7;
                }
            }
            if (aChar < '\u0014' || aChar > '\u007f') {
                outBuffer.append('\\');
                outBuffer.append('u');
                outBuffer.append(StringUtil.toHex(aChar >> 12 & 0xF));
                outBuffer.append(StringUtil.toHex(aChar >> 8 & 0xF));
                outBuffer.append(StringUtil.toHex(aChar >> 4 & 0xF));
                outBuffer.append(StringUtil.toHex(aChar >> 0 & 0xF));
                continue;
            }
            if (specialSaveChars.indexOf(aChar) != -1) {
                outBuffer.append('\\');
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    public static String unicodeToChar(String aString) {
        int len = aString.length();
        StringBuilder outBuffer = new StringBuilder(len);
        try {
            int x = 0;
            while (x < len) {
                int aChar;
                if ((aChar = aString.charAt(x++)) == 92) {
                    if ((aChar = aString.charAt(x++)) == 117) {
                        int value = 0;
                        block8: for (int i = 0; i < 4; ++i) {
                            aChar = aString.charAt(x++);
                            switch (aChar) {
                                case 48: 
                                case 49: 
                                case 50: 
                                case 51: 
                                case 52: 
                                case 53: 
                                case 54: 
                                case 55: 
                                case 56: 
                                case 57: {
                                    value = (value << 4) + aChar - 48;
                                    continue block8;
                                }
                                case 97: 
                                case 98: 
                                case 99: 
                                case 100: 
                                case 101: 
                                case 102: {
                                    value = (value << 4) + 10 + aChar - 97;
                                    continue block8;
                                }
                                case 65: 
                                case 66: 
                                case 67: 
                                case 68: 
                                case 69: 
                                case 70: {
                                    value = (value << 4) + 10 + aChar - 65;
                                    continue block8;
                                }
                                default: {
                                    throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                                }
                            }
                        }
                        outBuffer.append((char)value);
                        continue;
                    }
                    if (aChar == 116) {
                        aChar = 9;
                    } else if (aChar == 114) {
                        aChar = 13;
                    } else if (aChar == 110) {
                        aChar = 10;
                    } else if (aChar == 102) {
                        aChar = 12;
                    }
                    outBuffer.append((char)aChar);
                    continue;
                }
                outBuffer.append((char)aChar);
            }
        }
        catch (StringIndexOutOfBoundsException aStringIndexOutOfBoundsException) {
            LOG.error("Error converting: " + aString, aStringIndexOutOfBoundsException.fillInStackTrace());
        }
        return outBuffer.toString();
    }
}

