/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpertTableRowComparator
implements Comparator<ExpertDisplayInfoDTO.TableDTO.RowDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(ExpertTableRowComparator.class);
    private boolean asc = true;
    private int column = 0;
    private @NonNull AbstractConverter.ConverterContext ctx;
    private Collator collator = null;
    private List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> columns = null;

    public ExpertTableRowComparator(int column, boolean asc, @NonNull AbstractConverter.ConverterContext ctx, List<ExpertDisplayInfoDTO.TableDTO.ColumnDTO> columns) {
        this.column = column;
        this.asc = asc;
        this.ctx = ctx;
        this.columns = columns;
        try {
            this.collator = Collator.getInstance(ctx.getLocalizationHelper().getCurrentLocale());
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compare(ExpertDisplayInfoDTO.TableDTO.RowDTO row1, ExpertDisplayInfoDTO.TableDTO.RowDTO row2) {
        int ret = this.compareAsc(row1, row2);
        return this.asc ? ret : -1 * ret;
    }

    private int compareAsc(ExpertDisplayInfoDTO.TableDTO.RowDTO row1, ExpertDisplayInfoDTO.TableDTO.RowDTO row2) {
        Comparable value1 = this.getComparableValue(row1, this.column);
        Comparable value2 = this.getComparableValue(row2, this.column);
        if (value1 == null) {
            return -1;
        }
        if (value2 == null) {
            return 1;
        }
        if (value1 instanceof String && value2 instanceof String) {
            return this.compareAsc((String)((Object)value1), (String)((Object)value2));
        }
        return this.compareAsc(value1, value2);
    }

    private Comparable getComparableValue(ExpertDisplayInfoDTO.TableDTO.RowDTO row, int col) {
        Object item = row.getValues().get(col);
        if (item instanceof ExpertDisplayInfoDTO.TableDTO.ValueCellDTO) {
            ExpertDisplayInfoDTO.TableDTO.ColumnDTO column = this.columns.get(col);
            return this.getItemValue(column, (ExpertDisplayInfoDTO.TableDTO.ValueCellDTO)item);
        }
        if (item instanceof ExpertDisplayInfoDTO.TableDTO.LabelCellDTO) {
            return this.getLabelText((ExpertDisplayInfoDTO.TableDTO.LabelCellDTO)item);
        }
        return null;
    }

    private Comparable getItemValue(ExpertDisplayInfoDTO.TableDTO.ColumnDTO col, ExpertDisplayInfoDTO.TableDTO.ValueCellDTO item) {
        Object value;
        ModelItemDTO modelItem = item.getModelItem();
        Object object = value = modelItem == null ? null : modelItem.getValue();
        if (value instanceof Comparable) {
            return (Comparable)value;
        }
        AbstractConverter<?> conv = col.getRendererAndInputValidator();
        if (conv == null) {
            return value.toString();
        }
        return conv.getRenderedValue(value, false, item.getOptionItems(), this.ctx);
    }

    private String getLabelText(ExpertDisplayInfoDTO.TableDTO.LabelCellDTO label) {
        if (label.getKey() == null) {
            return null;
        }
        String key = label.getKey();
        List<ExpertDisplayInfoDTO.LabelDTO.LabelAddOnDTO> args = label.getLabelAddOns();
        Object[] argsArray = null;
        if (args != null && !args.isEmpty()) {
            argsArray = args.toArray();
        }
        try {
            return this.ctx.getLocalizationHelper().translate(key, argsArray);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            LOG.warn("translation failed", (Throwable)e);
            return "";
        }
    }

    private int compareAsc(String value1, String value2) {
        return this.collator.compare(value1, value2);
    }

    private int compareAsc(Comparable value1, Comparable value2) {
        if (value1.getClass().equals(value2.getClass())) {
            return value1.compareTo(value2);
        }
        if (value1 instanceof Number && value2 instanceof Number) {
            Double d1 = ((Number)((Object)value1)).doubleValue();
            Double d2 = ((Number)((Object)value2)).doubleValue();
            return d1.compareTo(d2);
        }
        return this.compareAsc(value1.toString(), value2.toString());
    }
}

