/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.util;

import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachedImageSource
implements ImageSource {
    private static final Logger LOG = LoggerFactory.getLogger(CachedImageSource.class);
    private final Map<String, SoftValue> hash = new HashMap<String, SoftValue>();
    private final LinkedHashMap<String, byte[]> hardCache = new LRUCache<String, byte[]>(50);
    private final ReferenceQueue<byte[]> queue = new ReferenceQueue();

    @Override
    public byte[] getImage(String name) throws IOException {
        LOG.debug("loading image: " + name);
        byte[] image = this.getFromCache(name);
        if (image == null) {
            LOG.debug("image not found in cache: " + name);
            image = this.loadImageInternal(name);
            this.addToCache(name, image);
        }
        return image;
    }

    @Override
    public InputStream getImageAsStream(String name) throws IOException {
        byte[] image = this.getImage(name);
        if (image == null) {
            return null;
        }
        return new ByteArrayInputStream(image);
    }

    protected abstract byte[] loadImageInternal(String var1) throws IOException;

    private byte[] getFromCache(String name) {
        byte[] result = null;
        SoftReference softRef = this.hash.get(name);
        if (softRef != null) {
            result = (byte[])softRef.get();
            if (result == null) {
                this.hash.remove(name);
            } else {
                this.hardCache.put(name, result);
            }
        }
        return result;
    }

    private void addToCache(String name, byte[] value) {
        this.processQueue();
        this.hash.put(name, new SoftValue(value, name, this.queue));
    }

    private void processQueue() {
        SoftValue sv;
        while ((sv = (SoftValue)this.queue.poll()) != null) {
            this.hash.remove(sv.key);
        }
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int maxSize;

        public LRUCache(int maxSize) {
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }

    private static final class SoftValue
    extends SoftReference<byte[]> {
        private final Object key;

        private SoftValue(byte[] k, Object key, ReferenceQueue<byte[]> q) {
            super(k, q);
            this.key = key;
        }
    }
}

