/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard;

import ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard.WizardItemPrinter;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.common.transfer.util.WizardLabelAddOnHelper;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WizardTablePrinter
extends WizardItemPrinter<WizardDisplayInfoDTO.TableItemDTO> {
    private static final Logger LOG = LoggerFactory.getLogger(WizardTablePrinter.class);
    private WizardDisplayInfoDTO.TableItemDTO tableItemDTO;

    @Override
    protected void initalize(WizardDisplayInfoDTO.TableItemDTO item) {
        this.tableItemDTO = item;
    }

    @Override
    public void print(float xOffset, float yOffset) throws FormRendererException {
        if (this.tableItemDTO.getRows() == null || this.tableItemDTO.getRows().isEmpty()) {
            return;
        }
        PdfPTable table = new PdfPTable(this.tableItemDTO.getColdefs().size());
        table.setWidthPercentage(100.0f);
        table.setHeaderRows(2);
        table.setSpacingAfter(12.0f);
        Object[] args = WizardLabelAddOnHelper.getReplacements(this.tableItemDTO.getLabelAddOns(), this.getGlobalConverterContext().withDmk(this.tableItemDTO.getDataModelKey()));
        this.addTableTitle(table, this.translate(this.tableItemDTO.getHeader(), args), this.tableItemDTO.getColdefs().size());
        int[] colwidths = this.getGridArray(this.tableItemDTO.getColdefs());
        for (WizardDisplayInfoDTO.ColDefItemDTO colDefItemDTO : this.tableItemDTO.getColdefs()) {
            Object[] argsColdef = WizardLabelAddOnHelper.getReplacements(colDefItemDTO.getHeaderAddOns(), this.getGlobalConverterContext().withDmk(this.tableItemDTO.getDataModelKey()));
            this.addTableHeader(table, this.translate(colDefItemDTO.getHeader(), argsColdef), 1);
        }
        try {
            table.setWidths(colwidths);
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't print section", e);
        }
        List<WizardDisplayInfoDTO.RowItemDTO> rows = this.tableItemDTO.getRows();
        if (rows != null && !rows.isEmpty()) {
            for (WizardDisplayInfoDTO.RowItemDTO rowItemDTO : rows) {
                this.printRow(table, rowItemDTO);
            }
        }
        try {
            this.getDocument().add((Element)table);
        }
        catch (DocumentException documentException) {
            throw new FormRendererException("can't print section", documentException);
        }
    }

    private void printRow(PdfPTable table, WizardDisplayInfoDTO.RowItemDTO rowItemDTO) throws FormRendererException {
        List<WizardDisplayInfoDTO.AbstractItemDTO> cols = rowItemDTO.getCols();
        if (cols != null && !cols.isEmpty()) {
            for (WizardDisplayInfoDTO.AbstractItemDTO element : rowItemDTO.getCols()) {
                if (element instanceof WizardDisplayInfoDTO.ItemItemDTO) {
                    WizardDisplayInfoDTO.ItemItemDTO itemItemDTO = (WizardDisplayInfoDTO.ItemItemDTO)element;
                    String s = this.getText(itemItemDTO);
                    this.addTableCell(table, s, itemItemDTO.getColspan(), itemItemDTO.getAlign());
                    continue;
                }
                if (element instanceof WizardDisplayInfoDTO.LabelItemDTO) {
                    WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = (WizardDisplayInfoDTO.LabelItemDTO)element;
                    this.addTableCell(table, this.getText(labelItemDTO), labelItemDTO.getColspan(), labelItemDTO.getAlign());
                    continue;
                }
                LOG.warn("unsupported type in table: " + element.getClass().getName());
            }
        } else {
            this.addTableCell(table, " ", this.tableItemDTO.getColdefs().size(), "");
        }
    }
}

