/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.common.print.pdf.printer.wizard;

import ch.dvbern.tax.common.presentation.common.print.pdf.DocumentContext;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.ItemPrinter;
import ch.dvbern.tax.common.transfer.dto.LocalizationHelper;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.failure.FormRendererException;
import ch.dvbern.tax.common.transfer.util.WizardLabelAddOnHelper;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class WizardItemPrinter<T extends WizardDisplayInfoDTO.AbstractItemDTO>
implements ItemPrinter<T> {
    private DocumentContext documentContext;
    private Font fontNormal;
    private Font fontHeader;
    private Font fontTitle;

    @Override
    public final void initalize(@NonNull DocumentContext documentContext, @NonNull T item) {
        this.documentContext = documentContext;
        try {
            BaseFont bf = BaseFont.createFont((String)"Helvetica", (String)"Cp1252", (boolean)true);
            this.fontNormal = new Font(bf, 8.0f, 0);
            this.fontHeader = new Font(bf, 9.0f, 1);
            this.fontTitle = new Font(bf, 10.0f, 1);
        }
        catch (IOException e) {
            throw new RuntimeException("can't create font", e);
        }
        catch (DocumentException e) {
            throw new RuntimeException("can't create font", e);
        }
        this.initalize(item);
    }

    protected abstract void initalize(T var1);

    @Override
    public void print() throws FormRendererException {
        this.print(0.0f, 0.0f);
    }

    protected @NonNull AbstractConverter.ConverterContext getGlobalConverterContext() {
        return this.documentContext.getGlobalConverterContext();
    }

    protected Document getDocument() {
        return this.documentContext.getDocument();
    }

    protected void printText(String text) throws FormRendererException {
        try {
            text = WizardItemPrinter.removeHTML(text);
            this.getDocument().add((Element)new Paragraph(text, this.fontNormal));
        }
        catch (DocumentException e) {
            throw new FormRendererException("can't write text", e);
        }
    }

    protected String getText(WizardDisplayInfoDTO.LabelItemDTO label) throws FormRendererException {
        Object[] args = WizardLabelAddOnHelper.getReplacements(label.getLabelAddOns(), this.getGlobalConverterContext());
        try {
            return this.getGlobalConverterContext().getLocalizationHelper().translate(label.getName().toString(), args);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("translation failed", e);
        }
    }

    protected String getText(WizardDisplayInfoDTO.ItemItemDTO item) {
        AbstractConverter<?> conv = item.getRendererAndInputValidator();
        String s = conv.getRenderedValue(item.getValue(), false, item.getOptionItems(), this.getGlobalConverterContext().withDmk(item.getDataModelKey()));
        if (s == null || s.length() < 1) {
            s = " ";
        }
        return s;
    }

    protected String translate(String key, Object[] args) throws FormRendererException {
        try {
            return this.getGlobalConverterContext().getLocalizationHelper().translate(key, args);
        }
        catch (LocalizationHelper.LocalizationHelperException e) {
            throw new FormRendererException("translation failed", e);
        }
    }

    protected void addTableCell(PdfPTable table, String text, int colspan, String alignment) {
        text = WizardItemPrinter.removeHTML(text);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(text, this.fontNormal));
        cell.setColspan(colspan);
        cell.setHorizontalAlignment(this.itextAlignment(alignment));
        table.addCell(cell);
    }

    protected void addTableHeader(PdfPTable table, String text, int colspan) {
        text = WizardItemPrinter.removeHTML(text);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(text, this.fontHeader));
        cell.setColspan(colspan);
        cell.setBackgroundColor(Color.LIGHT_GRAY);
        table.addCell(cell);
    }

    protected void addTableTitle(PdfPTable table, String text, int colspan) {
        text = WizardItemPrinter.removeHTML(text);
        PdfPCell cell = new PdfPCell((Phrase)new Paragraph(text, this.fontTitle));
        cell.setColspan(colspan);
        cell.setBackgroundColor(Color.LIGHT_GRAY);
        table.addCell(cell);
    }

    protected int[] getGridArray(List<WizardDisplayInfoDTO.ColDefItemDTO> coldefs) {
        float totalWidth = this.getDocument().getPageSize().getWidth();
        ArrayList<Integer> colsUndefined = new ArrayList<Integer>();
        int totalDefined = 0;
        if (coldefs == null) {
            return new int[]{Integer.MAX_VALUE};
        }
        int[] grid = new int[coldefs.size()];
        for (int i = 0; i < coldefs.size(); ++i) {
            WizardDisplayInfoDTO.ColDefItemDTO coldef = coldefs.get(i);
            if (!coldef.isWidthUndefined()) {
                grid[i] = Integer.parseInt(coldef.getWidth());
                totalDefined += grid[i];
                continue;
            }
            colsUndefined.add(i);
        }
        if (!colsUndefined.isEmpty()) {
            float toShare = totalWidth - (float)totalDefined;
            int nbrUndefined = colsUndefined.size();
            for (Integer aColsUndefined : colsUndefined) {
                grid[aColsUndefined.intValue()] = Math.round(toShare / (float)nbrUndefined);
            }
        }
        return grid;
    }

    protected int itextAlignment(String align) {
        if ("right".equalsIgnoreCase(align)) {
            return 2;
        }
        if ("center".equalsIgnoreCase(align)) {
            return 1;
        }
        return 0;
    }

    protected DocumentContext getDocumentContext() {
        return this.documentContext;
    }

    private static String removeHTML(String s) {
        Pattern tagEmpty = Pattern.compile("(.|\\n|\\r)*((<){1}(.|\\n|\\r)*(/>){1})(.|\\n|\\r)*");
        Pattern tagOpen = Pattern.compile("(.|\\n|\\r)*((<){1}(.|\\n|\\r)*(>){1})(.|\\n|\\r)*");
        Pattern tagClose = Pattern.compile("(.|\\n|\\r)*((</){1}(.|\\n|\\r)*(>){1})(.|\\n|\\r)*");
        s = s.replaceAll("&nbsp;", " ");
        Matcher mEmpty = tagEmpty.matcher(s);
        while (mEmpty.matches()) {
            s = s.replaceAll(mEmpty.group(2), "");
            mEmpty = tagEmpty.matcher(s);
        }
        Matcher mClose = tagClose.matcher(s);
        while (mClose.matches()) {
            s = s.replaceAll(mClose.group(2), "");
            mClose = tagClose.matcher(s);
        }
        Matcher mOpen = tagOpen.matcher(s);
        while (mOpen.matches()) {
            s = s.replaceAll(mOpen.group(2), "");
            mOpen = tagOpen.matcher(s);
        }
        return s;
    }
}

