/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.util;

import ch.dvbern.tax.common.integration.util.SQLCall;
import ch.dvbern.tax.common.integration.util.failure.StorageException;
import com.jamonapi.proxy.MonProxyFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DAOBase {
    private static final Logger LOG = LoggerFactory.getLogger(DAOBase.class);
    private DataSource ds;
    private Connection con;

    public DAOBase(DataSource ds) {
        this.setDataSource(ds);
    }

    protected DAOBase() {
    }

    public DAOBase(Connection con) {
        this.setConnection(con);
    }

    protected void setConnection(Connection con) {
        this.con = con;
    }

    protected void setDataSource(DataSource ds) {
        this.ds = ds;
    }

    @SuppressFBWarnings(justification="Kann nicht von aussen aufgerufen werden", value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"})
    protected SQLCall getSQLCall(String statement) {
        try {
            if (this.con != null && !this.con.isClosed()) {
                return new SQLCall(this.con, statement);
            }
            this.con = MonProxyFactory.monitor((Connection)this.ds.getConnection());
            return new SQLCall(this.con, statement);
        }
        catch (SQLException e) {
            throw new StorageException("SQL Exception while fetching the database connection", e);
        }
    }

    protected Connection getConnection() {
        if (this.con != null) {
            return this.con;
        }
        try {
            return MonProxyFactory.monitor((Connection)this.ds.getConnection());
        }
        catch (SQLException e) {
            LOG.error("Could not get connection", (Throwable)e);
            return null;
        }
    }

    protected void closeConnection() {
        try {
            if (this.con != null && this.ds != null) {
                this.con.close();
                this.con = null;
            }
        }
        catch (SQLException e) {
            LOG.error("Could not close connection", (Throwable)e);
        }
    }

    protected void finalize() throws Throwable {
        if (this.con != null && !this.con.isClosed()) {
            LOG.warn(String.valueOf(this) + ": Closing a connection for you. Please ensure to close them yourself!");
            this.closeConnection();
        }
        super.finalize();
    }

    protected DataSource getDataSource() {
        return this.ds;
    }
}

