/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.conf;

import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.tax.common.integration.conf.ApplicationConfigProvider;
import ch.dvbern.tax.common.integration.conf.StaticInstanceConfigurationProvider;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.FileBasedBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.convert.DisabledListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApplicationConfig
extends PropertiesConfiguration
implements Configuration {
    public static final TimeZone TIMEZONE = TimeZone.getTimeZone("Europe/Zurich");
    protected @Nullable String projectPrefix = null;
    public static final String STEUERJAHR = "steuerjahr";
    public static final String ENGINE_ID = "engineId";
    public static final String ENGINE_ID_DOSSIER = "engineId.dossier";
    public static final String DATASOURCE_PREFIX = "datasource.prefix";
    private static final String DEFAULT_RENDER_STRING = "editRoot, navigationRoot, breadcrumbsRoot, messagesRoot";
    public static final String DEFAULT_RENDER_ADDITIONAL_TARGETS_KEY = "default_render.additional_targets";
    public static final String VERSION = "Version";
    public static final String RECEIPT_PRINT_DMK = "ReceiptDMK";
    public static final String KEY_NEXT_TABLE_START_INDEX = "next.table.start.index";
    public static final Integer DEFAULT_NEXT_TABLE_ENTRY_START_INDEX = 90000;
    public static final String KEY_MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String KEY_MAIL_SMTP_HOST = "mail.smtp.host";
    public static final String KEY_MAIL_SMTP_PORT = "mail.smtp.port";
    public static final String KEY_MAIL_SMTP_USER = "mail.smtp.user";
    public static final String KEY_SMTP_PASSWORD = "mail.smtp.password";
    public static final String KEY_MAIL_SENDER_ADDRESS = "mail.confirmation.sender.address";
    public static final String KEY_MAIL_SENDER_NAME = "mail.confirmation.sender.name";
    public static final String KEY_IMPORT_VALOREN_AS_CHF = "import.valoren.as.chf";
    public static final String KEY_PRINT_CLASSPATH = "print.classpath";
    public static final String KEY_USE_ICTAX = "use.ictax";
    public static final String URL_ICTAX_SERVICE = "ictax.service.uri";
    public static final String KEY_CHARSET = "charset";
    public static final String DEFAULT_CHARSET = "UTF-8";
    public static final String KEY_DMK_USER_LANGUAGE = "dmk.user.language";
    public static final String KEY_DMK_VIEW_MODUS = "dmk.view.modus";
    private Map<String, ElementParser> additionalXmlParsers;
    public static final String HIDE_DELETE_WARNINGS_OF_UNTOUCHED_VALUES = "hide.deleteWarnings.of.untouched.values";
    public static final String PRINT_WATERMARK_OVER_TEXT = "print.watermark.overText";
    public static final int DEFAULT_SUGGESTIONS_MIN_CHARS = 2;
    public static final String KEY_SUGGESTIONS_MINCHARS = "suggestions.minchars";
    public static final String KEY_TEMP_TAXFILE_ENABLED = "temp.taxfile.enabled";
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationConfig.class);
    private static final Mutex MUTEX = new Mutex();

    public URL getURL(String key) {
        String textValue = this.getString(key);
        try {
            return new URL(textValue);
        }
        catch (MalformedURLException e) {
            throw new ApplicationException("Invalid URL for config-key: " + key + " with value: " + textValue, e);
        }
    }

    public URL getURL(String key, URL defaultValue) {
        String textValue = this.getString(key, defaultValue.toString());
        try {
            return new URL(textValue);
        }
        catch (MalformedURLException e) {
            throw new ApplicationException("Invalid URL for config-key: " + key + " with value: " + textValue, e);
        }
    }

    private static FileBasedBuilderParameters defaultParameters() {
        return (FileBasedBuilderParameters)new Parameters().fileBased().setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler());
    }

    private static PropertiesConfiguration buildConfig(FileBasedBuilderParameters parameters) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{parameters});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        return config;
    }

    public void copyProperties(File file) throws ConfigurationException {
        PropertiesConfiguration config = ApplicationConfig.buildConfig((FileBasedBuilderParameters)ApplicationConfig.defaultParameters().setFile(file));
        this.copy((Configuration)config);
    }

    public void copyProperties(InputStream in) throws ConfigurationException {
        PropertiesConfiguration config = ApplicationConfig.buildConfig(ApplicationConfig.defaultParameters());
        FileHandler fileHandler = new FileHandler((FileBased)config);
        fileHandler.load(in);
        this.copy((Configuration)config);
    }

    public void copyProperties(InputStream in, String encoding) throws ConfigurationException {
        PropertiesConfiguration config = ApplicationConfig.buildConfig(ApplicationConfig.defaultParameters());
        FileHandler fileHandler = new FileHandler((FileBased)config);
        fileHandler.load(in, encoding);
        this.copy((Configuration)config);
    }

    public void copyProperties(URL url) throws ConfigurationException {
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(PropertiesConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((FileBasedBuilderParameters)new Parameters().fileBased().setURL(url)).setListDelimiterHandler((ListDelimiterHandler)new DisabledListDelimiterHandler())});
        PropertiesConfiguration config = (PropertiesConfiguration)builder.getConfiguration();
        this.copy((Configuration)config);
    }

    public void copySystemProperties() {
        Properties props = System.getProperties();
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            if (!(prop.getKey() instanceof String)) continue;
            String key = (String)prop.getKey();
            this.setProperty(key, prop.getValue());
        }
    }

    public static void setInstance(ApplicationConfig config) {
        StaticInstanceConfigurationProvider.setInstance(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationConfig getInstance() {
        if (ApplicationConfig.MUTEX.config != null) {
            return ApplicationConfig.MUTEX.config;
        }
        Mutex mutex = MUTEX;
        synchronized (mutex) {
            if (ApplicationConfig.MUTEX.config == null) {
                ApplicationConfig config = ApplicationConfigProvider.getConfiguration();
                if (config == null) {
                    throw new IllegalStateException("configuration error: please define your own implementation of " + ApplicationConfigProvider.class.getName() + " and register it in META-INF/services/" + ApplicationConfigProvider.class.getName());
                }
                LOG.info("Loaded configuration instance: {}", (Object)config);
                ApplicationConfig.MUTEX.config = config;
            }
            return ApplicationConfig.MUTEX.config;
        }
    }

    protected boolean containsKeyInternal(String key) {
        String internalKey = this.prefixKey(this.getProjectPrefix(), key);
        return super.containsKeyInternal(internalKey);
    }

    protected Object getPropertyInternal(String key) {
        String internalKey = this.prefixKey(this.getProjectPrefix(), key);
        return super.getPropertyInternal(internalKey);
    }

    protected String prefixKey(@Nullable String prefix, String key) {
        Object internalKey = key;
        if (prefix != null) {
            internalKey = prefix + "." + key;
        }
        return internalKey;
    }

    public void setProjectPrefix(@Nullable String projectPrefix) {
        this.projectPrefix = projectPrefix;
    }

    public @Nullable String getProjectPrefix() {
        return this.projectPrefix;
    }

    public String getMailTransportProtocol() {
        return this.getString(KEY_MAIL_TRANSPORT_PROTOCOL);
    }

    public String getMailSmtpHost() {
        return this.getString(KEY_MAIL_SMTP_HOST);
    }

    public String getMailSmtpPort() {
        return this.getString(KEY_MAIL_SMTP_PORT);
    }

    public String getMailSmtpUser() {
        return this.getString(KEY_MAIL_SMTP_USER);
    }

    public String getMailSmtpPassword() {
        return this.getString(KEY_SMTP_PASSWORD);
    }

    public String getMailSenderAdress() {
        return this.getString(KEY_MAIL_SENDER_ADDRESS);
    }

    public String getMailSenderName() {
        return this.getString(KEY_MAIL_SENDER_NAME);
    }

    public int getJahr() {
        return this.getInt(STEUERJAHR);
    }

    public int getVorjahr() {
        return this.getJahr() - 1;
    }

    public abstract String getEngineId(String var1);

    public String getDatasourceName() {
        return this.getString(DATASOURCE_PREFIX) + this.getJahr();
    }

    public String getDatasourceImportName() {
        return this.getString(DATASOURCE_PREFIX) + this.getVorjahr();
    }

    public String getDefaultRenderString() {
        String additionalTargets = this.getString(DEFAULT_RENDER_ADDITIONAL_TARGETS_KEY);
        if (additionalTargets != null && !additionalTargets.isEmpty()) {
            return "editRoot, navigationRoot, breadcrumbsRoot, messagesRoot, " + additionalTargets;
        }
        return DEFAULT_RENDER_STRING;
    }

    public String getApplicationVersion() {
        return this.getString(VERSION);
    }

    public String getReceiptPrintDmk() {
        return this.getString(RECEIPT_PRINT_DMK);
    }

    public boolean isUsingPKeysForPWrites() {
        return this.getBoolean("persistence.usingPKeysForPWrites", Boolean.TRUE);
    }

    public Integer getStartIndexForUserInsertedTableEntries() {
        Integer result = this.getInteger(KEY_NEXT_TABLE_START_INDEX, null);
        if (result == null || result <= 0) {
            result = DEFAULT_NEXT_TABLE_ENTRY_START_INDEX;
        }
        return result;
    }

    public Boolean importValorenAsChf() {
        return this.getBoolean(KEY_IMPORT_VALOREN_AS_CHF, null);
    }

    public String getPrintClasspath() {
        return this.getString(KEY_PRINT_CLASSPATH);
    }

    public Boolean useICTax() {
        return this.getBoolean(KEY_USE_ICTAX, Boolean.FALSE);
    }

    public String getICTaxUrl() {
        return this.getString(URL_ICTAX_SERVICE);
    }

    public String getCharset() {
        return this.getString(KEY_CHARSET, DEFAULT_CHARSET);
    }

    public String getDmkUserLocale() {
        return this.getString(KEY_DMK_USER_LANGUAGE, null);
    }

    public String getDmkViewmodus() {
        return this.getString(KEY_DMK_VIEW_MODUS);
    }

    public Map<String, ElementParser> getAdditionalXmlParsers() {
        return this.additionalXmlParsers;
    }

    public void setAdditionalXmlParsers(Map<String, ElementParser> additionalXmlParsers) {
        this.additionalXmlParsers = additionalXmlParsers;
    }

    public int getSuggestionsMinChars() {
        return this.getInt(KEY_SUGGESTIONS_MINCHARS, 2);
    }

    public boolean hideDeleteWarnigsOfUntouchedValues() {
        return this.getBoolean(HIDE_DELETE_WARNINGS_OF_UNTOUCHED_VALUES, false);
    }

    public boolean isPrintWatermarkOverText() {
        return this.getBoolean(PRINT_WATERMARK_OVER_TEXT, false);
    }

    public boolean isTempTaxfileEnabled() {
        return this.getBoolean(KEY_TEMP_TAXFILE_ENABLED, false);
    }

    private static class Mutex {
        ApplicationConfig config = null;

        private Mutex() {
        }
    }
}

