/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.integration.conf;

import ch.dvbern.tax.common.ejb.util.EJBBeanInjector;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.presentation.common.print.FormRendererConfiguration;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.net.URL;

public abstract class AbstractOnlineApplicationConfig
extends ApplicationConfig {
    public static final String LOGOUT_REDIRECT = "logout.redirect";
    public static final String DEMO_MODUS_URL = "demo.modus.url";
    public static final String JNDI_PREFIX = "jndi.prefix";
    public static final String EAR_PREFIX = "ear.prefix";
    public static final String EXTERNAL_SERVER_URL = "external.url";
    public static final String SYSTEM_STATE_REFRESH_INTERVAL = "SystemStateRefreshInterval";
    public static final String STATIC_URL_PREFIX = "static.content.url.prefix";
    public static final String USE_SYNRONIZED_PDF_PRINT = "syncronized.pdf.print.enabled";
    private static final String USE_CD_MAIN_HELP_FOR_FORMS = "use.cd.main.help.for.forms";

    public static AbstractOnlineApplicationConfig getInstance() {
        return (AbstractOnlineApplicationConfig)ApplicationConfig.getInstance();
    }

    public String getDatasourcesJndiPath() {
        String path = this.getString("datasources.jndipath");
        if (path == null) {
            path = "java:";
        }
        return path;
    }

    public String getContextPath() {
        String path = this.getString("servlet.context.path");
        if (path == null || "".equals(path)) {
            throw new ApplicationException("error looking up servlet.context.path");
        }
        return path;
    }

    public String getHelpActionJavascriptOnfocus() {
        return this.getString("helpaction.javascript.onfocus");
    }

    public String getHelpActionJavascriptOnclick() {
        return this.getString("helpaction.javascript.onclick");
    }

    public String getBreadcrumbsDelimiter() {
        return this.getString("tmo.breadcrumbs.delimiter");
    }

    public boolean isForcingRecalculateOnInit() {
        return this.getBoolean("forceRecalculateOnInit", false);
    }

    public boolean isFormNavigationControlEnabled() {
        return this.getBoolean("tmo.formBuilder.navigationControlsEnabled", true);
    }

    public boolean isDisplayItemReadonlyAsTextOutput() {
        return this.getBoolean("dvbtax.item.readonly.as.text.output", false);
    }

    public boolean isSyncronizedPdfPrintEnabled() {
        return this.getBoolean(USE_SYNRONIZED_PDF_PRINT, false);
    }

    public boolean isLMIAutoRenderEnabled() {
        return this.getBoolean("lmiautorender", false);
    }

    public boolean isStatusIconsTooltipEnabled() {
        return this.getBoolean("status.icons.tooltip.enabled", false);
    }

    public Class<EJBBeanInjector> getDVEJBBeanInjectorClass() throws ClassNotFoundException {
        String className = this.getString("dvejb.bean.injector.class");
        if (className == null) {
            return null;
        }
        return Class.forName(className);
    }

    public URL getDemoModusUrl() {
        return this.getURL(DEMO_MODUS_URL);
    }

    public String getStaticContentUrlPrefix() {
        return this.getString(STATIC_URL_PREFIX) + this.getJahr();
    }

    public String getEarName() {
        return this.getString(EAR_PREFIX) + this.getJahr();
    }

    public String getJndiName() {
        return this.getString(JNDI_PREFIX) + this.getJahr();
    }

    public String getLogoutRedirect() {
        return this.getString(LOGOUT_REDIRECT);
    }

    public URL getExternalServerUrl() {
        return this.getURL(EXTERNAL_SERVER_URL);
    }

    public Integer getSystemStateRefreshInterval() {
        return this.getInteger(SYSTEM_STATE_REFRESH_INTERVAL, null);
    }

    public String getHelpUrlPrefix() {
        return this.getStaticContentUrlPrefix();
    }

    public boolean isUsingCDMainHelpForForms() {
        return this.getBoolean(USE_CD_MAIN_HELP_FOR_FORMS, false);
    }

    public FormRendererConfiguration getDefaultPrintConfiguration() {
        return new FormRendererConfiguration();
    }
}

