/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.entities.dao.base;

import ch.dvbern.tax.common.entities.base.EntityAbstract;
import ch.dvbern.tax.common.entities.dao.base.GenericDao;
import ch.dvbern.tax.common.transfer.failure.EntityNotFoundException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;

public abstract class DaoBeanAbstract<E extends EntityAbstract, PK>
implements GenericDao<E, PK> {
    private final Class<? extends E> entityClass;

    public DaoBeanAbstract(Class<? extends E> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public E persist(E entity) {
        this.getEntityManager().persist(entity);
        return entity;
    }

    @Override
    public E merge(E entity) {
        EntityAbstract entityMerged = (EntityAbstract)this.getEntityManager().merge(entity);
        return (E)entityMerged;
    }

    @Override
    public void remove(PK primaryKey) {
        this.getEntityManager().remove(this.find(primaryKey));
    }

    @Override
    public E find(PK primaryKey) {
        EntityAbstract result = (EntityAbstract)this.getEntityManager().find(this.entityClass, primaryKey);
        if (result == null) {
            throw new EntityNotFoundException(this.entityClass, primaryKey);
        }
        return (E)result;
    }

    @Override
    public E search(PK primaryKey) {
        return (E)((EntityAbstract)this.getEntityManager().find(this.entityClass, primaryKey));
    }

    @Override
    public List<E> list(int startPosition, int pageSize) {
        return this.getEntityManager().createQuery("from " + this.entityClass.getName()).setFirstResult(startPosition).setMaxResults(pageSize).getResultList();
    }

    @Override
    public boolean exist(PK primaryKey) {
        return this.getEntityManager().find(this.entityClass, primaryKey) != null;
    }

    @Override
    public abstract EntityManager getEntityManager();

    protected E getSingleResult(Query q) {
        q.setMaxResults(1);
        List results = q.getResultList();
        if (results.isEmpty()) {
            return null;
        }
        return (E)((EntityAbstract)results.get(0));
    }
}

