/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.ColDef;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Header;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Help;
import ch.dvbern.tax.common.engine.wizarddisplay.items.LabelAddOn;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Row;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowItemBase;
import ch.dvbern.tax.common.engine.wizarddisplay.items.RowIterator;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Section
extends WizardDisplayModelItem {
    private final List<ColDef> coldefs;
    private final List<Header> headers;
    private final Help help;
    private final List<RowItemBase> rows;
    private final String stateKey;
    private Boolean readonly;
    private String readonlyItemKey;
    private final String viewId;
    private final String header;
    private final List<LabelAddOn> headerAddOns;
    private final String styleClass;

    public Section(List<ColDef> coldefs, List<Header> headers, Help help, List<RowItemBase> rows, String stateKey, String readonly, String viewId, String header, List<LabelAddOn> headerAddOns, String styleClass) {
        this.coldefs = coldefs;
        this.headers = headers;
        this.help = help;
        this.rows = rows;
        this.stateKey = stateKey;
        this.viewId = viewId;
        this.header = header;
        this.headerAddOns = headerAddOns;
        if (readonly == null || readonly.isEmpty() || readonly.equalsIgnoreCase("false")) {
            this.readonly = Boolean.FALSE;
        } else if (readonly.equalsIgnoreCase("true")) {
            this.readonly = Boolean.TRUE;
        } else {
            this.readonlyItemKey = readonly;
        }
        this.styleClass = styleClass;
    }

    public List<WizardDisplayModelItem> getChildren() {
        ArrayList<WizardDisplayModelItem> children = new ArrayList<WizardDisplayModelItem>();
        if (this.coldefs != null) {
            children.addAll(this.coldefs);
        }
        if (this.headers != null) {
            children.addAll(this.headers);
        }
        if (this.help != null) {
            children.add(this.help);
        }
        if (this.rows != null) {
            children.addAll(this.rows);
        }
        if (children.isEmpty()) {
            children = null;
        }
        return children;
    }

    public List<ColDef> getColdefs() {
        return this.coldefs;
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public String getHeader() {
        return this.header;
    }

    public List<RowItemBase> getRows() {
        return this.rows;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.stateKey != null && logicModelItems.get(this.stateKey) == null) {
            throw new InvalidModelException("invalid state-reference '" + this.stateKey + " in Section " + String.valueOf(this.getParent()));
        }
        if (this.readonlyItemKey != null && logicModelItems.get(this.readonlyItemKey) == null) {
            throw new InvalidModelException("invalid readonly-reference in Section " + String.valueOf(this.getParent()) + " : " + this.readonlyItemKey);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WizardDisplayInfoDTO.SectionItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        void var6_20;
        void var7_28;
        void var5_11;
        ModelItemDTO roMi;
        WizardDisplayInfoDTO.AbstractItemDTO formInfo;
        ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO> headerAddOnDTOs = new ArrayList<WizardDisplayInfoDTO.LabelAddOnDTO>();
        if (this.headerAddOns != null) {
            for (LabelAddOn labelAddOn : this.headerAddOns) {
                WizardDisplayInfoDTO.LabelAddOnDTO labelAddOnDTO = labelAddOn.getFormInfo(dataModel, key);
                if (labelAddOnDTO == null) continue;
                headerAddOnDTOs.add(labelAddOnDTO);
            }
        }
        if (headerAddOnDTOs.isEmpty()) {
            headerAddOnDTOs = null;
        }
        ArrayList<WizardDisplayInfoDTO.ColDefItemDTO> coldefsDTO = null;
        if (this.getColdefs() != null) {
            coldefsDTO = new ArrayList<WizardDisplayInfoDTO.ColDefItemDTO>();
            for (ColDef colDef : this.getColdefs()) {
                WizardDisplayInfoDTO.ColDefItemDTO colDefItemDTO = colDef.getFormInfo(dataModel, key);
                if (colDefItemDTO == null || colDefItemDTO.getState() == 12) continue;
                coldefsDTO.add(colDefItemDTO);
            }
            if (coldefsDTO.isEmpty()) {
                coldefsDTO = null;
            }
        }
        Object var5_8 = null;
        if (this.getHeaders() != null) {
            ArrayList<WizardDisplayInfoDTO.HelpItemDTO> arrayList = new ArrayList<WizardDisplayInfoDTO.HelpItemDTO>();
            for (Header header : this.getHeaders()) {
                formInfo = header.getFormInfo(dataModel, key);
                if (formInfo == null) continue;
                arrayList.add((WizardDisplayInfoDTO.HelpItemDTO)formInfo);
            }
            if (arrayList.isEmpty()) {
                Object var5_10 = null;
            }
        }
        Object var6_17 = null;
        if (this.getRows() != null) {
            ArrayList<WizardDisplayInfoDTO.RowItemDTO> arrayList = new ArrayList<WizardDisplayInfoDTO.RowItemDTO>();
            for (RowItemBase element : this.getRows()) {
                Object formInfo2;
                WizardDisplayInfoDTO.RowItemDTO formInfo4;
                if (element instanceof Row && (formInfo4 = ((Row)element).getFormInfo(dataModel, key)) != null) {
                    arrayList.add(formInfo4);
                }
                if (!(element instanceof RowIterator) || !((formInfo2 = ((RowIterator)element).getFormInfo(dataModel, key)) instanceof List)) continue;
                arrayList.addAll((Collection<WizardDisplayInfoDTO.RowItemDTO>)formInfo2);
            }
            if (arrayList.isEmpty()) {
                Object var6_19 = null;
            }
        }
        Object var7_26 = null;
        if (this.help != null && (formInfo = this.help.getFormInfo(dataModel, key)) != null) {
            WizardDisplayInfoDTO.HelpItemDTO helpItemDTO = formInfo;
        }
        int state = dataModel.getWithoutTouch(key).getState();
        if (this.stateKey != null) {
            ModelItemDTO stateMi = dataModel.get(EngineUtil.mergeModelKey(this.stateKey, key));
            state = stateMi == null ? 12 : stateMi.getState();
        }
        boolean ro = false;
        if (this.readonly != null) {
            ro = this.readonly;
        } else if (this.readonlyItemKey != null && (roMi = dataModel.get(EngineUtil.mergeModelKey(this.readonlyItemKey, key))) != null && roMi.getValue() != null) {
            Object roValue = roMi.getValue();
            ro = roValue instanceof Boolean ? ((Boolean)roValue).booleanValue() : Boolean.valueOf(roValue.toString()).booleanValue();
        }
        WizardDisplayInfoDTO.SectionItemDTO result = new WizardDisplayInfoDTO.SectionItemDTO(this.getUniqueItemIdentifier(), state, coldefsDTO, (List<WizardDisplayInfoDTO.HeaderItemDTO>)var5_11, (WizardDisplayInfoDTO.HelpItemDTO)var7_28, (List<WizardDisplayInfoDTO.RowItemDTO>)var6_20, ro, this.viewId, this.header, headerAddOnDTOs, this.styleClass, this.stateKey);
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<ColDef> coldefs = !elements.isEmpty() ? new ArrayList<ColDef>() : null;
            ArrayList<Header> headers = !elements.isEmpty() ? new ArrayList<Header>() : null;
            ArrayList<RowItemBase> rows = !elements.isEmpty() ? new ArrayList<RowItemBase>() : null;
            ArrayList<LabelAddOn> labelAddOns = new ArrayList<LabelAddOn>();
            Help help = null;
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof ColDef) {
                        coldefs.add((ColDef)ref);
                        continue;
                    }
                    if (ref instanceof LabelAddOn) {
                        labelAddOns.add((LabelAddOn)ref);
                        continue;
                    }
                    if (ref instanceof Header) {
                        headers.add((Header)ref);
                        continue;
                    }
                    if (ref instanceof Help) {
                        help = (Help)ref;
                        continue;
                    }
                    if (ref instanceof RowItemBase) {
                        rows.add((RowItemBase)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            if (labelAddOns.isEmpty() && element.getAttribute("header-add-on") != null) {
                labelAddOns.add(new LabelAddOn(element.getAttributeValue("header-add-on")));
            }
            if (labelAddOns.isEmpty()) {
                labelAddOns = null;
            }
            if (element.getAttribute("help") != null) {
                help = new Help(element.getAttributeValue("help"));
            }
            return new ClassObjectPair(Section.class, (Object)new Section(coldefs, headers, help, rows, element.getAttributeValue("state"), element.getAttributeValue("readonly"), element.getAttributeValue("viewId"), element.getAttributeValue("header"), labelAddOns, element.getAttributeValue("styleClass")));
        }
    }
}

