/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay.items;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.modelitems.Calc;
import ch.dvbern.tax.common.engine.modelitems.TableSum;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.wizarddisplay.DisplayItemUniqueID;
import ch.dvbern.tax.common.engine.wizarddisplay.WItemValueHolder;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Table;
import ch.dvbern.tax.common.engine.wizarddisplay.items.WizardDisplayUtil;
import ch.dvbern.tax.common.presentation.common.util.Render;
import ch.dvbern.tax.common.presentation.common.util.RenderBuilder;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Col
extends WizardDisplayModelItem
implements WItemValueHolder {
    private final int type;
    private final String valueKey;
    private LogicModelItem valueModelItem;
    private Boolean readonly;
    private final String align;
    private final String style;
    private final String styleClass;
    private final Boolean negative;
    private final AbstractConverter<?> rendererAndValidator;
    private final Render reRender;
    private final @Nullable String titleKey;
    private final boolean emitFocusEvents;

    public Col(int type, String valueKey, Boolean readonly, String align, String style, String styleClass, Boolean negative, AbstractConverter<?> rendererAndValidator, Render reRender, @Nullable String titleKey, boolean emitFocusEvents) {
        this.type = type;
        this.valueKey = valueKey;
        this.readonly = readonly;
        this.align = align;
        this.style = style;
        this.styleClass = styleClass;
        this.negative = negative;
        this.rendererAndValidator = rendererAndValidator;
        this.reRender = reRender == null ? new Render() : reRender;
        this.titleKey = titleKey;
        this.emitFocusEvents = emitFocusEvents;
    }

    public List<WizardDisplayModelItem> getChildren() {
        return null;
    }

    public String getAlign() {
        return this.align;
    }

    public String getDataModelKey() {
        return this.valueModelItem.getName();
    }

    public LogicModelItem getValueModelItem() {
        return this.valueModelItem;
    }

    public int getType() {
        return this.type;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public String getStyle() {
        return this.style;
    }

    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public DisplayItemUniqueID getUniqueItemIdentifier() {
        return super.getUniqueItemIdentifier();
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public AbstractConverter<?> getRendererAndValidator() {
        return this.rendererAndValidator;
    }

    @Override
    public void additionalInitializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems) throws InvalidModelException {
        if (this.valueKey != null) {
            if (logicModelItems.get(this.valueKey) == null) {
                throw new InvalidModelException("invalid value in col: " + this.valueKey);
            }
            this.valueModelItem = logicModelItems.get(this.valueKey);
        }
        if (this.readonly == null) {
            this.readonly = this.valueModelItem instanceof Calc || this.valueModelItem instanceof TableSum ? Boolean.TRUE : Boolean.FALSE;
        }
    }

    @Override
    public WizardDisplayInfoDTO.ColItemDTO getFormInfo(WizardDisplayModelItem.ProtectedMap dataModel, String key) {
        int stateParent = 1;
        String parentStateItem = ((Table)this.getParent()).getStateItem();
        if (parentStateItem != null) {
            stateParent = dataModel.getWithoutTouch(EngineUtil.mergeModelKey(parentStateItem, key)).getState();
        }
        int index = 0;
        for (int i = 0; i < ((Table)this.getParent()).getCols().size(); ++i) {
            Col element = ((Table)this.getParent()).getCols().get(i);
            if (element != this) continue;
            index += i;
            break;
        }
        int stateColdef = 12;
        WizardDisplayInfoDTO.ColDefItemDTO formInfo = ((Table)this.getParent()).getColdefs().get(index).getFormInfo(dataModel, key);
        if (formInfo != null) {
            stateColdef = formInfo.getState();
        }
        int width = 0;
        if (formInfo != null && !formInfo.isWidthUndefined()) {
            width = Integer.parseInt(formInfo.getWidth());
        }
        int stateItemDTO = stateColdef;
        if (stateParent == 11 || stateParent == 12) {
            stateItemDTO = stateParent;
        }
        ArrayList<WizardDisplayInfoDTO.ItemItemDTO> itemsList = new ArrayList<WizardDisplayInfoDTO.ItemItemDTO>();
        Set itemsSet = (Set)dataModel.getWithoutTouch(EngineUtil.mergeModelKey(((Table)this.getParent()).getName(), key)).getValue();
        if (itemsSet == null) {
            return new WizardDisplayInfoDTO.ColItemDTO(this.getUniqueItemIdentifier(), stateItemDTO, null);
        }
        for (String i : itemsSet) {
            String tableDMK = EngineUtil.mergeModelKey(((Table)this.getParent()).getName(), key);
            String itemNameWithinTable = this.valueModelItem.getNameWithTableIndexShapes();
            itemNameWithinTable = itemNameWithinTable.substring(itemNameWithinTable.lastIndexOf(35) + 1);
            String dataModelKey = tableDMK + "." + i + itemNameWithinTable;
            ModelItemDTO miDTO = dataModel.getWithoutTouch(dataModelKey);
            Object o = miDTO.getValue();
            Collection<MessageItemDTO> messages = miDTO.getMessages();
            if (((Table)this.getParent()).isEditable()) {
                stateItemDTO = miDTO.getState();
            }
            OptionItemsDTO optionItems = null;
            if (this.valueModelItem instanceof LogicModelItem.SelectItem) {
                optionItems = ((LogicModelItem.SelectItem)((Object)this.valueModelItem)).getOptionItems(dataModel, dataModelKey);
            }
            WizardDisplayInfoDTO.ItemItemDTO itemDTO = new WizardDisplayInfoDTO.ItemItemDTO(this.getUniqueItemIdentifier().appendLocal(dataModelKey), stateItemDTO, this.type, dataModelKey, o, 1, 1, width, optionItems, messages, this.readonly, this.align, this.style, this.styleClass, null, null, this.negative, this.rendererAndValidator, true, this.valueKey, null, this.reRender, null, null, this.titleKey, this.emitFocusEvents);
            itemsList.add(itemDTO);
        }
        return new WizardDisplayInfoDTO.ColItemDTO(this.getUniqueItemIdentifier(), stateItemDTO, itemsList);
    }

    @Override
    public String getValueKey() {
        return this.valueKey;
    }

    public static class XMLFactory
    implements ElementParser {
        private static final String VALUE = "value";
        private static final String READONLY = "readonly";
        private static final String RERENDER = "reRender";
        private static final String TITLE_KEY = "titleKey";

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            AbstractConverter rendererAndValidator = null;
            if (elements.size() > 1) {
                throw new ElementParserException("invalid child element in: " + String.valueOf(element));
            }
            if (elements.size() == 1) {
                Element subElement = (Element)elements.get(0);
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (!(ref instanceof AbstractConverter)) {
                        throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                    }
                    rendererAndValidator = (AbstractConverter)ref;
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            WizardDisplayUtil.TypeAndConverter typeAndConverter = WizardDisplayUtil.parseInputType(element, rendererAndValidator);
            Boolean readonly = null;
            if (element.getAttribute(READONLY) != null) {
                readonly = Boolean.valueOf(element.getAttributeValue(READONLY));
            }
            Render reRender = new Render();
            if (element.getAttribute(RERENDER) != null) {
                reRender = RenderBuilder.create(element.getAttributeValue(RERENDER)).build();
            }
            if (element.getAttributeValue("javaScript") != null) {
                throw new ElementParserException("invalid argument 'javaScript' in item " + element.getAttributeValue(VALUE));
            }
            if (element.getAttributeValue("scriptFile") != null) {
                throw new ElementParserException("invalid argument 'scriptFile' in item " + element.getAttributeValue(VALUE));
            }
            String titleKey = null;
            if (element.getAttributeValue(TITLE_KEY) != null) {
                titleKey = element.getAttributeValue(TITLE_KEY);
            }
            Boolean negative = Boolean.valueOf(element.getAttributeValue("negative"));
            return new ClassObjectPair(Col.class, (Object)new Col(typeAndConverter.type, element.getAttributeValue(VALUE), readonly, typeAndConverter.alignment, element.getAttributeValue("style"), element.getAttributeValue("styleClass"), negative, typeAndConverter.converter, reRender, titleKey, WizardDisplayUtil.getBoolean(element.getAttributeValue("emitFocusEvents"), false)));
        }
    }
}

