/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.wizarddisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.ModelRoot;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.WizardModelVisitor;
import ch.dvbern.tax.common.engine.wizarddisplay.WItemValueHolder;
import ch.dvbern.tax.common.engine.wizarddisplay.WTableEntryAccessor;
import ch.dvbern.tax.common.engine.wizarddisplay.WizardDisplayModelItem;
import ch.dvbern.tax.common.engine.wizarddisplay.items.Form;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class WizardDisplayModel {
    public static final int TMO_STATE_RELEASED = 100;
    private final Map<String, Form> formsMap;

    public WizardDisplayModel(List<Form> forms) {
        if (forms == null) {
            throw new NullPointerException("Forms list cannot be null.");
        }
        this.formsMap = new LinkedHashMap<String, Form>(forms.size());
        for (Form form : forms) {
            if (this.formsMap.put(form.getName(), form) == null) continue;
            throw new IllegalArgumentException("Multiple form available for the same module: " + form.getName());
        }
    }

    public void initializeWizardDisplayModel(Map<String, LogicModelItem> logicModelItems, Map<String, Form> wizardDisplayModelItems) throws InvalidModelException {
        for (Form form : this.formsMap.values()) {
            this.preInitialization(logicModelItems, form, new ArrayDeque<String>());
            wizardDisplayModelItems.put(form.getName(), form);
            form.initializeWizardDisplayModel(logicModelItems, wizardDisplayModelItems);
        }
    }

    private void preInitialization(Map<String, LogicModelItem> logicModel, WizardDisplayModelItem item, Deque<String> tableEntryAccessors) throws InvalidModelException {
        assert (tableEntryAccessors != null);
        List<? extends WizardDisplayModelItem> children = item.getChildren();
        if (children == null) {
            return;
        }
        boolean tableEntryAccessor = item instanceof WTableEntryAccessor;
        if (tableEntryAccessor) {
            tableEntryAccessors.push(((WTableEntryAccessor)((Object)item)).getName());
        }
        String currentAccessorName = tableEntryAccessors.peek();
        for (WizardDisplayModelItem wizardDisplayModelItem : children) {
            wizardDisplayModelItem.setParent(item);
            if (wizardDisplayModelItem instanceof WItemValueHolder) {
                String valueKey = ((WItemValueHolder)((Object)wizardDisplayModelItem)).getValueKey();
                LogicModelItem lmi = logicModel.get(valueKey);
                if (lmi == null) {
                    throw new InvalidModelException(String.format("Unable to find item %s defined in children item value holder.", valueKey));
                }
                String indexedName = lmi.getNameWithTableIndexShapes();
                int lastTableIndex = indexedName.lastIndexOf(".#");
                if (lastTableIndex != -1) {
                    String parentTable = indexedName.substring(0, lastTableIndex).replaceAll("\\.#", "");
                    if (currentAccessorName == null || !currentAccessorName.startsWith(parentTable)) {
                        throw new InvalidModelException(String.format("Cannot reference item %s in %s, outside of table %s.", lmi.getName(), currentAccessorName, parentTable));
                    }
                }
            }
            this.preInitialization(logicModel, wizardDisplayModelItem, tableEntryAccessors);
        }
        if (tableEntryAccessor) {
            String accessorName = tableEntryAccessors.pop();
            assert (item instanceof WTableEntryAccessor && accessorName.equals(currentAccessorName));
        }
    }

    public WizardDisplayInfoDTO.BreadcrumbsItemDTO getBreadcrumbsRoot(Map<String, LogicModelItem> logicModelItems, String dmk) {
        String currentLmk;
        if (dmk == null) {
            throw new NullPointerException("key cannot be null");
        }
        LogicModelItem current = logicModelItems.get(EngineUtil.removeTableIndices(dmk));
        if (current == null) {
            String title = "keinTitel";
            String navItemDMK = "nix-key";
            WizardDisplayInfoDTO.BreadcrumbsItemDTO child = null;
            return new WizardDisplayInfoDTO.BreadcrumbsItemDTO(title, navItemDMK, child);
        }
        WizardDisplayInfoDTO.BreadcrumbsItemDTO rootBreadcrumb = null;
        do {
            assert (current != null);
            currentLmk = current.getName();
            if (!(current instanceof Module)) continue;
            rootBreadcrumb = new WizardDisplayInfoDTO.BreadcrumbsItemDTO(((Module)current).getTitle(), EngineUtil.mergeModelKey(currentLmk, dmk), rootBreadcrumb);
        } while ((current = logicModelItems.get(EngineUtil.removeLastKeyPart(currentLmk))) != null);
        return rootBreadcrumb;
    }

    public List<WizardDisplayInfoDTO.NavigationsItemDTO> getNavigationsInfo(Module module, WizardDisplayModelItem.ProtectedMap dataModel, ModelRoot tmoRoot, String navKey, int tmoState, int caller) {
        List<WizardDisplayInfoDTO.NavigationsItemDTO> result = null;
        List<LogicModelItem> topLMIs = null;
        LogicModelItem parent = module.getParent();
        while (parent instanceof Module) {
            parent = parent.getParent();
        }
        if (parent == null) {
            topLMIs = tmoRoot.getLogicModel().getTopLevelItems();
        }
        if (parent instanceof LogicModelItem.TableItem) {
            topLMIs = parent.getChildren();
        }
        if (topLMIs != null) {
            result = this.getChildNavigationItems(dataModel, topLMIs, module, navKey, tmoState, caller);
        }
        return result;
    }

    private List<WizardDisplayInfoDTO.NavigationsItemDTO> getChildNavigationItems(WizardDisplayModelItem.ProtectedMap dataModel, List<? extends LogicModelItem> childLMIs, LogicModelItem current, String dataModelKey, int tmoState, int caller) {
        ArrayList<WizardDisplayInfoDTO.NavigationsItemDTO> result = new ArrayList<WizardDisplayInfoDTO.NavigationsItemDTO>();
        if (childLMIs != null) {
            for (LogicModelItem logicModelItem : childLMIs) {
                if (!(logicModelItem instanceof Module)) continue;
                Module module = (Module)logicModelItem;
                String navItemDMK = EngineUtil.mergeModelKey(logicModelItem.getName(), dataModelKey);
                ModelItemDTO dto = dataModel.getWithoutTouch(navItemDMK);
                int navigationState = this.getNavigationState(dataModel, module, dataModelKey, tmoState, caller);
                if (dto == null || !this.isAvailableInNavigation(module, navigationState)) continue;
                List<WizardDisplayInfoDTO.NavigationsItemDTO> childNavItems = null;
                if (current.getName().startsWith(logicModelItem.getName())) {
                    childNavItems = this.getChildNavigationItems(dataModel, logicModelItem.getChildren(), current, dataModelKey, tmoState, caller);
                }
                WizardDisplayInfoDTO.NavigationsItemDTO navigationItem = new WizardDisplayInfoDTO.NavigationsItemDTO(navItemDMK, ((Module)logicModelItem).getTitle(), navigationState, current.getName().equals(logicModelItem.getName()), childNavItems);
                result.add(navigationItem);
            }
        }
        return result;
    }

    private boolean isDisabledModule(Module module, int caller) {
        boolean result = false;
        if (module.isDisabledIfCd() && caller == 1) {
            result = true;
        }
        if (module.isDisabledIfOnline() && caller == 2) {
            result = true;
        }
        return result;
    }

    private boolean isTransparentModule(Module module, int tmoState) {
        boolean result = false;
        if (module.isTransparentIfNotReleasable() && ModelItemDTO.isMoreImportantState(tmoState, 2)) {
            result = true;
        }
        if (module.isTransparentIfNotReleased() && tmoState != 100) {
            result = true;
        }
        if (module.isTransparentIfReleased() && tmoState == 100) {
            result = true;
        }
        if (module.isTransparentIfReceipted() && (tmoState == 7 || tmoState == 6 && tmoState != 100)) {
            result = true;
        }
        return result;
    }

    public String getBack(String key, Map<String, LogicModelItem> logicModelItems) {
        LogicModelItem logicModelItem = logicModelItems.get(EngineUtil.removeTableIndices(key));
        if (!(logicModelItem instanceof Module)) {
            return null;
        }
        LogicModelItem current = logicModelItem;
        while (current.getParent() != null) {
            if (current.getParent() instanceof LogicModelItem.TableItem) {
                String modulName = current.getParent().getParent().getName();
                return EngineUtil.mergeModelKey(modulName, key);
            }
            current = current.getParent();
        }
        return null;
    }

    public String getPrev(String moduleDMK, WizardDisplayModelItem.ProtectedMap dataModel, Map<String, LogicModelItem> logicModelItems, int tmoState, int caller) {
        return this.getNeighbor(moduleDMK, dataModel, logicModelItems, tmoState, caller, false);
    }

    public String getNext(String moduleDMK, WizardDisplayModelItem.ProtectedMap dataModel, Map<String, LogicModelItem> logicModelItems, int tmoState, int caller) {
        return this.getNeighbor(moduleDMK, dataModel, logicModelItems, tmoState, caller, true);
    }

    private String getNeighbor(String moduleDMK, WizardDisplayModelItem.ProtectedMap dataModel, Map<String, LogicModelItem> logicModelItems, int tmoState, int caller, boolean next) {
        LogicModelItem logicModelItem = logicModelItems.get(EngineUtil.removeTableIndices(moduleDMK));
        if (!(logicModelItem instanceof Module)) {
            throw new IllegalArgumentException("Not a module data model key: " + moduleDMK);
        }
        Module neighbor = (Module)logicModelItem;
        while ((neighbor = next ? neighbor.getNextItem() : neighbor.getPreviousItem()) != null) {
            int navigationState = this.getNavigationState(dataModel, neighbor, moduleDMK, tmoState, caller);
            if (navigationState == 11 || !this.isAvailableInNavigation(neighbor, navigationState)) continue;
            return EngineUtil.mergeModelKey(neighbor.getName(), moduleDMK);
        }
        return null;
    }

    private boolean isAvailableInNavigation(Module module, int navigationState) {
        Form wForm = this.formsMap.get(module.getName());
        if (wForm == null || wForm.isExtraFrom()) {
            return false;
        }
        return navigationState != 12;
    }

    public String getParent(String key, Map<String, LogicModelItem> logicModelItems) {
        LogicModelItem logicModelItem = logicModelItems.get(EngineUtil.removeTableIndices(key));
        if (!(logicModelItem instanceof Module)) {
            return null;
        }
        LogicModelItem parentItem = logicModelItem.getParent();
        return parentItem != null ? EngineUtil.mergeModelKey(parentItem.getName(), key) : null;
    }

    public int getNavigationState(WizardDisplayModelItem.ProtectedMap dataModel, Module module, String key, int tmoState, int caller) {
        if (this.isDisabledModule(module, caller)) {
            return 12;
        }
        ModelItemDTO moduleItem = dataModel.getModelItem(EngineUtil.mergeModelKey(module.getName(), key));
        int moduleState = moduleItem.getState();
        if (moduleState != 12) {
            LogicModelItem parent = module;
            while ((parent = parent.getParent()) != null) {
                String dmk = EngineUtil.mergeModelKey(parent.getName(), key);
                ModelItemDTO miDTO = dataModel.getWithoutTouch(dmk);
                int state = miDTO.getState();
                if (state != 11 && state != 12) continue;
                return state;
            }
            if (this.isTransparentModule(module, tmoState)) {
                return 11;
            }
        }
        return moduleState;
    }

    public void visit(@NonNull WizardModelVisitor visitor) {
        if (visitor == null) {
            throw new NullPointerException("Model visitor cannot be null.");
        }
        for (Form form : this.formsMap.values()) {
            this.visit(visitor, form);
        }
    }

    private void visit(WizardModelVisitor visitor, WizardDisplayModelItem item) {
        assert (visitor != null && item != null);
        visitor.accept(item);
        List<? extends WizardDisplayModelItem> children = item.getChildren();
        if (children != null) {
            for (WizardDisplayModelItem wizardDisplayModelItem : children) {
                this.visit(visitor, wizardDisplayModelItem);
            }
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            List elements = element.getChildren();
            ArrayList<Form> childItems = new ArrayList<Form>(elements.size());
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Form) {
                        childItems.add((Form)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            return new ClassObjectPair(WizardDisplayModel.class, (Object)new WizardDisplayModel(childItems));
        }
    }
}

