/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.validators;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CopyValue
implements Validator {
    private CalcItem[] calcItemsForCondition;
    private Reference itemToCopyFrom = null;
    private boolean copyOnRecalculate;

    public CopyValue(Reference itemToCopyFrom, CalcItem[] calcItemsForCondition) {
        this(itemToCopyFrom, calcItemsForCondition, false);
    }

    public CopyValue(Reference itemToCopyFrom, CalcItem[] calcItemsForCondition, boolean copyOnRecalculate) {
        this.itemToCopyFrom = itemToCopyFrom;
        this.calcItemsForCondition = (CalcItem[])calcItemsForCondition.clone();
        this.copyOnRecalculate = copyOnRecalculate;
    }

    public CopyValue(Reference itemToCopyFrom) {
        this.itemToCopyFrom = itemToCopyFrom;
    }

    @Override
    public void initializeReferences(@NonNull Map<String, LogicModelItem> logicModel, @NonNull LogicModelItem logicModelItem) throws InvalidModelException {
        this.itemToCopyFrom.registerListenerOnReference(logicModel, logicModelItem, false);
        for (CalcItem calcItem : this.calcItemsForCondition) {
            if (calcItem instanceof Reference) {
                ((Reference)((Object)calcItem)).registerListenerOnReference(logicModel, logicModelItem, false);
                continue;
            }
            if (!(calcItem instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)calcItem).initializeReferences(logicModel, logicModelItem);
        }
    }

    @Override
    public @NonNull ModelItemDTO validate(LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        boolean doCopy;
        ModelItemDTO result = modelItemDTO;
        boolean bl = doCopy = this.calcItemsForCondition != null;
        if (this.calcItemsForCondition != null) {
            FastStack stack = new FastStack();
            for (CalcItem calcItem : this.calcItemsForCondition) {
                try {
                    calcItem.evaluate(dataModel, stack, dataModelKey);
                }
                catch (RuntimeException rte) {
                    throw new IllegalArgumentException("Error evaluating CalcItem: " + dataModelKey, rte);
                }
            }
            Object calcItemsResult = null;
            doCopy = !stack.isEmpty() ? ((calcItemsResult = stack.pop()) != null ? (Boolean)calcItemsResult : false) : false;
        }
        if (doCopy) {
            ModelItemDTO referencedItem = dataModel.get(EngineUtil.mergeModelKey(this.itemToCopyFrom.getName(), dataModelKey));
            if (!(modelItemDTO.getValue() != null && this.valueEquals(result, referencedItem) || !this.copyOnRecalculate && dataModel.isRecalculating() || referencedItem == null)) {
                result = result.clone(referencedItem.getValue());
            }
        }
        return result;
    }

    private boolean valueEquals(ModelItemDTO copyFrom, ModelItemDTO copyTo) {
        Object vOld = copyTo == null ? null : copyTo.getValue();
        Object vNew = copyFrom.getValue();
        if (vOld == null) {
            return vNew == null;
        }
        return vOld.equals(vNew);
    }
}

