/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelloader;

import ch.dvbern.tax.common.engine.modelloader.ModelFileResolver;
import ch.dvbern.tax.common.engine.modelloader.ModelSource;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.concurrent.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;

@ThreadSafe
public class ModelSources {
    public static final Charset XML_CONF_CHARSET = StandardCharsets.UTF_8;
    private static final Pattern WINDOWS_NEWLINES_PATTERN = Pattern.compile("\\\\");
    private static final String COMMENT_PREFIX_1 = "*";
    private static final String COMMENT_PREFIX_2 = "#";
    private static final String MODEL_FILE_EXTENSION = ".xml";
    private final @NonNull List<@NonNull ModelSource> sources;
    private final @NonNull String sourceInfo;

    private ModelSources(@NonNull List<@NonNull ModelSource> sources, @NonNull String sourceInfo) {
        this.sources = Collections.unmodifiableList(new ArrayList<ModelSource>(sources));
        this.sourceInfo = sourceInfo;
    }

    public static @NonNull ModelSources fromPath(@NonNull Path xmlConfFile, @NonNull ModelFileResolver resolver) throws IOException, FileNotFoundException {
        Path absolutePath = xmlConfFile.toAbsolutePath();
        if (!absolutePath.toFile().exists()) {
            throw new FileNotFoundException("xmlConf: " + String.valueOf(xmlConfFile));
        }
        List<ModelSource> sources = Files.readAllLines(absolutePath, XML_CONF_CHARSET).stream().flatMap(line -> ModelSources.parseLineWithPath(line, resolver)).collect(Collectors.toList());
        ModelSources.validateFiles(sources);
        return new ModelSources(sources, "path: " + String.valueOf(absolutePath));
    }

    public static @NonNull ModelSources fromStream(@NonNull InputStream xmlConf, @NonNull ModelFileResolver resolver, @NonNull String sourceInfo) throws IOException {
        try (BufferedReader r = new BufferedReader(new InputStreamReader(xmlConf, XML_CONF_CHARSET));){
            List<ModelSource> sources = r.lines().flatMap(line -> ModelSources.parseLineWithPath(line, resolver)).collect(Collectors.toList());
            ModelSources modelSources = new ModelSources(sources, "InputStream: " + sourceInfo);
            return modelSources;
        }
    }

    public static @NonNull ModelSources fromClasspath(@NonNull String xmlConfResource, @NonNull ClassLoader classLoader) throws IOException, FileNotFoundException {
        try (InputStream is = classLoader.getResourceAsStream(xmlConfResource);){
            if (is == null) {
                throw new FileNotFoundException("xmlConfResource: " + xmlConfResource);
            }
            ModelFileResolver resolver = name -> Objects.requireNonNull(classLoader.getResource(name), () -> "Could not find file in classpath: " + name);
            ModelSources modelSources = ModelSources.fromStream(is, resolver, "Classpath: " + xmlConfResource);
            return modelSources;
        }
    }

    public static @NonNull ModelSources fromClasspath(@NonNull String xmlConfResource) throws IOException, FileNotFoundException {
        return ModelSources.fromClasspath(xmlConfResource, Thread.currentThread().getContextClassLoader());
    }

    private static void validateFiles(List<ModelSource> sources) {
        List directories = sources.stream().filter(s -> s.getUrl().getProtocol().equals("file")).filter(s -> Paths.get(s.getUrl().getPath(), new String[0]).toFile().isDirectory()).collect(Collectors.toList());
        if (!directories.isEmpty()) {
            throw new IllegalArgumentException("Directories are not supported yet: " + String.valueOf(directories));
        }
    }

    private static Stream<ModelSource> parseLineWithPath(String line, ModelFileResolver resolver) {
        return Stream.of(line).map(ModelSources::cleanupLine).filter(ModelSources::cleanLineHasContent).peek(ModelSources::failOnInvalidFileExtension).map(verified -> ModelSources.executeResolver(resolver, verified)).map(ModelSource::of);
    }

    private static @NonNull URL executeResolver(ModelFileResolver resolver, String line) {
        try {
            URL resolved = resolver.apply(line);
            return Objects.requireNonNull(resolved, "Could not resolve: " + line);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("Could not resolve: " + line, e);
        }
    }

    private static void failOnInvalidFileExtension(String cleanLine) {
        if (!cleanLine.endsWith(MODEL_FILE_EXTENSION)) {
            throw new IllegalArgumentException("Line is not a file: " + cleanLine);
        }
    }

    private static String cleanupLine(String line) {
        String trimmed = line.trim();
        String result = WINDOWS_NEWLINES_PATTERN.matcher(trimmed).replaceAll("/");
        return result;
    }

    private static boolean cleanLineHasContent(String line) {
        boolean result = !line.isEmpty() && !line.startsWith(COMMENT_PREFIX_1) && !line.startsWith(COMMENT_PREFIX_2);
        return result;
    }

    public @NonNull String toString() {
        return String.format("%s[%s,%s]", this.getClass().getSimpleName(), this.sourceInfo, this.sources);
    }

    public @NonNull List<@NonNull ModelSource> getSources() {
        return this.sources;
    }

    public @NonNull String getSourceInfo() {
        return this.sourceInfo;
    }
}

