/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems.addons;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableEntryItemSynchronizer
extends LogicModelItem
implements LogicModelItem.TableItem.TableEventListener {
    private final Reference rootTable;
    private final Reference[] itemsToSynchronize;
    private final Map<String, Reference> itemsToSynchronizeByName;
    private LogicModelItem thisTable;

    public TableEntryItemSynchronizer(String name, Reference tableWithTheItems, Reference[] theItems) {
        super(name, null, null, true, "false", true, false, new SimpleValuePersistenceHint());
        this.rootTable = tableWithTheItems;
        this.itemsToSynchronize = (Reference[])theItems.clone();
        this.itemsToSynchronizeByName = new HashMap<String, Reference>(this.itemsToSynchronize.length);
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        super.additionalInitializeReferences(logicModel);
        this.thisTable = this.getParent();
        if (!(this.thisTable instanceof LogicModelItem.TableItem)) {
            throw new InvalidModelException("Parent of " + TableEntryItemSynchronizer.class.getName() + " must be a table");
        }
        this.registerTableEventListener(this.thisTable);
        for (Reference theItem : this.itemsToSynchronize) {
            theItem.registerListenerOnReference(logicModel, this, false);
            this.itemsToSynchronizeByName.put(theItem.getName(), theItem);
        }
    }

    private void registerTableEventListener(LogicModelItem lmi) throws InvalidModelException {
        if (lmi == null) {
            String s = "tableWithTheItems argument (" + this.rootTable.getName() + ") must be a superitem of " + this.getName() + " (class: " + this.getClass().getName() + ")";
            throw new InvalidModelException(s);
        }
        if (lmi instanceof LogicModelItem.TableItem) {
            ((LogicModelItem.TableItem)((Object)lmi)).addTableEventListener(this);
        }
        if (lmi.getName().equals(this.rootTable.getName())) {
            return;
        }
        this.registerTableEventListener(lmi.getParent());
    }

    @Override
    public void onTableEntryAdd(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        if (!source.getName().equals(this.rootTable.getName())) {
            return;
        }
        ArrayList<LMIwithKeyAndValue> newItems = new ArrayList<LMIwithKeyAndValue>();
        for (Map.Entry<String, ModelItemDTO> me : dataModel.entrySet()) {
            String dmk = me.getKey();
            Reference r = this.itemsToSynchronizeByName.get(EngineUtil.removeTableIndices(dmk));
            if (r == null) continue;
            String newDMK = this.replaceTableEntryIndex(dmk, tableDMK, index);
            newItems.add(new LMIwithKeyAndValue(r.getReference(), newDMK, me.getValue()));
        }
        for (LMIwithKeyAndValue lmiwkav : newItems) {
            lmiwkav.lmi.setValue(dataModel, lmiwkav.key, lmiwkav.value, null);
        }
    }

    @Override
    public void onTableEntryRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, String tableDMK, String index) {
        if (!source.getName().equals(this.thisTable.getName())) {
            Iterator<Map.Entry<String, ModelItemDTO>> itr = dataModel.getAsyncUpdates().entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry<String, ModelItemDTO> me = itr.next();
                if (me.getValue() != null || !EngineUtil.removeTableIndices(me.getKey()).equals(this.thisTable.getName())) continue;
                itr.remove();
            }
            return;
        }
        String mainTableDMK = EngineUtil.mergeModelKey(this.rootTable.getName(), tableDMK);
        mainTableDMK = EngineUtil.removeLastKeyPart(mainTableDMK);
        Set indices = (Set)dataModel.get(mainTableDMK).getValue();
        String currentDMK = tableDMK + "." + index;
        for (Object newIndex : indices) {
            String newDMK = this.replaceTableEntryIndex(currentDMK, mainTableDMK, newIndex.toString());
            if (newDMK.equals(currentDMK) || dataModel.get(newDMK) == null) continue;
            dataModel.getAsyncUpdates().put(newDMK, null);
        }
    }

    @Override
    public void onTableValueRemove(LogicModelItem source, LogicModelItem.ProtectedMap dataModel, ModelItemDTO removedDTO, String tableDMK) {
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        if (newValue == null) {
            return;
        }
        if (changedEventsOnlyOutsideOfThisTable != null && dataModelKey.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        String tableDMK = EngineUtil.mergeModelKey(this.rootTable.getName(), dataModelKey);
        tableDMK = EngineUtil.removeLastKeyPart(tableDMK);
        Set tableIndices = (Set)dataModel.get(tableDMK).getValue();
        for (Object index : tableIndices) {
            String otherItemDMK = this.replaceTableEntryIndex(dataModelKey, tableDMK, index.toString());
            Reference r = this.itemsToSynchronizeByName.get(EngineUtil.removeTableIndices(otherItemDMK));
            if (r == null) continue;
            r.getReference().setValue(dataModel, otherItemDMK, newValue, changedEventsOnlyOutsideOfThisTable);
        }
    }

    private String replaceTableEntryIndex(String dataModelKey, String tableDMK, String index) {
        assert (dataModelKey != null && tableDMK != null && dataModelKey.startsWith(tableDMK));
        String subDMK = dataModelKey.substring(tableDMK.length() + 1);
        subDMK = subDMK.substring(subDMK.indexOf(46));
        return tableDMK + "." + index + subDMK;
    }

    private static class LMIwithKeyAndValue {
        LogicModelItem lmi;
        String key;
        ModelItemDTO value;

        LMIwithKeyAndValue(LogicModelItem lmi, String key, ModelItemDTO value) {
            this.lmi = lmi;
            this.key = key;
            this.value = value;
        }
    }
}

