/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.DMK;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindFieldInTable
extends LogicModelItem {
    private static final Logger LOG = LoggerFactory.getLogger(FindFieldInTable.class);
    private static final Integer NUM_PARAMS = 3;
    private final @NonNull Reference valueToFind;
    private @NonNull LMK valueToFindLMK = null;
    private final @NonNull Reference srcRowIdentifier;
    private @NonNull LMK srcRowIdentifierLMK = null;
    private final @NonNull Reference dstRowIdentifier;
    private @NonNull LMK dstRowIdentifierLMK = null;
    private @NonNull Optional<Table> targetTable = Optional.empty();
    private @NonNull Table srcTable = null;

    public FindFieldInTable(@NonNull String name, @NonNull Reference valueToFind, @NonNull Reference srcRowIdentifier, @NonNull Reference dstRowIdentifier) {
        super(name, null, null, true, "false", false, false, new SimpleValuePersistenceHint());
        this.valueToFind = Objects.requireNonNull(valueToFind);
        this.srcRowIdentifier = Objects.requireNonNull(srcRowIdentifier);
        this.dstRowIdentifier = Objects.requireNonNull(dstRowIdentifier);
    }

    @Override
    public void additionalInitializeReferences(@NonNull Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        this.valueToFind.registerListenerOnReference(logicModel, this, true);
        this.srcRowIdentifier.registerListenerOnReference(logicModel, this, true);
        this.dstRowIdentifier.registerListenerOnReference(logicModel, this, true);
        this.valueToFindLMK = this.valueToFind.getReference().getLMK();
        this.srcRowIdentifierLMK = this.srcRowIdentifier.getReference().getLMK();
        this.dstRowIdentifierLMK = this.dstRowIdentifier.getReference().getLMK();
        Table srcValueTable = this.valueToFind.getReference().findContainingTable().orElseThrow(() -> new IllegalArgumentException("Not contained in table: " + String.valueOf(this.valueToFindLMK)));
        Table srcRowIdentTable = this.srcRowIdentifier.getReference().findContainingTable().orElseThrow(() -> new IllegalArgumentException("Not cainteind in table: " + String.valueOf(this.srcRowIdentifierLMK)));
        if (srcValueTable != srcRowIdentTable) {
            throw new IllegalArgumentException(String.format("Not in the same table @%s, srcValue: %s, srcRowIdentifier: %s", this.getName(), srcValueTable, this.srcRowIdentifier));
        }
        this.srcTable = srcValueTable;
        this.targetTable = this.findContainingTable();
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        throw new IllegalStateException("The value of the <find-field-in-table> calc is explicitly set? DMK: " + dataModelKey);
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        Set<DMK> thisItemRows = this.itemRows(dataModel);
        thisItemRows.forEach(row -> this.executeFind(dataModel, row.merge(this.dstRowIdentifierLMK), row.merge(this.getLMK()), changedEventsOnlyOutsideOfThisTable));
    }

    private void executeFind(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull DMK destIdentifierDMK, @NonNull DMK thisItemDMK, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        @NonNull Optional<ModelItemDTO> srcItemValue = this.findValueInSrcTable(dataModel, destIdentifierDMK);
        ModelItemDTO newValue = srcItemValue.map(ModelItemDTO::cloneTouched).orElse(new ModelItemDTO(null).cloneTouched());
        LOG.debug("update {}, SrcValue: {}, change: {}", new Object[]{this.getName(), srcItemValue, newValue});
        super.setValue(dataModel, thisItemDMK.toExternalForm(), newValue, changedEventsOnlyOutsideOfThisTable);
    }

    private @NonNull Optional<ModelItemDTO> findValueInSrcTable(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull DMK destIdentifierDMK) {
        return this.findTableRows(dataModel, this.srcTable).orElse(Collections.emptySet()).stream().filter(srcRow -> this.isValueEqual(destIdentifierDMK, srcRow.merge(this.srcRowIdentifierLMK), dataModel)).findAny().flatMap(foundSrcRow -> foundSrcRow.merge(this.valueToFindLMK).modelItem(dataModel));
    }

    private boolean isValueEqual(@NonNull DMK searchDMK, @NonNull DMK actualDMK, @NonNull LogicModelItem.ProtectedMap dataModel) {
        return Objects.equals(searchDMK.modelValue(dataModel), actualDMK.modelValue(dataModel));
    }

    private @NonNull Set<DMK> itemRows(@NonNull LogicModelItem.ProtectedMap dataModel) {
        Set<DMK> result = this.targetTable.flatMap(table -> this.findTableRows(dataModel, (Table)table)).orElse(Collections.singleton(this.getLMK().toRootlevelDMK()));
        return result;
    }

    private @NonNull Optional<Set<DMK>> findTableRows(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull Table table) {
        DMK tableDMK = table.getLMK().toRootlevelDMK();
        Optional<Set<DMK>> result = tableDMK.findRowDMKs(dataModel);
        return result;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Reference> refs = new ArrayList<Reference>();
            List subElements = element.getChildren();
            for (Element subElement : subElements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Reference) {
                        refs.add((Reference)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            String name = element.getAttributeValue("name");
            if (refs.size() != NUM_PARAMS.intValue()) {
                throw new ElementParserException("Need exactly 3 refs but found: " + refs.size() + " at elem: " + name);
            }
            FindFieldInTable result = new FindFieldInTable(name, (Reference)refs.get(0), (Reference)refs.get(1), (Reference)refs.get(2));
            return new ClassObjectPair(FindFieldInTable.class, (Object)result);
        }
    }
}

