/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.ComplexCalcItem;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.engine.validators.Delete;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Calc
extends LogicModelItem {
    private final List<CalcItem> calcItems;
    private final boolean listenToStateEvent;
    private final boolean referenceIntoTables;

    public Calc(String name, String persistenceKeyTemplate, List<CalcItem> calcItems, String doImport, boolean barcode, boolean listenToStateEvents, boolean referenceIntoTables) {
        super(name, null, persistenceKeyTemplate, true, doImport, false, barcode, new SimpleValuePersistenceHint());
        this.calcItems = calcItems;
        this.listenToStateEvent = listenToStateEvents;
        this.referenceIntoTables = referenceIntoTables;
    }

    @Override
    public void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        for (CalcItem ci : this.calcItems) {
            if (ci instanceof Reference) {
                ((Reference)((Object)ci)).registerListenerOnReference(logicModel, this, this.referenceIntoTables);
                continue;
            }
            if (!(ci instanceof ComplexCalcItem)) continue;
            ((ComplexCalcItem)ci).initializeReferences(logicModel, this);
        }
    }

    @Override
    public void setValue(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    protected void setValueInternal(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        super.setValue(dataModel, dataModelKey, modelItemDTO, changedEventsOnlyOutsideOfThisTable);
    }

    @Override
    public void stateChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        if (this.listenToStateEvent) {
            this.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
        }
    }

    @Override
    public void dataChanged(@NonNull LogicModelItem.ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && dmk.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        FastStack stack = new FastStack();
        int idx = 0;
        for (CalcItem ci : this.calcItems) {
            try {
                ci.evaluate(dataModel, stack, dmk);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Execution exception for calc item %s (index: %d) on item: %s", ci, idx, dmk), e);
            }
            ++idx;
        }
        Object value = stack.isEmpty() ? null : stack.pop();
        this.setValueInternal(dataModel, dmk, new ModelItemDTO(value), changedEventsOnlyOutsideOfThisTable);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<CalcItem> calcItems = new ArrayList<CalcItem>();
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof CalcItem) {
                        calcItems.add((CalcItem)ref);
                        continue;
                    }
                    if (ref instanceof Validator) {
                        if (ref instanceof Delete) {
                            throw new ElementParserException("delete validators are not allowed inside of a CalcItem!!!!" + element.getAttributeValue("name"));
                        }
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Engine.setMax(element, validators);
            Engine.setMin(element, validators);
            Engine.setMandatory(element, validators);
            Engine.setNotNegative(element, validators);
            Calc result = new Calc(element.getAttributeValue("name"), element.getAttributeValue("pKey"), calcItems, element.getAttributeValue("import"), Boolean.valueOf(element.getAttributeValue("barcode")), (boolean)Boolean.valueOf(element.getAttributeValue("listenToStateEvents")), (boolean)Boolean.valueOf(element.getAttributeValue("allow-table-refs")));
            for (Validator v : validators) {
                result.addValidator(v);
            }
            return new ClassObjectPair(Calc.class, (Object)result);
        }
    }
}

