/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.modelitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.lib.resource.construct.xml.ParserNotRegisteredException;
import ch.dvbern.tax.common.engine.Engine;
import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.Reference;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Bool
extends LogicModelItem
implements LogicModelItem.PreselectionItem {
    private final Object defaultValue;
    private final boolean hasInitialGreenState;
    private Reference defaultReference;
    private final boolean isPreselectionItem;

    public Bool(String name, String persistenceKeyTemplate, Boolean defaultValue, String defaultRelRefName, boolean readonly, String importPrevious, boolean hasInitialGreenState, boolean readonlyIfTransparent, boolean barcode, boolean isPreselectionItem) {
        super(name, null, persistenceKeyTemplate, readonly, importPrevious, readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
        this.defaultValue = defaultValue;
        if (defaultRelRefName != null) {
            this.defaultReference = new Reference(defaultRelRefName, true);
        }
        this.hasInitialGreenState = hasInitialGreenState;
        this.isPreselectionItem = isPreselectionItem;
    }

    @Override
    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        if (this.defaultReference != null) {
            this.defaultReference.initializeReference(logicModel, this, false);
        }
        super.additionalInitializeReferences(logicModel);
    }

    @Override
    protected ModelItemDTO getDefaultValue(LogicModelItem.ProtectedMap dataModel, String dataModelKey) {
        if (this.defaultValue != null) {
            return new ModelItemDTO(this.defaultValue);
        }
        if (this.defaultReference != null && dataModel.allowActiveValidations()) {
            boolean valuesExist = this.hasExistingData(dataModel, this.defaultReference.getReference(), dataModelKey);
            return new ModelItemDTO(valuesExist);
        }
        return null;
    }

    @Override
    protected boolean hasAnInitialGreenState() {
        if (this.hasInitialGreenState) {
            return true;
        }
        return super.hasAnInitialGreenState();
    }

    @Override
    public boolean isPreselectionItem() {
        return this.isPreselectionItem;
    }

    private boolean hasExistingData(LogicModelItem.ProtectedMap dataModel, LogicModelItem lmi, String dataModelKey) {
        ModelItemDTO miDTO = dataModel.get(EngineUtil.mergeModelKey(lmi.getName(), dataModelKey));
        if (!lmi.isReadonly() && miDTO != null && miDTO.getValue() != null) {
            return true;
        }
        if (lmi.getChildren() != null) {
            for (LogicModelItem element : lmi.getChildren()) {
                LogicModelItem childItem = element;
                if (!this.hasExistingData(dataModel, childItem, dataModelKey)) continue;
                return true;
            }
        }
        return false;
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            ArrayList<Validator> validators = new ArrayList<Validator>();
            List elements = element.getChildren();
            for (Element subElement : elements) {
                try {
                    String subElementName = subElement.getName();
                    ElementParser parser = factory.getParser(subElementName);
                    ClassObjectPair cop = parser.parse(subElement, factory);
                    Object ref = cop.getObject();
                    if (ref instanceof Validator) {
                        validators.add((Validator)ref);
                        continue;
                    }
                    throw new ElementParserException("invalid child element type: " + String.valueOf(ref));
                }
                catch (ParserNotRegisteredException pnre) {
                    throw new ElementParserException("could not locate parser for " + subElement.getName(), (Throwable)pnre);
                }
            }
            Engine.setMandatory(element, validators);
            Boolean defaultValue = null;
            if (element.getAttribute("default") != null) {
                defaultValue = Boolean.valueOf(element.getAttributeValue("default"));
            }
            boolean isPreselectionItem = true;
            if (element.getAttribute("preselection") != null) {
                isPreselectionItem = Boolean.parseBoolean(element.getAttributeValue("preselection"));
            }
            Bool result = new Bool(element.getAttributeValue("name"), element.getAttributeValue("pKey"), defaultValue, element.getAttributeValue("default-ref"), Boolean.valueOf(element.getAttributeValue("readonly")), element.getAttributeValue("import"), Boolean.valueOf(element.getAttributeValue("has-initial-green-state")), Boolean.valueOf(element.getAttributeValue("readonly-if-transparent")), Boolean.valueOf(element.getAttributeValue("barcode")), isPreselectionItem);
            for (Validator element2 : validators) {
                result.addValidator(element2);
            }
            return new ClassObjectPair(Bool.class, (Object)result);
        }
    }
}

