/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.expertdisplay;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.DataResource;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModel;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayModelItem;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertDisplayUtil;
import ch.dvbern.tax.common.engine.expertdisplay.ExpertFormDisplayModelItem;
import ch.dvbern.tax.common.presentation.common.print.pdf.printer.expert.ExpertItemPrinter;
import ch.dvbern.tax.common.transfer.dto.CustomPrinterDTO;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class CustomPrinterItem
extends ExpertFormDisplayModelItem {
    private final DataResource dataResource;
    private final Class<? extends ExpertItemPrinter<CustomPrinterDTO>> printer;

    private CustomPrinterItem(DataResource dataResource, Class<? extends ExpertItemPrinter<CustomPrinterDTO>> printer, Set<String> languages) {
        super(languages, 1, false);
        assert (printer != null);
        this.dataResource = dataResource;
        this.printer = printer;
    }

    public List<ExpertDisplayModelItem> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public ExpertDisplayInfoDTO.ItemDTO getItemDTO(ExpertDisplayModel.RequestContext requestContext) {
        return new CustomPrinterDTO(this.dataResource, requestContext.getDataModel(), requestContext.getLogicModelItems(), this.printer, this.getPrintMode(), this.getUniqueItemIdentifier());
    }

    public static class XMLFactory
    implements ElementParser {
        private final DataResource dataResource;

        public XMLFactory(@Nullable DataResource dataResource) {
            this.dataResource = dataResource;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Class<?> c;
            String printerClassName = element.getAttributeValue("name");
            if (printerClassName == null) {
                throw new ElementParserException("Name attribute must be given.");
            }
            try {
                c = Class.forName(printerClassName);
            }
            catch (ClassNotFoundException e) {
                throw new ElementParserException("No such class: " + printerClassName, (Throwable)e);
            }
            catch (LinkageError e) {
                throw new ElementParserException("Failed to load class " + printerClassName, (Throwable)e);
            }
            if (!ExpertItemPrinter.class.isAssignableFrom(c)) {
                throw new ElementParserException("Invalid item printer (cannot be assigned to " + ExpertItemPrinter.class.getCanonicalName() + ").");
            }
            CustomPrinterItem cpi = new CustomPrinterItem(this.dataResource, c, ExpertDisplayUtil.parseLanguages(element.getAttributeValue("lang")));
            return new ClassObjectPair(ExpertFormDisplayModelItem.class, (Object)cpi);
        }
    }
}

