/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.tax.common.ejb.util.CDIHelper;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Translate
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Translate needs 2 elements on stack (Language and key of Text to translate)");
        }
        Object oLanguage = stack.pop();
        Object oKey = stack.pop();
        if (oKey == null || oLanguage == null) {
            stack.push(null);
            return;
        }
        String key = (String)oKey;
        String language = (String)oLanguage;
        Locale locale = new Locale(language, "CH");
        String translatedText = CDIHelper.getResourceBundleManager().translate(key, locale, new Object[0]);
        stack.push(translatedText);
    }
}

