/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import java.math.BigDecimal;
import java.math.RoundingMode;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Round
implements CalcItem {
    int decimalPlaces = 0;
    RoundingMode roundingMode = RoundingMode.HALF_UP;

    public Round(int decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public Round(int decimalPlaces, RoundingMode roundingMode) {
        this.decimalPlaces = decimalPlaces;
        this.roundingMode = roundingMode;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 1) {
            throw new IllegalArgumentException("Round needs 1 element on stack");
        }
        Object value = stack.pop();
        if (value == null) {
            stack.push(null);
            return;
        }
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Argument of Round must be of type Number");
        }
        if (value instanceof Double || value instanceof Float) {
            if (this.decimalPlaces > 0) {
                double factor = Math.pow(10.0, this.decimalPlaces);
                long l = Math.round(((Number)value).doubleValue() * factor);
                value = (double)l / factor;
            } else {
                value = Math.round(((Number)value).doubleValue());
            }
        }
        if (value instanceof BigDecimal) {
            value = ((BigDecimal)value).setScale(this.decimalPlaces, this.roundingMode);
        }
        stack.push(value);
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Round result;
            int digits = 0;
            if (element.getAttributeValue("decimalPlaces") != null) {
                digits = Integer.parseInt(element.getAttributeValue("decimalPlaces"));
            }
            if (element.getAttributeValue("roundingMode") != null) {
                RoundingMode roundingMode = this.getRoundingMode(element.getAttributeValue("roundingMode"));
                result = new Round(digits, roundingMode);
            } else {
                result = new Round(digits);
            }
            return new ClassObjectPair(Round.class, (Object)result);
        }

        private RoundingMode getRoundingMode(String roundingMode) {
            switch (roundingMode) {
                case "DOWN": {
                    return RoundingMode.DOWN;
                }
                case "UP": {
                    return RoundingMode.UP;
                }
            }
            return RoundingMode.HALF_UP;
        }
    }
}

