/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.LogicModelItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class Modulo
implements CalcItem {
    @Override
    public void evaluate(@NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("Modulo needs 2 elements on stack");
        }
        Object value1 = stack.pop();
        Object value2 = stack.pop();
        if (value1 == null && value2 == null) {
            stack.push(null);
            return;
        }
        if (value1 == null || value1.toString().isEmpty()) {
            stack.push(null);
            return;
        }
        if (value1 instanceof Number && ((Number)value1).doubleValue() == 0.0) {
            stack.push(null);
            return;
        }
        if (value2 == null || value2.toString().isEmpty()) {
            value2 = 0L;
        }
        if (value1 instanceof Long && value2 instanceof Long) {
            if ((Long)value2 % (Long)value1 == 0L) {
                long l = (Long)value2 % (Long)value1;
                stack.push(l);
            } else {
                double d = ((Number)value2).doubleValue() % ((Number)value1).doubleValue();
                stack.push(d);
            }
        } else if (value1 instanceof Number && value2 instanceof Number) {
            double d = ((Number)value2).doubleValue() % ((Number)value1).doubleValue();
            stack.push(d);
        } else {
            throw new IllegalArgumentException("Both arguments of Modulo need to be of the type Number");
        }
    }

    public static class XMLFactory
    implements ElementParser {
        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            Modulo result = new Modulo();
            return new ClassObjectPair(Modulo.class, (Object)result);
        }
    }
}

