/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.lib.resource.construct.xml.ClassObjectPair;
import ch.dvbern.lib.resource.construct.xml.Element;
import ch.dvbern.lib.resource.construct.xml.ElementParser;
import ch.dvbern.lib.resource.construct.xml.ElementParserException;
import ch.dvbern.lib.resource.construct.xml.ParserFactory;
import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import org.checkerframework.checker.nullness.qual.NonNull;

public class IsNullOrZero
implements CalcItem {
    private final boolean booleanExpression;

    public IsNullOrZero(boolean booleanExpression) {
        this.booleanExpression = booleanExpression;
    }

    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.isEmpty()) {
            throw new IllegalArgumentException("IsNullOrZero needs 1 element on stack");
        }
        Object value = stack.pop();
        boolean bCalculated = false;
        if (value == null) {
            bCalculated = true;
        } else if (value instanceof String && ((String)value).length() <= 0) {
            bCalculated = true;
        } else if (value instanceof Number && ((Number)value).doubleValue() == 0.0) {
            bCalculated = true;
        }
        if (this.booleanExpression == bCalculated) {
            stack.push(Boolean.TRUE);
        } else {
            stack.push(Boolean.FALSE);
        }
    }

    public static class XMLFactory
    implements ElementParser {
        private final boolean booleanExpression;

        public XMLFactory(boolean booleanExpression) {
            this.booleanExpression = booleanExpression;
        }

        public @NonNull ClassObjectPair parse(@NonNull Element element, @NonNull ParserFactory factory) throws ElementParserException {
            IsNullOrZero result = new IsNullOrZero(this.booleanExpression);
            return new ClassObjectPair(IsNullOrZero.class, (Object)result);
        }
    }
}

