/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine.calcitems;

import ch.dvbern.tax.common.engine.CalcItem;
import ch.dvbern.tax.common.engine.util.FastStack;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import java.util.Calendar;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CFAge
implements CalcItem {
    @Override
    public void evaluate( @NonNull LogicModelItem.ProtectedMap model, @NonNull FastStack stack, @NonNull String dataModelKey) {
        if (stack.size() < 2) {
            throw new IllegalArgumentException("CFAge needs 2 elements on stack");
        }
        Object oBirthdate = stack.pop();
        Object oOtherdate = stack.pop();
        if (oBirthdate == null || oOtherdate == null) {
            stack.push(null);
            return;
        }
        if (!(oBirthdate instanceof Date) || !(oOtherdate instanceof Date)) {
            throw new IllegalArgumentException("Both arguments of CFAge need to be of type java.util.Date");
        }
        Calendar birthdate = Calendar.getInstance(ApplicationConfig.TIMEZONE);
        birthdate.setTime((Date)oBirthdate);
        Calendar otherdate = Calendar.getInstance(ApplicationConfig.TIMEZONE);
        otherdate.setTime((Date)oOtherdate);
        int age = this.age(birthdate, otherdate);
        stack.push(age);
    }

    private int age(Calendar birthdate, Calendar otherdate) {
        int age = 0;
        if (otherdate.before(birthdate)) {
            return -1;
        }
        age = otherdate.get(1) - birthdate.get(1);
        int birthmonth = birthdate.get(2);
        int othermonth = otherdate.get(2);
        int birthday = birthdate.get(5);
        int otherday = otherdate.get(5);
        if (othermonth < birthmonth || othermonth == birthmonth && otherday < birthday) {
            --age;
        }
        return age;
    }
}

