/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.engine;

import ch.dvbern.tax.common.engine.InvalidModelException;
import ch.dvbern.tax.common.engine.LMK;
import ch.dvbern.tax.common.engine.ModelChangeListener;
import ch.dvbern.tax.common.engine.Validator;
import ch.dvbern.tax.common.engine.modelitems.Bool;
import ch.dvbern.tax.common.engine.modelitems.Module;
import ch.dvbern.tax.common.engine.modelitems.Select;
import ch.dvbern.tax.common.engine.modelitems.Table;
import ch.dvbern.tax.common.engine.modelitems.Text;
import ch.dvbern.tax.common.engine.modelitems.Value;
import ch.dvbern.tax.common.engine.persistence.PersistenceHint;
import ch.dvbern.tax.common.engine.persistence.SimpleValuePersistenceHint;
import ch.dvbern.tax.common.engine.util.EngineUtil;
import ch.dvbern.tax.common.integration.conf.ApplicationConfig;
import ch.dvbern.tax.common.transfer.dto.MessageItemDTO;
import ch.dvbern.tax.common.transfer.dto.ModelItemDTO;
import ch.dvbern.tax.common.transfer.dto.OptionItemsDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceReadDTO;
import ch.dvbern.tax.common.transfer.dto.PersistenceWriteDTO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LogicModelItem
implements ModelChangeListener {
    private static final Logger LOG = LoggerFactory.getLogger(LogicModelItem.class);
    private static final boolean USING_PKEY_FOR_PWRITES = ApplicationConfig.getInstance().isUsingPKeysForPWrites();
    private static final String TABLE_INDEX_PLACEHOLDER = ".#";
    private static final Pattern TABLE_SPLITTER = Pattern.compile(".#");
    private @NonNull String name;
    private @NonNull String nameWithTableIndexShapes = "VALID_AFTER_initializeLogicModel()";
    private final @Nullable List<LogicModelItem> children;
    private @Nullable LogicModelItem parent = null;
    private final @NonNull Set<ModelChangeListener> modelChangeListeners = new HashSet<ModelChangeListener>();
    private final @NonNull List<Validator> validators = new ArrayList<Validator>();
    private final @NonNull List<String> persistenceKeyTemplates;
    private @Nullable Module previousItem = null;
    private @Nullable Module nextItem = null;
    private final boolean readonly;
    private @NonNull ImportProfile importProfile;
    private final boolean readonlyIfTransparent;
    private final boolean inBarcode;
    private final PersistenceHint<?> persistenceHint;

    @Deprecated
    protected LogicModelItem(@NonNull String name, @Nullable List<LogicModelItem> children, @Nullable String persistenceKeyTemplate, boolean readonly, @Nullable String importProfile, boolean readonlyIfTransparent, boolean barcode) {
        this(name, children, persistenceKeyTemplate, readonly, importProfile, readonlyIfTransparent, barcode, new SimpleValuePersistenceHint());
    }

    protected LogicModelItem(@NonNull String name, @Nullable List<LogicModelItem> children, @Nullable String persistenceKeyTemplate, boolean readonly, @Nullable String importProfile, boolean readonlyIfTransparent, boolean barcode, @NonNull PersistenceHint<?> persistenceHint) {
        this.name = Objects.requireNonNull(name);
        this.children = children;
        if (children != null) {
            for (LogicModelItem lmi : children) {
                lmi.parent = this;
            }
        }
        this.persistenceKeyTemplates = new ArrayList<String>();
        if (persistenceKeyTemplate != null) {
            StringTokenizer tokenizer = new StringTokenizer(persistenceKeyTemplate, ",");
            while (tokenizer.hasMoreTokens()) {
                this.persistenceKeyTemplates.add(tokenizer.nextToken().trim());
            }
        }
        this.readonly = readonly;
        this.readonlyIfTransparent = readonlyIfTransparent;
        this.inBarcode = barcode;
        this.importProfile = ImportProfile.IMPORT_NO_CASE;
        if (importProfile != null) {
            if ((importProfile = importProfile.toLowerCase()).contains("emptycase")) {
                this.importProfile = ImportProfile.IMPORT_EMPTY_CASE_ONLY;
            } else if ("true".equals(importProfile)) {
                this.importProfile = ImportProfile.IMPORT_ALL_CASES;
            }
        }
        this.persistenceHint = Objects.requireNonNull(persistenceHint);
    }

    @Override
    public final @NonNull String getName() {
        return this.name;
    }

    public final @NonNull LMK getLMK() {
        return LMK.parse(this.name);
    }

    public final @NonNull String getNameWithTableIndexShapes() {
        return this.nameWithTableIndexShapes;
    }

    public final @Nullable LogicModelItem getParent() {
        return this.parent;
    }

    public final @Nullable List<LogicModelItem> getChildren() {
        return this.children;
    }

    public final @Nullable Module getPreviousItem() {
        return this.previousItem;
    }

    public final @Nullable Module getNextItem() {
        return this.nextItem;
    }

    public boolean isReadonly() {
        return this.readonly;
    }

    public boolean isReadonlyIfTransparent() {
        return this.readonlyIfTransparent;
    }

    public @NonNull PersistenceHint<?> getPersistenceHint() {
        return this.persistenceHint;
    }

    public final void addDataModelListener(@NonNull ModelChangeListener aListener) {
        this.modelChangeListeners.add(aListener);
    }

    public final void addValidator(@NonNull Validator validator) {
        this.validators.add(validator);
    }

    /*
     * WARNING - void declaration
     */
    public final @Nullable Module initializeLogicModel(@NonNull Map<String, LogicModelItem> logicModelItems, @NonNull List<PersistenceReadDTO> persistenceReadDTOs, @NonNull String itemPath, int tables, @Nullable Module previous, @Nullable Map<String, String> persistenceKeys) throws InvalidModelException {
        String completeNameWithoutShapes;
        void var11_13;
        String[] sArray;
        StringBuilder itemPathWithoutShapes = new StringBuilder();
        String[] stringArray = sArray = TABLE_SPLITTER.split(itemPath);
        int n = stringArray.length;
        boolean bl = false;
        while (var11_13 < n) {
            String element = stringArray[var11_13];
            itemPathWithoutShapes.append(element);
            ++var11_13;
        }
        if (this.name.isEmpty()) {
            throw new InvalidModelException("invalid model item name in " + String.valueOf(itemPathWithoutShapes));
        }
        this.nameWithTableIndexShapes = itemPath.isEmpty() ? this.name : itemPath + "." + this.name;
        String string = completeNameWithoutShapes = itemPathWithoutShapes.length() > 0 ? String.valueOf(itemPathWithoutShapes) + "." + this.name : this.name;
        if (this.name.indexOf(46) != -1) {
            throw new InvalidModelException("invalid character (.) in " + completeNameWithoutShapes);
        }
        if (this.name.indexOf(35) != -1) {
            throw new InvalidModelException("invalid character (#) in " + completeNameWithoutShapes);
        }
        if (this.name.charAt(0) >= '0' && this.name.charAt(0) <= '9') {
            throw new InvalidModelException("invalid name (initial digit) in " + completeNameWithoutShapes);
        }
        this.name = completeNameWithoutShapes;
        if (logicModelItems.containsKey(this.name)) {
            throw new InvalidModelException("duplicate logic model item: " + this.name);
        }
        logicModelItems.put(this.name, this);
        for (String string2 : this.persistenceKeyTemplates) {
            if (persistenceKeys != null) {
                if (persistenceKeys.containsKey(string2)) {
                    LOG.warn("warning: duplicate persistence keys in {} and {} ({})", new Object[]{this.name, persistenceKeys.get(string2), string2});
                } else {
                    persistenceKeys.put(string2, this.name);
                }
            }
            int sharpCount = 0;
            int p = string2.indexOf(35);
            while (p >= 0) {
                p = string2.indexOf(35, p + 1);
                ++sharpCount;
            }
            if (sharpCount != tables) {
                throw new InvalidModelException("invalid pKey (wrong # count) in " + completeNameWithoutShapes);
            }
            persistenceReadDTOs.add(new PersistenceReadDTO(this.nameWithTableIndexShapes, string2, this.importProfile));
        }
        if (this instanceof Module) {
            this.previousItem = previous;
            if (previous != null) {
                previous.nextItem = (Module)this;
            }
            previous = (Module)this;
        }
        if (this.children != null) {
            for (Object object : this.children) {
                int t = this instanceof TableItem ? tables + 1 : tables;
                String s = this.nameWithTableIndexShapes + (this instanceof TableItem ? TABLE_INDEX_PLACEHOLDER : "");
                LogicModelItem childItem = (LogicModelItem)object;
                if (childItem instanceof TableItem) {
                    childItem.initializeLogicModel(logicModelItems, persistenceReadDTOs, s, t, null, persistenceKeys);
                    continue;
                }
                previous = childItem.initializeLogicModel(logicModelItems, persistenceReadDTOs, s, t, previous, persistenceKeys);
            }
        }
        return previous;
    }

    public final void initializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
        if (this.children != null) {
            for (Object object : this.children) {
                ((LogicModelItem)object).initializeReferences(logicModel);
            }
        }
        for (Validator validator : this.validators) {
            validator.initializeReferences(logicModel, this);
        }
        this.additionalInitializeReferences(logicModel);
    }

    protected void additionalInitializeReferences(Map<String, LogicModelItem> logicModel) throws InvalidModelException {
    }

    @Override
    public void dataChanged(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        this.dataChangedWithConditionalActiveValidation(dataModel, dataModelKey, changedEventsOnlyOutsideOfThisTable, true);
    }

    protected void dataChangedWithConditionalActiveValidation(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable String changedEventsOnlyOutsideOfThisTable, boolean activeValidation) {
        String dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
        if (changedEventsOnlyOutsideOfThisTable != null && dmk.startsWith(changedEventsOnlyOutsideOfThisTable)) {
            return;
        }
        ModelItemDTO oldDTO = dataModel.get(dmk);
        ModelItemDTO dto = oldDTO;
        if (dto == null) {
            dto = new ModelItemDTO();
        }
        ModelItemDTO newDTO = this.validateItemValue(dataModel, dmk, dto);
        if (!activeValidation && !dto.valueIsEqual(newDTO)) {
            newDTO = newDTO.clone(dto.getValue());
        }
        dataModel.put(this, dmk, newDTO, this.persistenceKeyTemplates, oldDTO);
        this.updateItemStates(dataModel, dmk, newDTO.getState(), newDTO, oldDTO);
        if (!newDTO.valueIsEqual(oldDTO)) {
            this.fireDataChangedEvent(dataModel, dmk, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
        if (oldDTO == null || newDTO.getState() != oldDTO.getState()) {
            this.fireStateChangedEvent(dataModel, dmk, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
    }

    @Override
    public void stateChanged(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
    }

    public void setValue(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        this.setValueWithOptionalValidation(dataModel, dataModelKey, modelItemDTO, changedEventsOnlyOutsideOfThisTable, true, true);
    }

    protected void setValueWithOptionalValidation(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO, @Nullable String changedEventsOnlyOutsideOfThisTable, boolean validationRequired, boolean activeValidation) {
        this.updateTableIndices(dataModel, dataModelKey);
        ModelItemDTO oldDTO = dataModel.get(dataModelKey);
        if (this instanceof TableItem) {
            if (EngineUtil.endsWithTableIndex(dataModelKey)) {
                return;
            }
            if (oldDTO != null && oldDTO.getValue() instanceof Set && !((Set)oldDTO.getValue()).isEmpty()) {
                return;
            }
        }
        ModelItemDTO newDTO = modelItemDTO;
        if (validationRequired) {
            newDTO = this.validateItemValue(dataModel, dataModelKey, modelItemDTO);
            if (!activeValidation && !modelItemDTO.valueIsEqual(newDTO)) {
                newDTO = newDTO.clone(modelItemDTO.getValue());
            }
        }
        dataModel.put(this, dataModelKey, newDTO, this.persistenceKeyTemplates, oldDTO);
        this.updateItemStates(dataModel, dataModelKey, newDTO.getState(), newDTO, oldDTO);
        if (!newDTO.valueIsEqual(oldDTO)) {
            this.fireDataChangedEvent(dataModel, dataModelKey, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
        if (oldDTO == null || newDTO.getState() != oldDTO.getState()) {
            this.fireStateChangedEvent(dataModel, dataModelKey, oldDTO, newDTO, changedEventsOnlyOutsideOfThisTable);
        }
    }

    public boolean deleteValue(ProtectedMap dataModel, String dataModelKey) {
        boolean result = this.deleteSubValues(dataModel, dataModelKey, true, null);
        if (result) {
            int i;
            for (i = 0; this.deleteSubValues(dataModel, dataModelKey, true, null) && i < 10; ++i) {
            }
            if (i >= 10) {
                LOG.error("Loeschen abgebrochen. Stabilitaet wurde nach {} Versuchen nicht erreicht.", (Object)i);
            }
        }
        if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dataModelKey)) {
            String tableDMK = EngineUtil.removeLastKeyPart(dataModelKey);
            this.updateItemStates(dataModel, tableDMK, 1, null, null);
        } else if (this.parent != null) {
            String parentDMK = EngineUtil.mergeModelKey(this.parent.getName(), dataModelKey);
            this.parent.updateItemStates(dataModel, parentDMK, 1, null, null);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean deleteSubValues(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, boolean removeThisToo, @Nullable String dataChangedEventsOnlyOutsideOfThisTable) {
        ModelItemDTO tableEntry;
        boolean isWholeTableDMK;
        boolean result = false;
        boolean bl = isWholeTableDMK = this instanceof TableItem && !EngineUtil.endsWithTableIndex(dataModelKey);
        if (this.getChildren() != null && !isWholeTableDMK) {
            Iterator<LogicModelItem> iterator = this.getChildren().iterator();
            while (iterator.hasNext()) {
                LogicModelItem logicModelItem;
                LogicModelItem element = logicModelItem = iterator.next();
                String dceooott = dataChangedEventsOnlyOutsideOfThisTable;
                if (dceooott == null && this instanceof TableItem) {
                    dceooott = EngineUtil.mergeModelKey(this.getName(), dataModelKey);
                }
                String childDMK = EngineUtil.mergeModelKey(element.getName(), dataModelKey);
                result |= element.deleteSubValues(dataModel, childDMK, true, dceooott);
            }
        }
        if (isWholeTableDMK && (tableEntry = dataModel.get(dataModelKey)) != null && tableEntry.getValue() instanceof Set) {
            for (Object name2 : (Set)tableEntry.getValue()) {
                String index = name2.toString();
                result |= this.deleteSubValues(dataModel, dataModelKey + "." + index, true, null);
            }
        }
        this.findContainingTable().ifPresent(parent -> {
            ModelItemDTO oldDTO = dataModel.get(dataModelKey);
            String tableDMK = parent.getName();
            Collection<TableItem.TableEventListener> tableEventListeners = parent.getTableEventListeners();
            if (tableEventListeners != null) {
                tableEventListeners.forEach(listener -> listener.onTableValueRemove(this, dataModel, oldDTO, tableDMK));
            }
        });
        if (removeThisToo) {
            String index;
            HashSet newValue;
            String string;
            ModelItemDTO tableDTO;
            ModelItemDTO oldDTO = dataModel.remove(this, dataModelKey, this.persistenceKeyTemplates);
            if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dataModelKey) && (tableDTO = dataModel.get(string = EngineUtil.removeLastKeyPart(dataModelKey))) != null && tableDTO.getValue() != null && (newValue = new HashSet((Set)tableDTO.getValue())).remove(index = EngineUtil.getLastKeyPart(dataModelKey))) {
                dataModel.put(this, string, tableDTO.clone(newValue), this.persistenceKeyTemplates, tableDTO);
                Collection<TableItem.TableEventListener> tableEventListeners = ((TableItem)((Object)this)).getTableEventListeners();
                if (tableEventListeners != null) {
                    for (TableItem.TableEventListener listener : tableEventListeners) {
                        listener.onTableEntryRemove(this, dataModel, string, index);
                    }
                }
            }
            if (oldDTO != null) {
                boolean dtoValueHasChanged;
                void var8_15;
                String s;
                String string2 = dataChangedEventsOnlyOutsideOfThisTable;
                if (string2 == null && this instanceof TableItem && EngineUtil.endsWithTableIndex(s = EngineUtil.mergeModelKey(this.getName(), dataModelKey))) {
                    String string3 = s;
                }
                this.fireDataChangedEvent(dataModel, dataModelKey, oldDTO, null, (String)var8_15);
                this.fireStateChangedEvent(dataModel, dataModelKey, oldDTO, null, (String)var8_15);
                boolean moduleOrTable = this instanceof Module || this instanceof TableItem;
                boolean bl2 = dtoValueHasChanged = oldDTO.isTouched() || oldDTO.getValue() != null;
                if (ApplicationConfig.getInstance().hideDeleteWarnigsOfUntouchedValues()) {
                    dtoValueHasChanged = oldDTO.isTouched() && oldDTO.getValue() != null;
                }
                result |= !this.readonly && !moduleOrTable && dtoValueHasChanged;
            }
        }
        return result;
    }

    protected boolean hasAnInitialGreenState() {
        return this instanceof Module || this.isReadonly();
    }

    protected @Nullable ModelItemDTO getDefaultValue(ProtectedMap dataModel, String dataModelKey) {
        return null;
    }

    protected final void initializeDefaultValues(ProtectedMap dataModel, String dataModelKey) {
        String dmk;
        ModelItemDTO oldDTO;
        ModelItemDTO defaultValue = this.getDefaultValue(dataModel, dataModelKey);
        if (defaultValue != null && ((oldDTO = dataModel.get(dmk = EngineUtil.mergeModelKey(this.getName(), dataModelKey))) == null || oldDTO.getValue() == null && (!oldDTO.isTouched() || this.isReadonly()))) {
            ModelItemDTO newDTO = this.validateItemValue(dataModel, dmk, defaultValue);
            dataModel.put(this, dmk, newDTO, this.persistenceKeyTemplates, oldDTO);
            this.updateItemStates(dataModel, dmk, newDTO.getState(), newDTO, null);
            this.fireDataChangedEvent(dataModel, dmk, oldDTO, newDTO, null);
            this.fireStateChangedEvent(dataModel, dmk, oldDTO, newDTO, null);
        }
        if (this.children != null) {
            for (LogicModelItem object : this.children) {
                LogicModelItem lmi = object;
                if (lmi instanceof TableItem) {
                    String dmk2 = EngineUtil.mergeModelKey(lmi.getName(), dataModelKey);
                    ModelItemDTO tableDTO = dataModel.get(dmk2);
                    if (tableDTO == null || !(tableDTO.getValue() instanceof Set)) continue;
                    for (Object name2 : (Set)tableDTO.getValue()) {
                        lmi.initializeDefaultValues(dataModel, dmk2 + "." + name2.toString());
                    }
                    continue;
                }
                lmi.initializeDefaultValues(dataModel, dataModelKey);
            }
        }
    }

    public final @NonNull List<Validator> getValidators() {
        return this.validators;
    }

    private ModelItemDTO validateItemValue(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @NonNull ModelItemDTO modelItemDTO) {
        Collection<MessageItemDTO> messages;
        int resultState;
        int initialState;
        int n = initialState = this.hasAnInitialGreenState() || modelItemDTO.isTouched() ? 1 : 3;
        if (initialState != 1 && EngineUtil.endsWithTableIndex(dataModelKey)) {
            initialState = 1;
        }
        ModelItemDTO result = modelItemDTO.clone(initialState, null);
        for (Validator v : this.validators) {
            ModelItemDTO newResult = v.validate(dataModel, dataModelKey, result);
            if (newResult == null) {
                LOG.warn("Validator {} returned a null value!", (Object)v.getClass().getName());
                continue;
            }
            result = result.hasMoreImportantState(newResult.getState()) ? newResult.clone(result.getState()) : newResult;
        }
        if (!(dataModel.allowActiveValidations() || this.isReadonly() || result.valueIsEqual(modelItemDTO))) {
            result = result.clone(modelItemDTO.getValue());
        }
        if (!((resultState = result.getState()) != 11 && resultState != 12 || (messages = result.getMessages()) == null || messages.isEmpty())) {
            messages.clear();
        }
        return result;
    }

    protected final void fireDataChangedEvent(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        try {
            for (ModelChangeListener l : this.modelChangeListeners) {
                l.dataChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
            }
        }
        catch (StackOverflowError soe) {
            String error = "stack overflow error in method fireDataChangedEvent of " + this.name + "; ";
            LOG.error(error);
            throw new RuntimeException(error, soe);
        }
    }

    private void fireStateChangedEvent(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, @Nullable ModelItemDTO oldValue, @Nullable ModelItemDTO newValue, @Nullable String changedEventsOnlyOutsideOfThisTable) {
        try {
            for (ModelChangeListener l : this.modelChangeListeners) {
                l.stateChanged(dataModel, dataModelKey, oldValue, newValue, changedEventsOnlyOutsideOfThisTable);
            }
        }
        catch (StackOverflowError soe) {
            String error = "stack overflow error in method fireDataChangedEvent of " + this.name + "; ";
            throw new RuntimeException(error, soe);
        }
    }

    private void updateTableIndices(ProtectedMap dataModel, String dataModelKey) {
        String dmk = dataModelKey;
        if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dmk = EngineUtil.mergeModelKey(this.name, dataModelKey))) {
            ModelItemDTO dto;
            String index = EngineUtil.getLastKeyPart(dmk);
            String s = EngineUtil.removeLastKeyPart(dmk);
            ModelItemDTO oldDTO = dataModel.get(s);
            if (oldDTO == null || oldDTO.getValue() == null) {
                dto = new ModelItemDTO();
                dto = dto.clone(new HashSet());
            } else {
                if (((Set)oldDTO.getValue()).contains(index)) {
                    return;
                }
                dto = oldDTO.clone(new HashSet((Set)oldDTO.getValue()));
            }
            Set indexes = (Set)dto.getValue();
            assert (indexes != null) : "DTO does not have set value: " + dataModelKey + " = + " + String.valueOf(dto);
            indexes.add(index);
            dto.setTouched();
            dataModel.put(this, s, dto, this.persistenceKeyTemplates, oldDTO);
            dataModel.getTableUpdates().put(s, dto);
            this.initializeDefaultValues(dataModel, dmk);
            Collection<TableItem.TableEventListener> tableEventListeners = ((TableItem)((Object)this)).getTableEventListeners();
            if (tableEventListeners != null) {
                for (TableItem.TableEventListener listener : tableEventListeners) {
                    listener.onTableEntryAdd(this, dataModel, s, index);
                }
            }
        }
        if (this.parent != null) {
            this.parent.updateTableIndices(dataModel, dmk);
        }
    }

    private void updateItemStates(@NonNull ProtectedMap dataModel, @NonNull String dataModelKey, int newState, @Nullable ModelItemDTO storedDTO, @Nullable ModelItemDTO oldStateDTO) {
        String parentDataModelKey;
        ModelItemDTO newDTO;
        boolean propagatedFromSubhierarchy;
        boolean bl = propagatedFromSubhierarchy = storedDTO == null && oldStateDTO == null;
        if (propagatedFromSubhierarchy) {
            storedDTO = oldStateDTO = dataModel.get(dataModelKey);
        }
        if (oldStateDTO != null && oldStateDTO.getState() == newState) {
            return;
        }
        if (propagatedFromSubhierarchy && oldStateDTO != null && !oldStateDTO.hasPropagatableState()) {
            return;
        }
        if (oldStateDTO == null || oldStateDTO.hasMoreImportantState(newState)) {
            if (this instanceof TableItem && !EngineUtil.endsWithTableIndex(dataModelKey)) {
                if (storedDTO != null && storedDTO.getValue() instanceof Set) {
                    for (LogicModelItem name2 : (Set)storedDTO.getValue()) {
                        ModelItemDTO subDTO = dataModel.get(dataModelKey + "." + String.valueOf(name2));
                        if (subDTO == null || !subDTO.hasMoreImportantState(newState) || !subDTO.hasPropagatableState()) continue;
                        newState = subDTO.getState();
                    }
                }
            } else if (this.children != null) {
                for (LogicModelItem lmi : this.children) {
                    if (!lmi.isImportantState()) continue;
                    String s = EngineUtil.mergeModelKey(lmi.getName(), dataModelKey);
                    ModelItemDTO subDTO = dataModel.get(s);
                    if (subDTO == null && !lmi.isReadonly() && ModelItemDTO.isMoreImportantState(3, newState)) {
                        newState = 3;
                    }
                    if (subDTO == null || !subDTO.hasMoreImportantState(newState) || !subDTO.hasPropagatableState()) continue;
                    newState = subDTO.getState();
                }
            }
        }
        ModelItemDTO modelItemDTO = newDTO = storedDTO != null ? storedDTO : new ModelItemDTO();
        if (newState != newDTO.getState()) {
            newDTO = newDTO.clone(newState);
            dataModel.put(this, dataModelKey, newDTO, this.persistenceKeyTemplates, storedDTO);
            this.fireStateChangedEvent(dataModel, dataModelKey, storedDTO, newDTO, null);
        }
        if (!newDTO.hasPropagatableState()) {
            newState = 1;
        }
        if (this instanceof TableItem && EngineUtil.endsWithTableIndex(dataModelKey)) {
            parentDataModelKey = EngineUtil.removeLastKeyPart(dataModelKey);
            this.updateItemStates(dataModel, parentDataModelKey, newState, null, null);
        } else if (this.parent != null) {
            parentDataModelKey = EngineUtil.mergeModelKey(this.parent.getName(), dataModelKey);
            this.parent.updateItemStates(dataModel, parentDataModelKey, newState, null, null);
        }
    }

    public @NonNull List<String> getPersistenceKeyTemplates() {
        return this.persistenceKeyTemplates;
    }

    protected boolean isImportantState() {
        return true;
    }

    public boolean isInBarcode() {
        return this.inBarcode;
    }

    @NonNull List<String> getListenersNames() {
        if (this.modelChangeListeners.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> listenersNames = new ArrayList<String>(this.modelChangeListeners.size());
        for (ModelChangeListener listener : this.modelChangeListeners) {
            listenersNames.add(listener.getName());
        }
        return listenersNames;
    }

    @NonNull ImportProfile getImportProfile() {
        return this.importProfile;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("name", (Object)this.name).build();
    }

    public @Nullable Table findOutermostTableLmi() {
        LinkedList<LogicModelItem> hierarchy = new LinkedList<LogicModelItem>();
        for (LogicModelItem lmiHierarchy = this; lmiHierarchy != null; lmiHierarchy = lmiHierarchy.getParent()) {
            hierarchy.add(lmiHierarchy);
        }
        Collections.reverse(hierarchy);
        Table tableLmi = null;
        for (LogicModelItem entry : hierarchy) {
            if (!(entry instanceof Table)) continue;
            tableLmi = (Table)entry;
            break;
        }
        return tableLmi;
    }

    public @NonNull Optional<Table> findContainingTable() {
        LogicModelItem current = this;
        do {
            if (!((current = current.getParent()) instanceof Table)) continue;
            return Optional.of((Table)current);
        } while (current != null);
        return Optional.empty();
    }

    public static class ProtectedMap
    implements Map<String, ModelItemDTO> {
        protected final @NonNull Map<String, ModelItemDTO> nestedMap;
        protected final @NonNull Map<String, List<PersistenceWriteDTO>> changedMap;
        private final @NonNull Map<String, Object> clipboard;
        private final @NonNull Map<String, ModelItemDTO> undoInfoMap;
        private final @NonNull Set<MessageItemDTO> deleteWarnings = new HashSet<MessageItemDTO>();
        private final boolean allowActiveValidations;
        private final @NonNull Map<String, ModelItemDTO> tableUpdates;
        private final @NonNull Set<String> recursions;
        private final @NonNull Map<String, ModelItemDTO> asyncUpdates;
        private final @NonNull Map<String, Object> sessionAttributes;
        private boolean recalculating = false;

        public ProtectedMap(@NonNull Map<String, ModelItemDTO> nestedMap, boolean allowActiveValidations) {
            this.allowActiveValidations = allowActiveValidations;
            this.nestedMap = Objects.requireNonNull(nestedMap);
            this.changedMap = new HashMap<String, List<PersistenceWriteDTO>>();
            this.clipboard = new HashMap<String, Object>();
            this.undoInfoMap = new HashMap<String, ModelItemDTO>();
            this.tableUpdates = new HashMap<String, ModelItemDTO>();
            this.recursions = new HashSet<String>();
            this.asyncUpdates = new LinkedHashMap<String, ModelItemDTO>();
            this.sessionAttributes = new HashMap<String, Object>();
        }

        public ProtectedMap(@NonNull ProtectedMap protectedMap) {
            assert (protectedMap != null);
            this.allowActiveValidations = false;
            this.nestedMap = protectedMap.nestedMap;
            this.changedMap = protectedMap.changedMap;
            this.clipboard = new HashMap<String, Object>();
            this.undoInfoMap = protectedMap.undoInfoMap;
            this.tableUpdates = new HashMap<String, ModelItemDTO>();
            this.recursions = new HashSet<String>();
            this.asyncUpdates = new LinkedHashMap<String, ModelItemDTO>();
            this.sessionAttributes = new HashMap<String, Object>();
            this.recalculating = false;
        }

        @Override
        public ModelItemDTO get(Object key) {
            return this.nestedMap.get(key);
        }

        public @NonNull Map<String, List<PersistenceWriteDTO>> getChangedMap() {
            return this.changedMap;
        }

        public @NonNull Map<String, Object> getClipboard() {
            return this.clipboard;
        }

        public @NonNull Map<String, ModelItemDTO> getUndoInfoMap() {
            return this.undoInfoMap;
        }

        public @NonNull Map<String, ModelItemDTO> getTableUpdates() {
            return this.tableUpdates;
        }

        public @NonNull Collection<MessageItemDTO> getDeleteWarnings() {
            return this.deleteWarnings;
        }

        public void addDeleteWarning(@NonNull MessageItemDTO messageItemDTO) {
            this.deleteWarnings.add(messageItemDTO);
        }

        public boolean allowActiveValidations() {
            return this.allowActiveValidations;
        }

        @Override
        public @NonNull Set<Map.Entry<String, ModelItemDTO>> entrySet() {
            return Collections.unmodifiableSet(this.nestedMap.entrySet());
        }

        @Override
        public @NonNull Set<String> keySet() {
            return Collections.unmodifiableSet(this.nestedMap.keySet());
        }

        public Set<String> getRunningLoops() {
            return this.recursions;
        }

        public @NonNull Map<String, ModelItemDTO> getAsyncUpdates() {
            return this.asyncUpdates;
        }

        public @NonNull Map<String, Object> getSessionAttributes() {
            return this.sessionAttributes;
        }

        public void setRecalculating(boolean recalculating) {
            this.recalculating = recalculating;
        }

        public boolean isRecalculating() {
            return this.recalculating;
        }

        protected @Nullable ModelItemDTO put(@NonNull LogicModelItem lmi, @NonNull String dataModelKey, @NonNull ModelItemDTO value, @NonNull List<String> persistenceKeyTemplates, @Nullable ModelItemDTO oldValue) {
            if (value.equals(oldValue)) {
                return oldValue;
            }
            if (lmi.isReadonly() || lmi.isReadonlyIfTransparent() && value.getState() == 11 || value.isTouched() || this.recalculating) {
                List<Object> dtos = null;
                if (USING_PKEY_FOR_PWRITES) {
                    if (!persistenceKeyTemplates.isEmpty()) {
                        dtos = new ArrayList(persistenceKeyTemplates.size());
                        for (String persistenceKeyTemplate : persistenceKeyTemplates) {
                            String persistenceKey = EngineUtil.convertPersistenceKey(persistenceKeyTemplate, dataModelKey);
                            PersistenceWriteDTO dto = new PersistenceWriteDTO(persistenceKey, value, lmi.getPersistenceHint());
                            dtos.add(dto);
                        }
                    }
                } else if (!lmi.isReadonly() && (lmi instanceof Value || lmi instanceof Text || lmi instanceof Bool || lmi instanceof Select)) {
                    dtos = Collections.singletonList(new PersistenceWriteDTO(null, value, lmi.getPersistenceHint()));
                }
                if (dtos != null) {
                    this.changedMap.put(dataModelKey, dtos);
                }
            }
            if (!this.undoInfoMap.containsKey(dataModelKey)) {
                this.undoInfoMap.put(dataModelKey, oldValue);
            }
            return this.nestedMap.put(dataModelKey, value);
        }

        protected @Nullable ModelItemDTO remove(@NonNull LogicModelItem lmi, @NonNull String dataModelKey, @NonNull List<String> persistenceKeyTemplates) {
            ModelItemDTO oldDTO = this.nestedMap.remove(dataModelKey);
            if (oldDTO != null) {
                if (!EngineUtil.endsWithTableIndex(dataModelKey)) {
                    List<Object> dtos = null;
                    if (USING_PKEY_FOR_PWRITES) {
                        if (!persistenceKeyTemplates.isEmpty()) {
                            dtos = new ArrayList(persistenceKeyTemplates.size());
                            for (String persistenceKeyTemplate : persistenceKeyTemplates) {
                                String persistenceKey = EngineUtil.convertPersistenceKey(persistenceKeyTemplate, dataModelKey);
                                PersistenceWriteDTO dto = new PersistenceWriteDTO(persistenceKey, null, lmi.getPersistenceHint());
                                dtos.add(dto);
                            }
                        }
                    } else {
                        dtos = Collections.singletonList(new PersistenceWriteDTO(null, null, lmi.getPersistenceHint()));
                    }
                    if (dtos != null) {
                        this.changedMap.put(dataModelKey, dtos);
                    }
                }
                if (!this.undoInfoMap.containsKey(dataModelKey)) {
                    this.undoInfoMap.put(dataModelKey, oldDTO);
                }
            }
            return oldDTO;
        }

        @Override
        public int size() {
            return this.nestedMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.nestedMap.isEmpty();
        }

        @Override
        public boolean containsKey(@NonNull Object key) {
            return this.nestedMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.nestedMap.containsValue(value);
        }

        @Override
        public ModelItemDTO put(@NonNull String key, @Nullable ModelItemDTO value) {
            throw new UnsupportedOperationException("ProtectedMaps are read-only.");
        }

        @Override
        public ModelItemDTO remove(@NonNull Object key) {
            throw new UnsupportedOperationException("ProtectedMaps are read-only.");
        }

        @Override
        public void putAll(@NonNull Map<? extends String, ? extends ModelItemDTO> m) {
            throw new UnsupportedOperationException("ProtectedMaps are read-only.");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("ProtectedMaps are read-only.");
        }

        @Override
        public @NonNull Collection<ModelItemDTO> values() {
            return Collections.unmodifiableCollection(this.nestedMap.values());
        }
    }

    public static interface PreselectionItem {
        public boolean isPreselectionItem();
    }

    public static interface SelectItem {
        public OptionItemsDTO getOptionItems(ProtectedMap var1, String var2);

        public boolean hasTableOption();
    }

    public static interface TableItem {
        public void addSharedTable(TableItem var1);

        public Collection<TableItem> getSharedTables();

        public void addTableEventListener(TableEventListener var1);

        public Collection<TableEventListener> getTableEventListeners();

        public static interface TableEventListener {
            public void onTableEntryAdd(LogicModelItem var1, ProtectedMap var2, String var3, String var4);

            public void onTableEntryRemove(LogicModelItem var1, ProtectedMap var2, String var3, String var4);

            public void onTableValueRemove(LogicModelItem var1, ProtectedMap var2, ModelItemDTO var3, String var4);
        }
    }

    public static enum ProcessingHint {
        SIMPLE_VALUE,
        FILE,
        CUSTOM;

    }

    public static enum ImportProfile {
        IMPORT_NO_CASE,
        IMPORT_EMPTY_CASE_ONLY,
        IMPORT_ALL_CASES;

    }
}

