/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.ejb.util;

import ch.dvbern.tax.common.ejb.util.AbstractEJBBeanInjector;
import ch.dvbern.tax.common.ejb.util.DVEJB;
import ch.dvbern.tax.common.ejb.util.JNDIBindingUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiEJBBeanInjector
extends AbstractEJBBeanInjector {
    private static final Logger LOG = LoggerFactory.getLogger(JndiEJBBeanInjector.class);

    @Override
    public void instrumentField(Object o, Field field) throws NamingException, IllegalAccessException {
        if (o == null) {
            throw new NullPointerException("Target instance 'o' cannot be null.");
        }
        if (field == null) {
            throw new NullPointerException("Target field cannot be null.");
        }
        DVEJB annotation = field.getAnnotation(DVEJB.class);
        Class<?> fieldClass = null;
        fieldClass = annotation != null && annotation.beanInterface() != null && !Object.class.equals(annotation.beanInterface()) ? annotation.beanInterface() : field.getType();
        field.setAccessible(true);
        if (field.get(o) != null) {
            return;
        }
        InitialContext ctx = new InitialContext();
        String name = JNDIBindingUtil.getBindingName(ctx, fieldClass);
        LOG.debug("Perform injection with resolved JNDI binding " + name);
        Object toInject = ctx.lookup(name);
        if (toInject == null) {
            throw new NamingException("JNDI name bound to null value: " + name);
        }
        try {
            field.set(o, toInject);
        }
        catch (IllegalArgumentException e) {
            StringBuilder sb = new StringBuilder("Cannot inject object ").append(toInject).append(" (");
            if (toInject instanceof Proxy) {
                sb.append("proxy of: ");
                for (Object implInterface : ClassUtils.getAllInterfaces(toInject.getClass())) {
                    sb.append(((Class)implInterface).getCanonicalName()).append(" ");
                }
            } else {
                sb.append(toInject.getClass().getCanonicalName());
            }
            sb.append(") to field ").append(fieldClass.getCanonicalName()).append('.').append(field.getName());
            sb.append(" (").append(field.getType().getCanonicalName()).append(")");
            throw new IllegalArgumentException(sb.toString(), e);
        }
    }
}

