/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.ejb.util;

import ch.dvbern.tax.common.integration.conf.AbstractOnlineApplicationConfig;
import ch.dvbern.tax.common.transfer.failure.ApplicationException;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JNDIBindingUtil {
    private static final String JBOSS_SFSB_FACTORY_NAME = "org.jboss.ejb3.stateful.StatefulLocalProxyFactory";
    private static Map<String, String> bindingNames = Collections.synchronizedMap(new HashMap());
    private static final Logger LOG = LoggerFactory.getLogger(JNDIBindingUtil.class);

    private JNDIBindingUtil() {
    }

    public static @NonNull String getBindingName(@NonNull Context context, @NonNull Class<?> serviceClass) {
        String bindingName = bindingNames.get(serviceClass.getName());
        if (bindingName == null) {
            try {
                NamingException ne;
                block11: {
                    String earName = AbstractOnlineApplicationConfig.getInstance().getEarName();
                    ne = null;
                    if (earName != null) {
                        try {
                            bindingName = JNDIBindingUtil.getBindingName(context, "java:global/" + earName, serviceClass);
                        }
                        catch (NamingException e) {
                            ne = e;
                        }
                    }
                    if (bindingName == null) {
                        try {
                            bindingName = JNDIBindingUtil.getBindingName(context, earName, serviceClass);
                        }
                        catch (NamingException e) {
                            if (ne != null) break block11;
                            ne = e;
                        }
                    }
                }
                if (bindingName == null) {
                    if (ne != null) {
                        throw ne;
                    }
                    throw new NamingException("No object bound for class " + serviceClass.getName());
                }
            }
            catch (Exception e) {
                throw new ApplicationException(e);
            }
            bindingNames.put(serviceClass.getName(), bindingName);
        }
        return bindingName;
    }

    private static @Nullable String getBindingName(@NonNull Context ctx, @NonNull String path, @NonNull Class<?> fieldClass) throws NamingException {
        StringBuilder sb = new StringBuilder(path);
        NamingEnumeration<Binding> bindings = ctx.listBindings(sb.toString());
        while (bindings.hasMore()) {
            Binding binding = bindings.next();
            String n = path + "/" + binding.getName();
            Object boundObject = binding.getObject();
            if (fieldClass.isInstance(boundObject)) {
                return n;
            }
            if (JBOSS_SFSB_FACTORY_NAME.equals(boundObject.getClass().getName())) {
                try {
                    Object sfsbName = JNDIBindingUtil.getField(JNDIBindingUtil.getField(boundObject, "container"), "beanClassName");
                    if (!fieldClass.isAssignableFrom(Class.forName(sfsbName.toString()))) continue;
                    return JNDIBindingUtil.getField(boundObject, "jndiName").toString();
                }
                catch (Exception t) {
                    LOG.warn("error binding JBoss SFSB", (Throwable)t);
                    continue;
                }
            }
            if (boundObject instanceof Context) {
                try {
                    String p = JNDIBindingUtil.getBindingName(ctx, n, fieldClass);
                    if (p == null) continue;
                    return p;
                }
                catch (NamingException namingException) {
                    continue;
                }
            }
            if (!binding.getName().equals("local-" + fieldClass.getName())) continue;
            return n;
        }
        return null;
    }

    private static @Nullable Object getField(@NonNull Object o, @NonNull String name) throws IllegalAccessException, NoSuchFieldException {
        return JNDIBindingUtil.getField(o, o.getClass(), name);
    }

    private static @Nullable Object getField(@NonNull Object o, @NonNull Class<?> c, @NonNull String name) throws IllegalAccessException, NoSuchFieldException {
        try {
            Field f = c.getDeclaredField(name);
            f.setAccessible(true);
            return f.get(o);
        }
        catch (NoSuchFieldException nsfe) {
            if (!c.equals(Object.class)) {
                return JNDIBindingUtil.getField(o, c.getSuperclass(), name);
            }
            throw nsfe;
        }
    }
}

