/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.widgets;

import ch.dvbern.tax.common.presentation.cd.Messages;
import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.items.ILabelItem;
import ch.dvbern.tax.common.presentation.cd.items.expert.ELabelItem;
import ch.dvbern.tax.common.presentation.cd.resourcetools.TranslationManager;
import ch.dvbern.tax.common.presentation.cd.widgets.LabelStyledText;
import ch.dvbern.tax.common.presentation.cd.widgets.TaxmeComposite;
import ch.dvbern.tax.common.presentation.cd.widgets.WidgetsUtil;
import ch.dvbern.tax.common.transfer.dto.ExpertDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.WizardDisplayInfoDTO;
import ch.dvbern.tax.common.transfer.dto.convert.AbstractConverter;
import ch.dvbern.tax.common.transfer.util.WizardLabelAddOnHelper;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class BorderedLabelStyledText
extends TaxmeComposite {
    private static boolean toolsEnabled = TaxmeConfig.getBoolean("ToolsEnabled");
    private final int style;
    private Control label = null;
    private int alignment = -1;
    private Font font;
    private Color background;

    public BorderedLabelStyledText(Composite parent, int marginWidth, int marginHeight, int horizontalSpan, Integer size, int style) {
        super(parent, 0);
        this.style = style;
        GridLayout gl = new GridLayout();
        gl.marginWidth = marginWidth;
        gl.marginHeight = marginHeight;
        super.setLayout((Layout)gl);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = false;
        gd.horizontalSpan = horizontalSpan;
        if (size == null) {
            gd.grabExcessHorizontalSpace = true;
        } else {
            gd.grabExcessHorizontalSpace = false;
            gd.widthHint = size;
            super.setSize(size.intValue(), 0);
        }
        super.setLayoutData((Object)gd);
    }

    public BorderedLabelStyledText(Composite parent, int style) {
        this(parent, 0, 0, 0, null, style);
    }

    public void setText(ILabelItem labelDTO) {
        ILabelItem oldLabel;
        ILabelItem iLabelItem = oldLabel = this.label == null ? null : (ILabelItem)this.label.getData();
        if (oldLabel == null || !oldLabel.getDigest().equals(labelDTO.getDigest())) {
            this.setText(labelDTO.getText());
            this.label.setData((Object)labelDTO);
        }
    }

    public void setText(ExpertDisplayInfoDTO.LabelDTO labelDTO) {
        ExpertDisplayInfoDTO.LabelDTO oldLabel;
        ExpertDisplayInfoDTO.LabelDTO labelDTO2 = oldLabel = this.label == null ? null : (ExpertDisplayInfoDTO.LabelDTO)this.label.getData();
        if (oldLabel == null || !oldLabel.toString().equals(labelDTO.toString())) {
            TaxmeController ctrl = TaxmeController.getInstance();
            AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), null);
            this.setText(labelDTO.getText(ctx));
            this.label.setData((Object)labelDTO);
        }
    }

    public void setText(WizardDisplayInfoDTO.LabelItemDTO labelDTO) {
        WizardDisplayInfoDTO.LabelItemDTO oldLabel;
        WizardDisplayInfoDTO.LabelItemDTO labelItemDTO = oldLabel = this.label == null ? null : (WizardDisplayInfoDTO.LabelItemDTO)this.label.getData();
        if (oldLabel == null || !oldLabel.toString().equals(labelDTO.toString())) {
            String key = labelDTO.getName().toString();
            TaxmeController ctrl = TaxmeController.getInstance();
            AbstractConverter.ConverterContext ctx = new AbstractConverter.ConverterContext(ctrl.getLocalizationHelper(), ctrl.getTmoCdSession().getDataModel(), null);
            Object[] args = WizardLabelAddOnHelper.getReplacements((List)labelDTO.getLabelAddOns(), (AbstractConverter.ConverterContext)ctx);
            this.setText(Messages.configurableTranslate(key, args));
            this.label.setData((Object)labelDTO);
            if (toolsEnabled) {
                if (this.label instanceof LabelStyledText) {
                    TranslationManager.getInstance().registerControl((Control)this, key);
                } else {
                    TranslationManager.getInstance().registerControl(this.label, key);
                }
            }
        }
    }

    private void setText(String text) {
        boolean hasHtml;
        boolean bl = hasHtml = (text = BorderedLabelStyledText.replaceHtml(text)).indexOf(60) >= 0;
        if (this.label == null) {
            this.label = hasHtml ? new LabelStyledText(this, this.style) : new Label((Composite)this, this.style);
            this.label.setLayoutData((Object)new GridData(768));
            if (this.font != null) {
                this.setFont(this.font);
            }
            if (this.background != null) {
                this.setBackground(this.background);
            }
            if (this.alignment >= 0) {
                this.setAlignment(this.alignment);
            }
        } else if (hasHtml && this.label instanceof Label) {
            Object layoutData = this.label.getLayoutData();
            this.label.dispose();
            this.label = new LabelStyledText(this, this.style);
            this.label.setLayoutData(layoutData);
        }
        if (this.label instanceof Label) {
            ((Label)this.label).setText(text);
        } else {
            ((LabelStyledText)this.label).setText(text);
        }
    }

    @Override
    public void setFont(Font font) {
        if (this.label == null) {
            this.font = font;
        } else if (!WidgetsUtil.equals(this.label.getFont(), font)) {
            this.label.setFont(font);
        }
    }

    @Override
    public void setBackground(Color col) {
        if (this.label == null) {
            this.background = col;
        } else {
            this.label.setBackground(col);
        }
        super.setBackground(col);
    }

    public void setAlignment(int align) {
        if (this.label == null) {
            this.alignment = align;
        } else {
            GridData gd = (GridData)this.label.getLayoutData();
            if (gd.horizontalAlignment != align) {
                gd.horizontalAlignment = align;
                this.label.setLayoutData((Object)gd);
            }
        }
    }

    private static String replaceHtml(String text) {
        StringBuffer buf = null;
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            String toAppend = null;
            int increment = 0;
            char ch = text.charAt(i);
            if (ch == '<') {
                if (i + 4 <= len && text.substring(i, i + 4).equalsIgnoreCase("<br>")) {
                    toAppend = "\n";
                    increment = 3;
                } else if (i + 5 <= len && text.substring(i, i + 5).equalsIgnoreCase("<br/>")) {
                    toAppend = "\n";
                    increment = 4;
                } else if (i + 4 <= len && text.substring(i, i + 4).equalsIgnoreCase("<li>")) {
                    toAppend = "- ";
                    increment = 3;
                } else if (i + 5 <= len && text.substring(i, i + 5).equalsIgnoreCase("</li>")) {
                    toAppend = "\n";
                    increment = 4;
                } else if (buf != null) {
                    buf.append(ch);
                }
            } else if (ch == '&') {
                if (i + 6 <= len && text.substring(i, i + 6).equalsIgnoreCase("&nbsp;")) {
                    toAppend = " ";
                    increment = 5;
                } else if (buf != null) {
                    buf.append(ch);
                }
            } else if (buf != null) {
                buf.append(ch);
            }
            if (toAppend != null) {
                if (buf == null) {
                    buf = new StringBuffer(text.length());
                    buf.append(text.substring(0, i));
                }
                buf.append(toAppend);
            }
            i += increment;
        }
        if (buf == null) {
            return text;
        }
        return buf.toString();
    }

    public boolean setFocus() {
        return false;
    }

    public boolean forceFocus() {
        return false;
    }

    public void makeGuiEditable(ELabelItem item) {
        super.makeGuiEditable(item, this.label);
    }
}

