/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.util;

import ch.dvbern.tax.common.presentation.cd.TaxmeConfig;
import ch.dvbern.tax.common.presentation.cd.TaxmeController;
import ch.dvbern.tax.common.presentation.cd.util.OsSupport;
import ch.dvbern.tax.common.presentation.common.util.ImageSource;
import ch.dvbern.tax.common.transfer.dto.FontDTO;
import ch.dvbern.tax.common.transfer.util.ColorConstants;
import ch.dvbern.tax.common.transfer.util.RgbColor;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GuiUtil {
    private static final Logger LOG = LoggerFactory.getLogger(GuiUtil.class);
    private static FontRegistry fontRegistry = null;
    private static ColorRegistry colorRegistry = null;
    private static ImageRegistry imageRegistry = null;
    public static final String COLOR_RED = ColorConstants.COLOR_RED.getName();
    public static final String COLOR_YELLOW = ColorConstants.COLOR_YELLOW.getName();
    public static final String COLOR_WHITE = ColorConstants.COLOR_WHITE.getName();
    public static final String COLOR_BLACK = ColorConstants.COLOR_BLACK.getName();
    public static final String COLOR_GREY = ColorConstants.COLOR_GREY.getName();
    public static final String COLOR_GREY_LIGHT = ColorConstants.COLOR_GREY_LIGHT.getName();
    public static final String COLOR_GREY_DARK = ColorConstants.COLOR_GREY_DARK.getName();
    public static final String COLOR_GREEN = ColorConstants.COLOR_GREEN.getName();
    public static final String COLOR_BLUE = ColorConstants.COLOR_BLUE.getName();
    public static final String COLOR_INPUT_FOCUS = ColorConstants.COLOR_INPUT_FOCUS.getName();
    public static final String COLOR_ORANGE = ColorConstants.COLOR_ORANGE.getName();
    public static final String COLOR_MISSING_VALUE = TaxmeConfig.getString("color.missing_value", COLOR_WHITE);
    public static final String COLOR_EDITABLE = ColorConstants.COLOR_BLUE_LIGHT.getName();
    public static final String COLOR_FORM_HEADER_FOREGROUND = ColorConstants.COLOR_FORM_HEADER_FOREGROUND.getName();
    public static final String COLOR_FORM_HEADER_BACKGROUND = ColorConstants.COLOR_FORM_HEADER_BACKGROUND.getName();
    public static final String COLOR_SECTION_HEADER_FOREGROUND = ColorConstants.COLOR_SECTION_HEADER_FOREGROUND.getName();
    public static final String COLOR_SECTION_HEADER_BACKGROUND = ColorConstants.COLOR_SECTION_HEADER_BACKGROUND.getName();
    public static final String COLOR_SECTION_HEADER_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_HEADER_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_HEADERS_FOREGROUND = ColorConstants.COLOR_SECTION_HEADERS_FOREGROUND.getName();
    public static final String COLOR_SECTION_HEADERS_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_HEADERS_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_HEADERS_BACKGROUND = ColorConstants.COLOR_SECTION_HEADERS_BACKGROUND.getName();
    public static final String COLOR_SECTION_LABEL_FOREGROUND = ColorConstants.COLOR_SECTION_LABEL_FOREGROUND.getName();
    public static final String COLOR_SECTION_LABEL_BACKGROUND = ColorConstants.COLOR_SECTION_LABEL_BACKGROUND.getName();
    public static final String COLOR_SECTION_INPUT_FOREGROUND = ColorConstants.COLOR_SECTION_INPUT_FOREGROUND.getName();
    public static final String COLOR_SECTION_INPUT_BACKGROUND = ColorConstants.COLOR_SECTION_INPUT_BACKGROUND.getName();
    public static final String COLOR_SECTION_INPUT_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_INPUT_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_INPUT_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_SECTION_INPUT_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_SECTION_INPUT_FOREGROUND_READONLY = ColorConstants.COLOR_SECTION_INPUT_FOREGROUND_READONLY.getName();
    public static final String COLOR_SECTION_INPUT_BACKGROUND_READONLY = ColorConstants.COLOR_SECTION_INPUT_BACKGROUND_READONLY.getName();
    public static final String COLOR_TABLE_HEADER_FOREGROUND = ColorConstants.COLOR_TABLE_HEADER_FOREGROUND.getName();
    public static final String COLOR_TABLE_HEADER_BACKGROUND = ColorConstants.COLOR_TABLE_HEADER_BACKGROUND.getName();
    public static final String COLOR_TABLE_HEADER_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_HEADER_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_HEADER_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_HEADER_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_HEADERS_FOREGROUND = ColorConstants.COLOR_TABLE_HEADERS_FOREGROUND.getName();
    public static final String COLOR_TABLE_HEADERS_BACKGROUND = ColorConstants.COLOR_TABLE_HEADERS_BACKGROUND.getName();
    public static final String COLOR_TABLE_CELL_FOREGROUND = ColorConstants.COLOR_TABLE_CELL_FOREGROUND.getName();
    public static final String COLOR_TABLE_CELL_BACKGROUND = ColorConstants.COLOR_TABLE_CELL_BACKGROUND.getName();
    public static final String COLOR_TABLE_CELL_FOREGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_CELL_FOREGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_CELL_BACKGROUND_TRANSPARENT = ColorConstants.COLOR_TABLE_CELL_BACKGROUND_TRANSPARENT.getName();
    public static final String COLOR_TABLE_CELL_FOREGROUND_READONLY = ColorConstants.COLOR_TABLE_CELL_FOREGROUND_READONLY.getName();
    public static final String COLOR_TABLE_CELL_BACKGROUND_READONLY = ColorConstants.COLOR_TABLE_CELL_BACKGROUND_READONLY.getName();
    public static final String FONT_NORMAL = "font.normal";
    public static final String FONT_DISABLED = "font.disabled";
    public static final String FONT_NAVIGATION = "font.navigation";
    public static final String FONT_HEADER_FORM = "font.header.form";
    public static final String FONT_HEADER_TABLE = "font.header.table";
    public static final String FONT_HEADER_SECTION = "font.header.section";
    public static final int FONT_SIZE_DEFAULT = 8;
    private static int font_size_basis;
    private static final int SCROLL_BORDER = 25;
    private static boolean useLargeFonts;

    private GuiUtil() {
    }

    public static boolean isUseLargeFonts() {
        return useLargeFonts;
    }

    public static float getZoomFactor() {
        return (float)font_size_basis / 10.0f;
    }

    public static int zoom(int x) {
        return Math.round(GuiUtil.getZoomFactor() * (float)x);
    }

    public static ColorRegistry getColorRegistry() {
        if (colorRegistry == null) {
            colorRegistry = new ColorRegistry(Display.getDefault());
            for (Object element : ColorConstants.getColors().values()) {
                RgbColor col = (RgbColor)element;
                colorRegistry.put(col.getName(), new RGB(col.getRed(), col.getGreen(), col.getBlue()));
            }
        }
        return colorRegistry;
    }

    public static FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            GuiUtil.initializeFontRegistry();
        }
        return fontRegistry;
    }

    public static @NonNull Font toFont(@NonNull FontDTO fontDTO) {
        if (fontDTO == null) {
            throw new NullPointerException("Font DTO cannot be null.");
        }
        String symbolicName = fontDTO.toString();
        if (!fontRegistry.hasValueFor(symbolicName)) {
            FontData fd = new FontData();
            String name = fontDTO.getName();
            if (name == null) {
                name = "Helvetica";
            }
            fd.setName(name);
            fd.setHeight(Math.round(fontDTO.getSize() + (float)(TaxmeController.getInstance().isUseLargeFonts() ? 2 : 0)));
            int style = 0;
            if ((fontDTO.getStyle() & 1) != 0) {
                style |= 1;
            }
            if ((fontDTO.getStyle() & 2) != 0) {
                style |= 2;
            }
            fd.setStyle(style);
            fontRegistry.put(symbolicName, new FontData[]{fd});
        }
        return fontRegistry.get(symbolicName);
    }

    public static void registerFont(@NonNull String symbolicName, int size, int style) {
        Objects.requireNonNull(symbolicName, "Symbolic name cannot be null.");
        GuiUtil.getFontRegistry().put(symbolicName, new FontData[]{new FontData("Arial", size, style)});
    }

    public static void registerColor(@NonNull String symbolicName, int red, int green, int blue) {
        Objects.requireNonNull(symbolicName, "Symbolic name cannot be null.");
        GuiUtil.getColorRegistry().put(symbolicName, new RGB(red, green, blue));
    }

    public static void registerIcon(@NonNull String symbolicName, @NonNull String filename) {
        Objects.requireNonNull(symbolicName, "Symbolic name cannot be null.");
        Objects.requireNonNull(symbolicName, "Icon filename cannot be null.");
        GuiUtil.getImageRegistry().put(symbolicName, GuiUtil.createIconDesc(filename));
    }

    public static void setUseLargeFonts(boolean large) {
        GuiUtil.disposeFontRegistry();
        if (large) {
            GuiUtil.getLargeFontRegistry();
        } else {
            GuiUtil.getSmallFontRegistry();
        }
        useLargeFonts = large;
    }

    public static void initializeFontRegistry() {
        boolean large = OsSupport.isLinuxOs() ? TaxmeConfig.getBoolean("fonts.large") : OsSupport.isMacOs();
        GuiUtil.setUseLargeFonts(large);
    }

    public static void setFontSize(int fontSize) {
        font_size_basis = fontSize;
        TaxmeConfig.setValue("font.size", fontSize);
        GuiUtil.disposeFontRegistry();
    }

    private static void getSmallFontRegistry() {
        String fontname = "Arial";
        fontRegistry = new FontRegistry(Display.getDefault());
        fontRegistry.put(FONT_NORMAL, new FontData[]{new FontData("Arial", font_size_basis, 0)});
        fontRegistry.put(FONT_DISABLED, new FontData[]{new FontData("Arial", font_size_basis, 1)});
        fontRegistry.put(FONT_NAVIGATION, new FontData[]{new FontData("Arial", font_size_basis, 0)});
        fontRegistry.put(FONT_HEADER_FORM, new FontData[]{new FontData("Arial", font_size_basis + 4, 1)});
        fontRegistry.put(FONT_HEADER_TABLE, new FontData[]{new FontData("Arial", font_size_basis + 2, 1)});
        fontRegistry.put(FONT_HEADER_SECTION, new FontData[]{new FontData("Arial", font_size_basis + 2, 1)});
    }

    private static void getLargeFontRegistry() {
        String fontname = "Arial";
        fontRegistry = new FontRegistry(Display.getDefault());
        fontRegistry.put(FONT_NORMAL, new FontData[]{new FontData("Arial", font_size_basis + 3, 0)});
        fontRegistry.put(FONT_DISABLED, new FontData[]{new FontData("Arial", font_size_basis + 3, 0)});
        fontRegistry.put(FONT_NAVIGATION, new FontData[]{new FontData("Arial", font_size_basis + 3, 0)});
        fontRegistry.put(FONT_HEADER_FORM, new FontData[]{new FontData("Arial", font_size_basis + 6, 1)});
        fontRegistry.put(FONT_HEADER_TABLE, new FontData[]{new FontData("Arial", font_size_basis + 4, 1)});
        fontRegistry.put(FONT_HEADER_SECTION, new FontData[]{new FontData("Arial", font_size_basis + 4, 1)});
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(Display.getDefault());
            imageRegistry.put("icon.state.error", GuiUtil.createIconDesc("icon-fehler.gif"));
            imageRegistry.put("icon.state.error.transparent", GuiUtil.createIconDesc("icon-fehler-disabled.gif"));
            imageRegistry.put("icon.state.ok", GuiUtil.createIconDesc("icon-abgeschlossen.gif"));
            imageRegistry.put("icon.state.ok.transparent", GuiUtil.createIconDesc("icon-abgeschlossen-disabled.gif"));
            imageRegistry.put("icon.state.missingvalue", GuiUtil.createIconDesc("icon-inbearbeitung.gif"));
            imageRegistry.put("icon.state.missingvalue.transparent", GuiUtil.createIconDesc("icon-inbearbeitung-disabled.gif"));
            imageRegistry.put("icon.state.warning", GuiUtil.createIconDesc("icon-warnung.gif"));
            imageRegistry.put("icon.state.warning.transparent", GuiUtil.createIconDesc("icon-warnung-disabled.gif"));
            imageRegistry.put("icon.state.transparent", GuiUtil.createIconDesc("icon_crossed.gif"));
            imageRegistry.put("icon.state.transparent.transparent", GuiUtil.createIconDesc("icon_crossed_disabled.gif"));
            imageRegistry.put("icon.button.add", GuiUtil.createIconDesc("icon_add.gif"));
            imageRegistry.put("icon.button.edit", GuiUtil.createIconDesc("icon_edit.gif"));
            imageRegistry.put("icon.button.delete", GuiUtil.createIconDesc("delete.gif"));
            imageRegistry.put("icon.button.ok", GuiUtil.createIconDesc("ok.gif"));
            imageRegistry.put("icon.button.cancel", GuiUtil.createIconDesc("cancel.gif"));
            imageRegistry.put("icon.button.previous", GuiUtil.createIconDesc("previous.gif"));
            imageRegistry.put("icon.button.next", GuiUtil.createIconDesc("next.gif"));
            imageRegistry.put("image.about", GuiUtil.createIconDesc("about.gif"));
            imageRegistry.put("table.new.row", GuiUtil.createIconDesc("newRow.gif"));
            imageRegistry.put("icon.window.app", GuiUtil.createIconDesc("mainframe16.gif"));
            imageRegistry.put("icon.window.about", GuiUtil.createIconDesc("mainframe16.gif"));
            imageRegistry.put("icon.menu.file.dossier", GuiUtil.createIconDesc("dossier.gif"));
            imageRegistry.put("icon.menu.file.dossier.disabled", GuiUtil.createIconDesc("dossier-disabled.gif"));
            imageRegistry.put("icon.menu.edit.redo", GuiUtil.createIconDesc("redo.gif"));
            imageRegistry.put("icon.menu.edit.redo.disabled", GuiUtil.createIconDesc("redo-disabled.gif"));
            imageRegistry.put("icon.menu.edit.undo", GuiUtil.createIconDesc("undo.gif"));
            imageRegistry.put("icon.menu.edit.undo.disabled", GuiUtil.createIconDesc("undo-disabled.gif"));
            imageRegistry.put("icon.menu.file.close", GuiUtil.createIconDesc("close.gif"));
            imageRegistry.put("icon.menu.file.close.disabled", GuiUtil.createIconDesc("close-disabled.gif"));
            imageRegistry.put("icon.menu.file.exit", GuiUtil.createIconDesc("cancel.gif"));
            imageRegistry.put("icon.menu.file.exit.disabled", GuiUtil.createIconDesc("cancel-disabled.gif"));
            imageRegistry.put("icon.menu.file.new", GuiUtil.createIconDesc("new.gif"));
            imageRegistry.put("icon.menu.file.new.disabled", GuiUtil.createIconDesc("new-disabled.gif"));
            imageRegistry.put("icon.menu.file.open", GuiUtil.createIconDesc("open.gif"));
            imageRegistry.put("icon.menu.file.open.disabled", GuiUtil.createIconDesc("open-disabled.gif"));
            imageRegistry.put("icon.menu.file.import", GuiUtil.createIconDesc("import.gif"));
            imageRegistry.put("icon.menu.file.import.disabled", GuiUtil.createIconDesc("import-disabled.gif"));
            imageRegistry.put("icon.menu.file.print", GuiUtil.createIconDesc("print.gif"));
            imageRegistry.put("icon.menu.file.print.disabled", GuiUtil.createIconDesc("print-disabled.gif"));
            imageRegistry.put("icon.menu.file.save", GuiUtil.createIconDesc("save.gif"));
            imageRegistry.put("icon.menu.file.save.disabled", GuiUtil.createIconDesc("save-disabled.gif"));
            imageRegistry.put("icon.menu.file.save.as", GuiUtil.createIconDesc("save.gif"));
            imageRegistry.put("icon.menu.file.save.as.disabled", GuiUtil.createIconDesc("save-disabled.gif"));
            imageRegistry.put("icon.menu.help.mainhelp", GuiUtil.createIconDesc("mainHelp.gif"));
            imageRegistry.put("icon.menu.help.mainhelp.disabled", GuiUtil.createIconDesc("mainHelp-disabled.gif"));
            imageRegistry.put("icon.menu.help.shorthelp", GuiUtil.createIconDesc("help.gif"));
            imageRegistry.put("icon.menu.help.shorthelp.disabled", GuiUtil.createIconDesc("help-disabled.gif"));
            imageRegistry.put("icon.menu.layout.classic", GuiUtil.createIconDesc("classicLayout.png"));
            imageRegistry.put("icon.menu.layout.classic.disabled", GuiUtil.createIconDesc("classicLayout-disabled.png"));
            imageRegistry.put("icon.menu.layout.horizontal", GuiUtil.createIconDesc("horizontalLayout.png"));
            imageRegistry.put("icon.menu.layout.horizontal.disabled", GuiUtil.createIconDesc("horizontalLayout-disabled.png"));
            imageRegistry.put("icon.menu.view.mode.expert", GuiUtil.createIconDesc("expert.gif"));
            imageRegistry.put("icon.menu.view.mode.expert.disabled", GuiUtil.createIconDesc("expert-disabled.gif"));
            imageRegistry.put("icon.menu.view.mode.wizard", GuiUtil.createIconDesc("wizard.gif"));
            imageRegistry.put("icon.menu.view.mode.wizard.disabled", GuiUtil.createIconDesc("wizard-disabled.gif"));
            imageRegistry.put("icon.menu.util.model.reload", GuiUtil.createIconDesc("reload.gif"));
            imageRegistry.put("icon.menu.util.save.gui.edits", GuiUtil.createIconDesc("saveguiedits.gif"));
            imageRegistry.put("icon.help.back", GuiUtil.createIconDesc("helpback.gif"));
            imageRegistry.put("icon.help.back.disabled", GuiUtil.createIconDesc("helpback-disabled.gif"));
            imageRegistry.put("icon.help.next", GuiUtil.createIconDesc("helpvor.gif"));
            imageRegistry.put("icon.help.next.disabled", GuiUtil.createIconDesc("helpvor-disabled.gif"));
            imageRegistry.put("icon.help.tree.opened", GuiUtil.createIconDesc("helpopened.gif"));
            imageRegistry.put("icon.help.tree.closed", GuiUtil.createIconDesc("helpclosed.gif"));
            imageRegistry.put("icon.help.tree.leaf", GuiUtil.createIconDesc("helpleaf.gif"));
            imageRegistry.put("icon.help.menu.quit", GuiUtil.createIconDesc("quitHelp.gif"));
            imageRegistry.put("icon.help.menu.index", GuiUtil.createIconDesc("helpIndex.gif"));
            imageRegistry.put("icon.help.menu.bedienung", GuiUtil.createIconDesc("helpWindow.gif"));
            imageRegistry.put("icon.help.menu.wegleitung", GuiUtil.createIconDesc("helpWegleitung.gif"));
            imageRegistry.put("icon.link.www", GuiUtil.createIconDesc("site.gif"));
            imageRegistry.put("icon.upload", GuiUtil.createIconDesc("upload.gif"));
            imageRegistry.put("icon.upload.disabled", GuiUtil.createIconDesc("upload-disabled.gif"));
            imageRegistry.put("icon.menu.file.show", GuiUtil.createIconDesc("show.gif"));
        }
        return imageRegistry;
    }

    private static void disposeFontRegistry() {
        if (fontRegistry != null) {
            for (Object o : fontRegistry.getKeySet()) {
                fontRegistry.get((String)o).dispose();
            }
            fontRegistry = null;
        }
    }

    public static Image createStateImage(int state, boolean enabled) {
        switch (state) {
            case 3: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.missingvalue") : GuiUtil.getImageRegistry().get("icon.state.missingvalue.transparent");
            }
            case 4: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.error") : GuiUtil.getImageRegistry().get("icon.state.error.transparent");
            }
            case 2: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.warning") : GuiUtil.getImageRegistry().get("icon.state.warning.transparent");
            }
            case 11: 
            case 12: {
                return enabled ? GuiUtil.getImageRegistry().get("icon.state.transparent") : GuiUtil.getImageRegistry().get("icon.state.transparent.transparent");
            }
        }
        return enabled ? GuiUtil.getImageRegistry().get("icon.state.ok") : GuiUtil.getImageRegistry().get("icon.state.ok.transparent");
    }

    private static ImageDescriptor createIconDesc(String name) {
        try {
            URL url = new URL("file:" + TaxmeConfig.getIconFilePath(name));
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("malformed url", e);
        }
    }

    public static void scrollToVisible(ScrolledComposite composite, Rectangle rect) {
        if (composite == null || rect == null) {
            return;
        }
        if (rect.y > 25) {
            rect.y -= 25;
        }
        rect.height += 50;
        Point orig = composite.getOrigin();
        if (rect.y < orig.y) {
            orig.y = rect.y;
            composite.setOrigin(orig);
        } else {
            Rectangle ca = composite.getClientArea();
            int bottomDiff = rect.y + rect.height - (orig.y + ca.height);
            if (bottomDiff > 0) {
                orig.y += bottomDiff;
                composite.setOrigin(orig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Image getImage(ImageSource imageSource, String name, ImageRegistry imageRegistry) {
        Image img = imageRegistry.get(name);
        if (img == null) {
            InputStream is = null;
            try {
                is = imageSource.getImageAsStream(name);
                img = new Image((Device)Display.getCurrent(), is);
                imageRegistry.put(name, img);
            }
            catch (IOException e) {
                LOG.error("Error on " + name, (Throwable)e);
                Image image = null;
                return image;
            }
            finally {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e) {
                        LOG.error("Could not close input stream: ", (Throwable)e);
                    }
                }
            }
        }
        return img;
    }

    static {
        int fontsize = TaxmeConfig.getInt("font.size");
        if (fontsize == 0) {
            fontsize = 8;
        }
        font_size_basis = fontsize;
    }
}

