/*
 * Decompiled with CFR 0.152.
 */
package ch.dvbern.tax.common.presentation.cd.parts;

import ch.dvbern.tax.common.presentation.cd.items.ITableRow;
import ch.dvbern.tax.common.presentation.cd.items.IValueItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Image;

public class TableLabelProvider
implements ITableLabelProvider {
    private final List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return true;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Assert.isTrue((boolean)(element instanceof ITableRow));
        ITableRow row = (ITableRow)element;
        if (columnIndex == 0 && !row.getTable().isReadOnly()) {
            return ((ITableRow)element).getStateIcon();
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IValueItem item = this.getValueItem(element, columnIndex);
        if (item != null) {
            return item.getRenderedValue();
        }
        return "";
    }

    public Object getValue(Object element, int columnIndex) {
        IValueItem item = this.getValueItem(element, columnIndex);
        if (item != null) {
            return item.getValue();
        }
        return null;
    }

    protected IValueItem getValueItem(Object element, int columnIndex) {
        Object cell;
        Assert.isTrue((boolean)(element instanceof ITableRow));
        ITableRow row = (ITableRow)element;
        if (!row.getTable().isFirstColumnStatus()) {
            if (columnIndex == 0) {
                return null;
            }
            --columnIndex;
        }
        if ((cell = row.getCells().get(columnIndex)) instanceof IValueItem) {
            return (IValueItem)cell;
        }
        return null;
    }
}

